/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.stax.events;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.stax.events.AttributeBase;
import com.sun.xml.internal.fastinfoset.stax.events.EndDocumentEvent;
import com.sun.xml.internal.fastinfoset.stax.events.EndElementEvent;
import com.sun.xml.internal.fastinfoset.stax.events.EntityDeclarationImpl;
import com.sun.xml.internal.fastinfoset.stax.events.StartDocumentEvent;
import com.sun.xml.internal.fastinfoset.stax.events.StartElementEvent;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.stream.util.XMLEventConsumer;

public class StAXEventAllocatorBase
implements XMLEventAllocator {
    XMLEventFactory factory;

    public StAXEventAllocatorBase() {
        if (System.getProperty("javax.xml.stream.XMLEventFactory") == null) {
            System.setProperty("javax.xml.stream.XMLEventFactory", "com.sun.xml.internal.fastinfoset.stax.factory.StAXEventFactory");
        }
        this.factory = XMLEventFactory.newInstance();
    }

    @Override
    public XMLEventAllocator newInstance() {
        return new StAXEventAllocatorBase();
    }

    @Override
    public XMLEvent allocate(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        if (xMLStreamReader == null) {
            throw new XMLStreamException(CommonResourceBundle.getInstance().getString("message.nullReader"));
        }
        return this.getXMLEvent(xMLStreamReader);
    }

    @Override
    public void allocate(XMLStreamReader xMLStreamReader, XMLEventConsumer xMLEventConsumer) throws XMLStreamException {
        xMLEventConsumer.add(this.getXMLEvent(xMLStreamReader));
    }

    XMLEvent getXMLEvent(XMLStreamReader xMLStreamReader) {
        XMLEvent xMLEvent = null;
        int n = xMLStreamReader.getEventType();
        this.factory.setLocation(xMLStreamReader.getLocation());
        switch (n) {
            case 1: {
                StartElementEvent startElementEvent = (StartElementEvent)this.factory.createStartElement(xMLStreamReader.getPrefix(), xMLStreamReader.getNamespaceURI(), xMLStreamReader.getLocalName());
                this.addAttributes(startElementEvent, xMLStreamReader);
                this.addNamespaces(startElementEvent, xMLStreamReader);
                xMLEvent = startElementEvent;
                break;
            }
            case 2: {
                EndElementEvent endElementEvent = (EndElementEvent)this.factory.createEndElement(xMLStreamReader.getPrefix(), xMLStreamReader.getNamespaceURI(), xMLStreamReader.getLocalName());
                this.addNamespaces(endElementEvent, xMLStreamReader);
                xMLEvent = endElementEvent;
                break;
            }
            case 3: {
                xMLEvent = this.factory.createProcessingInstruction(xMLStreamReader.getPITarget(), xMLStreamReader.getPIData());
                break;
            }
            case 4: {
                if (xMLStreamReader.isWhiteSpace()) {
                    xMLEvent = this.factory.createSpace(xMLStreamReader.getText());
                    break;
                }
                xMLEvent = this.factory.createCharacters(xMLStreamReader.getText());
                break;
            }
            case 5: {
                xMLEvent = this.factory.createComment(xMLStreamReader.getText());
                break;
            }
            case 7: {
                StartDocumentEvent startDocumentEvent = (StartDocumentEvent)this.factory.createStartDocument(xMLStreamReader.getVersion(), xMLStreamReader.getEncoding(), xMLStreamReader.isStandalone());
                if (xMLStreamReader.getCharacterEncodingScheme() != null) {
                    startDocumentEvent.setDeclaredEncoding(true);
                } else {
                    startDocumentEvent.setDeclaredEncoding(false);
                }
                xMLEvent = startDocumentEvent;
                break;
            }
            case 8: {
                EndDocumentEvent endDocumentEvent = new EndDocumentEvent();
                xMLEvent = endDocumentEvent;
                break;
            }
            case 9: {
                xMLEvent = this.factory.createEntityReference(xMLStreamReader.getLocalName(), new EntityDeclarationImpl(xMLStreamReader.getLocalName(), xMLStreamReader.getText()));
                break;
            }
            case 10: {
                xMLEvent = null;
                break;
            }
            case 11: {
                xMLEvent = this.factory.createDTD(xMLStreamReader.getText());
                break;
            }
            case 12: {
                xMLEvent = this.factory.createCData(xMLStreamReader.getText());
                break;
            }
            case 6: {
                xMLEvent = this.factory.createSpace(xMLStreamReader.getText());
            }
        }
        return xMLEvent;
    }

    protected void addAttributes(StartElementEvent startElementEvent, XMLStreamReader xMLStreamReader) {
        AttributeBase attributeBase = null;
        for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
            attributeBase = (AttributeBase)this.factory.createAttribute(xMLStreamReader.getAttributeName(i), xMLStreamReader.getAttributeValue(i));
            attributeBase.setAttributeType(xMLStreamReader.getAttributeType(i));
            attributeBase.setSpecified(xMLStreamReader.isAttributeSpecified(i));
            startElementEvent.addAttribute(attributeBase);
        }
    }

    protected void addNamespaces(StartElementEvent startElementEvent, XMLStreamReader xMLStreamReader) {
        Namespace namespace = null;
        for (int i = 0; i < xMLStreamReader.getNamespaceCount(); ++i) {
            namespace = this.factory.createNamespace(xMLStreamReader.getNamespacePrefix(i), xMLStreamReader.getNamespaceURI(i));
            startElementEvent.addNamespace(namespace);
        }
    }

    protected void addNamespaces(EndElementEvent endElementEvent, XMLStreamReader xMLStreamReader) {
        Namespace namespace = null;
        for (int i = 0; i < xMLStreamReader.getNamespaceCount(); ++i) {
            namespace = this.factory.createNamespace(xMLStreamReader.getNamespacePrefix(i), xMLStreamReader.getNamespaceURI(i));
            endElementEvent.addNamespace(namespace);
        }
    }
}

