/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.addressing;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.server.BoundEndpoint;
import com.sun.xml.internal.ws.api.server.Module;
import com.sun.xml.internal.ws.api.server.SDDocument;
import com.sun.xml.internal.ws.api.server.SDDocumentFilter;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.server.WSEndpointImpl;
import com.sun.xml.internal.ws.util.xml.XMLStreamReaderToXMLStreamWriter;
import com.sun.xml.internal.ws.util.xml.XMLStreamWriterFilter;
import com.sun.xml.internal.ws.wsdl.parser.WSDLConstants;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class EPRSDDocumentFilter
implements SDDocumentFilter {
    private final WSEndpointImpl<?> endpoint;
    List<BoundEndpoint> beList;

    public EPRSDDocumentFilter(@NotNull WSEndpointImpl<?> wSEndpointImpl) {
        this.endpoint = wSEndpointImpl;
    }

    @Nullable
    private WSEndpointImpl<?> getEndpoint(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        if (this.endpoint.getServiceName().getLocalPart().equals(string) && this.endpoint.getPortName().getLocalPart().equals(string2)) {
            return this.endpoint;
        }
        if (this.beList == null) {
            Module module = this.endpoint.getContainer().getSPI(Module.class);
            this.beList = module != null ? module.getBoundEndpoints() : Collections.emptyList();
        }
        for (BoundEndpoint boundEndpoint : this.beList) {
            WSEndpoint wSEndpoint = boundEndpoint.getEndpoint();
            if (!wSEndpoint.getServiceName().getLocalPart().equals(string) || !wSEndpoint.getPortName().getLocalPart().equals(string2)) continue;
            return (WSEndpointImpl)wSEndpoint;
        }
        return null;
    }

    @Override
    public XMLStreamWriter filter(SDDocument sDDocument, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, IOException {
        if (!sDDocument.isWSDL()) {
            return xMLStreamWriter;
        }
        return new XMLStreamWriterFilter(xMLStreamWriter){
            private boolean eprExtnFilterON;
            private boolean portHasEPR;
            private int eprDepth;
            private String serviceName;
            private boolean onService;
            private int serviceDepth;
            private String portName;
            private boolean onPort;
            private int portDepth;
            private String portAddress;
            private boolean onPortAddress;
            {
                this.eprExtnFilterON = false;
                this.portHasEPR = false;
                this.eprDepth = -1;
                this.serviceName = null;
                this.onService = false;
                this.serviceDepth = -1;
                this.portName = null;
                this.onPort = false;
                this.portDepth = -1;
                this.onPortAddress = false;
            }

            private void handleStartElement(String string, String string2) throws XMLStreamException {
                this.resetOnElementFlags();
                if (this.serviceDepth >= 0) {
                    ++this.serviceDepth;
                }
                if (this.portDepth >= 0) {
                    ++this.portDepth;
                }
                if (this.eprDepth >= 0) {
                    ++this.eprDepth;
                }
                if (string2.equals(WSDLConstants.QNAME_SERVICE.getNamespaceURI()) && string.equals(WSDLConstants.QNAME_SERVICE.getLocalPart())) {
                    this.onService = true;
                    this.serviceDepth = 0;
                } else if (string2.equals(WSDLConstants.QNAME_PORT.getNamespaceURI()) && string.equals(WSDLConstants.QNAME_PORT.getLocalPart())) {
                    if (this.serviceDepth >= 1) {
                        this.onPort = true;
                        this.portDepth = 0;
                    }
                } else if (string2.equals("http://www.w3.org/2005/08/addressing") && string.equals("EndpointReference")) {
                    if (this.serviceDepth >= 1 && this.portDepth >= 1) {
                        this.portHasEPR = true;
                        this.eprDepth = 0;
                    }
                } else if ((string2.equals(WSDLConstants.NS_SOAP_BINDING_ADDRESS.getNamespaceURI()) || string2.equals(WSDLConstants.NS_SOAP12_BINDING_ADDRESS.getNamespaceURI())) && string.equals("address") && this.portDepth == 1) {
                    this.onPortAddress = true;
                }
                WSEndpointImpl wSEndpointImpl = EPRSDDocumentFilter.this.getEndpoint(this.serviceName, this.portName);
                if (wSEndpointImpl != null && this.eprDepth == 1 && !string2.equals("http://www.w3.org/2005/08/addressing")) {
                    this.eprExtnFilterON = true;
                }
            }

            private void resetOnElementFlags() {
                if (this.onService) {
                    this.onService = false;
                }
                if (this.onPort) {
                    this.onPort = false;
                }
                if (this.onPortAddress) {
                    this.onPortAddress = false;
                }
            }

            private void writeEPRExtensions(Collection<WSEndpointReference.EPRExtension> collection) throws XMLStreamException {
                if (collection != null) {
                    for (WSEndpointReference.EPRExtension ePRExtension : collection) {
                        XMLStreamReaderToXMLStreamWriter xMLStreamReaderToXMLStreamWriter = new XMLStreamReaderToXMLStreamWriter();
                        XMLStreamReader xMLStreamReader = ePRExtension.readAsXMLStreamReader();
                        xMLStreamReaderToXMLStreamWriter.bridge(xMLStreamReader, this.writer);
                        XMLStreamReaderFactory.recycle(xMLStreamReader);
                    }
                }
            }

            @Override
            public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
                this.handleStartElement(string2, string3);
                if (!this.eprExtnFilterON) {
                    super.writeStartElement(string, string2, string3);
                }
            }

            @Override
            public void writeStartElement(String string, String string2) throws XMLStreamException {
                this.handleStartElement(string2, string);
                if (!this.eprExtnFilterON) {
                    super.writeStartElement(string, string2);
                }
            }

            @Override
            public void writeStartElement(String string) throws XMLStreamException {
                if (!this.eprExtnFilterON) {
                    super.writeStartElement(string);
                }
            }

            private void handleEndElement() throws XMLStreamException {
                this.resetOnElementFlags();
                if (this.portDepth == 0 && !this.portHasEPR && EPRSDDocumentFilter.this.getEndpoint(this.serviceName, this.portName) != null) {
                    this.writer.writeStartElement(AddressingVersion.W3C.getPrefix(), "EndpointReference", AddressingVersion.W3C.nsUri);
                    this.writer.writeNamespace(AddressingVersion.W3C.getPrefix(), AddressingVersion.W3C.nsUri);
                    this.writer.writeStartElement(AddressingVersion.W3C.getPrefix(), AddressingVersion.W3C.eprType.address, AddressingVersion.W3C.nsUri);
                    this.writer.writeCharacters(this.portAddress);
                    this.writer.writeEndElement();
                    this.writeEPRExtensions(EPRSDDocumentFilter.this.getEndpoint(this.serviceName, this.portName).getEndpointReferenceExtensions());
                    this.writer.writeEndElement();
                }
                if (this.eprDepth == 0) {
                    if (this.portHasEPR && EPRSDDocumentFilter.this.getEndpoint(this.serviceName, this.portName) != null) {
                        this.writeEPRExtensions(EPRSDDocumentFilter.this.getEndpoint(this.serviceName, this.portName).getEndpointReferenceExtensions());
                    }
                    this.eprExtnFilterON = false;
                }
                if (this.serviceDepth >= 0) {
                    --this.serviceDepth;
                }
                if (this.portDepth >= 0) {
                    --this.portDepth;
                }
                if (this.eprDepth >= 0) {
                    --this.eprDepth;
                }
                if (this.serviceDepth == -1) {
                    this.serviceName = null;
                }
                if (this.portDepth == -1) {
                    this.portHasEPR = false;
                    this.portAddress = null;
                    this.portName = null;
                }
            }

            @Override
            public void writeEndElement() throws XMLStreamException {
                this.handleEndElement();
                if (!this.eprExtnFilterON) {
                    super.writeEndElement();
                }
            }

            private void handleAttribute(String string, String string2) {
                if (string.equals("name")) {
                    if (this.onService) {
                        this.serviceName = string2;
                        this.onService = false;
                    } else if (this.onPort) {
                        this.portName = string2;
                        this.onPort = false;
                    }
                }
                if (string.equals("location") && this.onPortAddress) {
                    this.portAddress = string2;
                }
            }

            @Override
            public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
                this.handleAttribute(string3, string4);
                if (!this.eprExtnFilterON) {
                    super.writeAttribute(string, string2, string3, string4);
                }
            }

            @Override
            public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
                this.handleAttribute(string2, string3);
                if (!this.eprExtnFilterON) {
                    super.writeAttribute(string, string2, string3);
                }
            }

            @Override
            public void writeAttribute(String string, String string2) throws XMLStreamException {
                this.handleAttribute(string, string2);
                if (!this.eprExtnFilterON) {
                    super.writeAttribute(string, string2);
                }
            }

            @Override
            public void writeEmptyElement(String string, String string2) throws XMLStreamException {
                if (!this.eprExtnFilterON) {
                    super.writeEmptyElement(string, string2);
                }
            }

            @Override
            public void writeNamespace(String string, String string2) throws XMLStreamException {
                if (!this.eprExtnFilterON) {
                    super.writeNamespace(string, string2);
                }
            }

            @Override
            public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
                if (!this.eprExtnFilterON) {
                    super.setNamespaceContext(namespaceContext);
                }
            }

            @Override
            public void setDefaultNamespace(String string) throws XMLStreamException {
                if (!this.eprExtnFilterON) {
                    super.setDefaultNamespace(string);
                }
            }

            @Override
            public void setPrefix(String string, String string2) throws XMLStreamException {
                if (!this.eprExtnFilterON) {
                    super.setPrefix(string, string2);
                }
            }

            @Override
            public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
                if (!this.eprExtnFilterON) {
                    super.writeProcessingInstruction(string, string2);
                }
            }

            @Override
            public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
                if (!this.eprExtnFilterON) {
                    super.writeEmptyElement(string, string2, string3);
                }
            }

            @Override
            public void writeCData(String string) throws XMLStreamException {
                if (!this.eprExtnFilterON) {
                    super.writeCData(string);
                }
            }

            @Override
            public void writeCharacters(String string) throws XMLStreamException {
                if (!this.eprExtnFilterON) {
                    super.writeCharacters(string);
                }
            }

            @Override
            public void writeComment(String string) throws XMLStreamException {
                if (!this.eprExtnFilterON) {
                    super.writeComment(string);
                }
            }

            @Override
            public void writeDTD(String string) throws XMLStreamException {
                if (!this.eprExtnFilterON) {
                    super.writeDTD(string);
                }
            }

            @Override
            public void writeDefaultNamespace(String string) throws XMLStreamException {
                if (!this.eprExtnFilterON) {
                    super.writeDefaultNamespace(string);
                }
            }

            @Override
            public void writeEmptyElement(String string) throws XMLStreamException {
                if (!this.eprExtnFilterON) {
                    super.writeEmptyElement(string);
                }
            }

            @Override
            public void writeEntityRef(String string) throws XMLStreamException {
                if (!this.eprExtnFilterON) {
                    super.writeEntityRef(string);
                }
            }

            @Override
            public void writeProcessingInstruction(String string) throws XMLStreamException {
                if (!this.eprExtnFilterON) {
                    super.writeProcessingInstruction(string);
                }
            }

            @Override
            public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
                if (!this.eprExtnFilterON) {
                    super.writeCharacters(cArray, n, n2);
                }
            }
        };
    }
}

