/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.util.Calendar;

class CalendarBuilder {
    private static final int UNSET = 0;
    private static final int COMPUTED = 1;
    private static final int MINIMUM_USER_STAMP = 2;
    private static final int MAX_FIELD = 18;
    public static final int WEEK_YEAR = 17;
    public static final int ISO_DAY_OF_WEEK = 1000;
    private final int[] field = new int[36];
    private int nextStamp = 2;
    private int maxFieldIndex = -1;

    CalendarBuilder() {
    }

    CalendarBuilder set(int n, int n2) {
        if (n == 1000) {
            n = 7;
            n2 = CalendarBuilder.toCalendarDayOfWeek(n2);
        }
        ++this.nextStamp;
        this.field[18 + n] = n2;
        if (n > this.maxFieldIndex && n < 17) {
            this.maxFieldIndex = n;
        }
        return this;
    }

    CalendarBuilder addYear(int n) {
        this.field[19] = this.field[19] + n;
        this.field[35] = this.field[35] + n;
        return this;
    }

    boolean isSet(int n) {
        if (n == 1000) {
            n = 7;
        }
        return this.field[n] > 0;
    }

    Calendar establish(Calendar calendar) {
        int n;
        int n2;
        boolean bl;
        boolean bl2 = bl = this.isSet(17) && this.field[17] > this.field[1];
        if (bl && !calendar.isWeekDateSupported()) {
            if (!this.isSet(1)) {
                this.set(1, this.field[35]);
            }
            bl = false;
        }
        calendar.clear();
        block0: for (n2 = 2; n2 < this.nextStamp; ++n2) {
            for (n = 0; n <= this.maxFieldIndex; ++n) {
                if (this.field[n] != n2) continue;
                calendar.set(n, this.field[18 + n]);
                continue block0;
            }
        }
        if (bl) {
            n2 = this.isSet(3) ? this.field[21] : 1;
            int n3 = n = this.isSet(7) ? this.field[25] : calendar.getFirstDayOfWeek();
            if (!CalendarBuilder.isValidDayOfWeek(n) && calendar.isLenient()) {
                if (n >= 8) {
                    n2 += --n / 7;
                    n = n % 7 + 1;
                } else {
                    while (n <= 0) {
                        n += 7;
                        --n2;
                    }
                }
                n = CalendarBuilder.toCalendarDayOfWeek(n);
            }
            calendar.setWeekDate(this.field[35], n2, n);
        }
        return calendar;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CalendarBuilder:[");
        for (n = 0; n < this.field.length; ++n) {
            if (!this.isSet(n)) continue;
            stringBuilder.append(n).append('=').append(this.field[18 + n]).append(',');
        }
        n = stringBuilder.length() - 1;
        if (stringBuilder.charAt(n) == ',') {
            stringBuilder.setLength(n);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static int toISODayOfWeek(int n) {
        return n == 1 ? 7 : n - 1;
    }

    static int toCalendarDayOfWeek(int n) {
        if (!CalendarBuilder.isValidDayOfWeek(n)) {
            return n;
        }
        return n == 7 ? 1 : n + 1;
    }

    static boolean isValidDayOfWeek(int n) {
        return n > 0 && n <= 7;
    }
}

