/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.ast;

import sun.org.mozilla.javascript.internal.ast.Jump;
import sun.org.mozilla.javascript.internal.ast.Loop;
import sun.org.mozilla.javascript.internal.ast.Name;
import sun.org.mozilla.javascript.internal.ast.NodeVisitor;

public class ContinueStatement
extends Jump {
    private Name label;
    private Loop target;

    public ContinueStatement() {
        this.type = 121;
    }

    public ContinueStatement(int n) {
        this(n, -1);
    }

    public ContinueStatement(int n, int n2) {
        this.type = 121;
        this.position = n;
        this.length = n2;
    }

    public ContinueStatement(Name name) {
        this.type = 121;
        this.setLabel(name);
    }

    public ContinueStatement(int n, Name name) {
        this(n);
        this.setLabel(name);
    }

    public ContinueStatement(int n, int n2, Name name) {
        this(n, n2);
        this.setLabel(name);
    }

    public Loop getTarget() {
        return this.target;
    }

    public void setTarget(Loop loop) {
        this.assertNotNull(loop);
        this.target = loop;
        this.setJumpStatement(loop);
    }

    public Name getLabel() {
        return this.label;
    }

    public void setLabel(Name name) {
        this.label = name;
        if (name != null) {
            name.setParent(this);
        }
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("continue");
        if (this.label != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.label.toSource(0));
        }
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this) && this.label != null) {
            this.label.visit(nodeVisitor);
        }
    }
}

