/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx;

import com.sun.applet2.Applet2;
import com.sun.applet2.Applet2Context;
import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.AppletInitEvent;
import com.sun.applet2.preloader.event.DownloadEvent;
import com.sun.applet2.preloader.event.ErrorEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.applet2.preloader.event.UserDeclinedEvent;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.Applet2Adapter;
import com.sun.deploy.uitoolkit.impl.fx.DeployPerfLogger;
import com.sun.deploy.uitoolkit.impl.fx.FXApplet2Adapter;
import com.sun.deploy.uitoolkit.impl.fx.FXPluginToolkit;
import com.sun.deploy.uitoolkit.impl.fx.FXWindow;
import com.sun.deploy.uitoolkit.impl.fx.Utils;
import com.sun.deploy.uitoolkit.impl.fx.ui.FXDefaultPreloader;
import com.sun.javafx.applet.ExperimentalExtensions;
import com.sun.javafx.applet.FXApplet2;
import com.sun.javafx.application.ParametersImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.Callable;
import javafx.application.Application;
import javafx.application.Preloader;
import javafx.stage.Stage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FXPreloader
extends Preloader {
    private static final Object lock = new Object();
    private static FXPreloader defaultPreloader = null;
    private javafx.application.Preloader fxPreview = null;
    private FXWindow window = null;
    private boolean seenFatalError = false;

    FXPreloader() {
        DeployPerfLogger.timestamp("(start) Construct preloader [default]");
        this.fxPreview = new FXDefaultPreloader();
        DeployPerfLogger.timestamp("(done) Construct preloader [default]");
    }

    FXPreloader(Applet2Context a2c, FXWindow window) {
        DeployPerfLogger.timestamp("(start) Construct preloader [default]");
        this.window = window;
        this.fxPreview = new FXDefaultPreloader();
        String[] unnamed = Utils.getUnnamed(a2c);
        Map<String, String> named = Utils.getNamedParameters(a2c);
        ParametersImpl.registerParameters(this.fxPreview, new ParametersImpl(named, unnamed));
        DeployPerfLogger.timestamp("(done) Construct preloader [default]");
    }

    FXPreloader(Class<javafx.application.Preloader> clz, Applet2Context a2c, FXWindow window) throws InstantiationException, IllegalAccessException {
        DeployPerfLogger.timestamp("(start) Construct preloader [" + clz.getName() + "]");
        this.window = window;
        this.fxPreview = clz.newInstance();
        String[] unnamed = Utils.getUnnamed(a2c);
        Map<String, String> named = Utils.getNamedParameters(a2c);
        ParametersImpl.registerParameters(this.fxPreview, new ParametersImpl(named, unnamed));
        DeployPerfLogger.timestamp("(done) Construct preloader [" + clz.getName() + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FXPreloader getDefaultPreloader() {
        Object object = lock;
        synchronized (object) {
            if (defaultPreloader != null) {
                defaultPreloader = new FXPreloader();
            }
        }
        return defaultPreloader;
    }

    public static void notifyCurrentPreloaderOnError(ErrorEvent pe) {
        Notifier.send((PreloaderEvent)pe);
    }

    public static void notifyCurrentPreloader(Preloader.PreloaderNotification pe) {
        Notifier.send(new UserEvent(pe));
    }

    public Object getOwner() {
        return null;
    }

    public boolean handleEvent(PreloaderEvent pe) throws CancelException {
        Boolean ret = false;
        if (pe instanceof ErrorEvent) {
            FXApplet2Adapter adapter = (FXApplet2Adapter)FXApplet2Adapter.get();
            adapter.abortApplet();
        }
        FXDispatcher fxDispatcher = new FXDispatcher(pe);
        try {
            ret = FXPluginToolkit.callAndWait(fxDispatcher);
        }
        catch (CancelException ce) {
            throw ce;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    void start() throws Exception {
        DeployPerfLogger.timestamp("(start) Preloader.init()");
        this.fxPreview.init();
        DeployPerfLogger.timestamp("(done) Preloader.init()");
        FXPluginToolkit.callAndWait(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Stage previewStage;
                DeployPerfLogger.timestamp("(start) Preloader create stage");
                if (FXPreloader.this.window == null) {
                    previewStage = new Stage();
                    previewStage.impl_setPrimary(true);
                } else {
                    previewStage = FXPreloader.this.window.getPreloaderStage();
                }
                DeployPerfLogger.timestamp("(start) Preloader.start()");
                FXPreloader.this.fxPreview.start(previewStage);
                DeployPerfLogger.timestamp("(done) Preloader.start()");
                if (!(FXPreloader.this.fxPreview instanceof FXDefaultPreloader)) {
                    FXPreloader.hideSplash();
                }
                return null;
            }
        });
    }

    public static void hideSplash() {
        ExperimentalExtensions ext = ExperimentalExtensions.get();
        if (ext != null) {
            ext.getSplash().hide();
        }
    }

    void stop() throws Exception {
        if (this.fxPreview != null) {
            this.fxPreview.stop();
        }
    }

    static {
        Class<Notifier> junk = Notifier.class;
        Class<UserEvent> clazz = UserEvent.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FXDispatcher
    implements Callable<Boolean> {
        PreloaderEvent pe;

        FXDispatcher(PreloaderEvent pe) {
            this.pe = pe;
        }

        private void gotFatalError() {
            FXPreloader.this.seenFatalError = true;
            FXApplet2Adapter adapter = (FXApplet2Adapter)FXApplet2Adapter.get();
            adapter.setExitOnIdle(true);
        }

        @Override
        public Boolean call() throws Exception {
            if (FXPreloader.this.seenFatalError) {
                throw new CancelException("Cancel launch after fatal error");
            }
            switch (this.pe.getType()) {
                case 5: {
                    AppletInitEvent aie = (AppletInitEvent)this.pe;
                    Application app = null;
                    Applet2 applet2 = aie.getApplet();
                    if (applet2 != null && applet2 instanceof FXApplet2) {
                        app = ((FXApplet2)applet2).getApplication();
                    }
                    switch (aie.getSubtype()) {
                        case 2: {
                            DeployPerfLogger.timestamp("(start) Preloader.onAppLoad()");
                            FXPreloader.this.fxPreview.handleStateChangeNotification(new Preloader.StateChangeNotification(Preloader.StateChangeNotification.Type.BEFORE_LOAD));
                            DeployPerfLogger.timestamp("(done) Preloader.onAppLoad()");
                            break;
                        }
                        case 3: {
                            DeployPerfLogger.timestamp("(start) Preloader.onAppInit()");
                            FXPreloader.this.fxPreview.handleStateChangeNotification(new Preloader.StateChangeNotification(Preloader.StateChangeNotification.Type.BEFORE_INIT, app));
                            DeployPerfLogger.timestamp("(done) Preloader.onAppInit()");
                            break;
                        }
                        case 4: {
                            DeployPerfLogger.timestamp("(start) Preloader.onAppStart()");
                            FXPreloader.this.fxPreview.handleStateChangeNotification(new Preloader.StateChangeNotification(Preloader.StateChangeNotification.Type.BEFORE_START, app));
                            DeployPerfLogger.timestamp("(done) Preloader.onAppStart()");
                            break;
                        }
                    }
                    return true;
                }
                case 1: {
                    return true;
                }
                case 1000: {
                    Preloader.PreloaderNotification pev = ((UserEvent)this.pe).get();
                    FXPreloader.this.fxPreview.handleApplicationNotification(pev);
                    return true;
                }
                case 3: {
                    DownloadEvent de = (DownloadEvent)this.pe;
                    double progress = (double)de.getOverallPercentage() / 100.0;
                    FXPreloader.this.fxPreview.handleProgressNotification(new Preloader.ProgressNotification(progress));
                    return true;
                }
                case 6: {
                    ErrorEvent ee = (ErrorEvent)this.pe;
                    String location = ee.getLocation() != null ? ee.getLocation().toString() : null;
                    Throwable t = ee.getException();
                    String details = ee.getValue();
                    if (details == null) {
                        details = t != null ? t.getMessage() : "unknown error";
                    }
                    this.gotFatalError();
                    return FXPreloader.this.fxPreview.handleErrorNotification(new Preloader.ErrorNotification(location, details, t));
                }
                case 7: {
                    UserDeclinedEvent ue = (UserDeclinedEvent)this.pe;
                    String l = null;
                    this.gotFatalError();
                    return FXPreloader.this.fxPreview.handleErrorNotification(new UserDeclinedNotification(l));
                }
            }
            return false;
        }
    }

    class UserDeclinedNotification
    extends Preloader.ErrorNotification {
        public UserDeclinedNotification(String url) {
            super(url, "User declined to grant permissions to the application.", null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Notifier
    implements PrivilegedExceptionAction<Void> {
        PreloaderEvent pe;

        Notifier(PreloaderEvent pe) {
            this.pe = pe;
        }

        static void send(PreloaderEvent pe) {
            try {
                AccessController.doPrivileged(new Notifier(pe));
            }
            catch (Exception e) {
                Trace.ignoredException((Exception)e);
            }
        }

        @Override
        public Void run() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, CancelException {
            Applet2Adapter adapter = FXApplet2Adapter.get();
            if (adapter != null) {
                Class<?> c = Class.forName("com.sun.javaws.progress.Progress");
                Method m = c.getMethod("get", Applet2Adapter.class);
                Preloader p = (Preloader)m.invoke(null, adapter);
                p.handleEvent(this.pe);
            }
            return null;
        }
    }

    static class UserEvent
    extends PreloaderEvent {
        public static final int CUSTOM_USER_EVENT = 1000;
        Preloader.PreloaderNotification pe;

        UserEvent(Preloader.PreloaderNotification pe) {
            super(1000);
            this.pe = pe;
        }

        Preloader.PreloaderNotification get() {
            return this.pe;
        }
    }
}

