/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.prism.MediaFrame;
import com.sun.prism.PixelFormat;
import com.sun.prism.Presentable;
import com.sun.prism.RTTexture;
import com.sun.prism.RenderingContext;
import com.sun.prism.Texture;
import com.sun.prism.es2.ES2Context;
import com.sun.prism.es2.ES2Pipeline;
import com.sun.prism.es2.ES2RTTexture;
import com.sun.prism.es2.ES2RenderingContext;
import com.sun.prism.es2.ES2Shader;
import com.sun.prism.es2.ES2SwapChain;
import com.sun.prism.es2.ES2Texture;
import com.sun.prism.es2.gl.GLFactory;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.ps.BaseShaderFactory;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderFactory;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ES2ResourceFactory
extends BaseShaderFactory {
    private ES2Context context;
    private final int maxTextureSize;

    ES2ResourceFactory(Screen screen) {
        this.context = new ES2Context(screen, this);
        this.maxTextureSize = this.computeMaxTextureSize();
    }

    @Override
    public Presentable createPresentable(View view) {
        return new ES2SwapChain(this.context, view);
    }

    @Override
    public Texture createTexture(PixelFormat pixelFormat, Texture.Usage usage, int n, int n2, boolean bl) {
        return ES2Texture.create(this.context, pixelFormat, n, n2, bl);
    }

    @Override
    public Texture createTexture(MediaFrame mediaFrame) {
        return ES2Texture.create(this.context, mediaFrame);
    }

    @Override
    public RTTexture createRTTexture(int n, int n2) {
        return ES2RTTexture.create(this.context, n, n2);
    }

    @Override
    public boolean isFormatSupported(PixelFormat pixelFormat) {
        GLFactory gLFactory = ES2Pipeline.glFactory;
        switch (pixelFormat) {
            case BYTE_RGB: 
            case BYTE_GRAY: 
            case BYTE_ALPHA: 
            case MULTI_YCbCr_420: {
                return true;
            }
            case BYTE_BGRA_PRE: 
            case INT_ARGB_PRE: {
                return gLFactory.isGL2();
            }
            case FLOAT_XYZW: {
                return gLFactory.isGL2() || gLFactory.isGLExtensionSupported("GL_OES_texture_float");
            }
            case BYTE_APPLE_422: {
                return gLFactory.isGLExtensionSupported("GL_APPLE_ycbcr_422");
            }
        }
        return false;
    }

    private int computeMaxTextureSize() {
        int n = this.context.getGLContext().getMaxTextureSize();
        if (PrismSettings.verbose) {
            System.err.println("Maximum supported texture size: " + n);
        }
        if (n > PrismSettings.maxTextureSize) {
            n = PrismSettings.maxTextureSize;
            if (PrismSettings.verbose) {
                System.err.println("Maximum texture size clamped to " + n);
            }
        }
        return n;
    }

    @Override
    public int getMaximumTextureSize() {
        return this.maxTextureSize;
    }

    @Override
    public Shader createShader(InputStream inputStream, Map<String, Integer> map, Map<String, Integer> map2, int n, boolean bl, boolean bl2) {
        Map<String, Integer> map3 = this.getVertexAttributes(bl2, n);
        String string = ES2ResourceFactory.createVertexShaderCode(bl2, n);
        ES2Shader eS2Shader = ES2Shader.createFromSource(this.context, string, inputStream, map, map3, n, bl);
        return eS2Shader;
    }

    private static String createVertexShaderCode(boolean bl, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        stringBuilder3.append("void main() {\n");
        boolean bl2 = true;
        if (bl2) {
            stringBuilder.append("attribute vec2 positionAttr;\n");
            stringBuilder3.append("    vec4 tmp = vec4(positionAttr, 0, 1);\n");
            stringBuilder3.append("    gl_Position = mvpMatrix * tmp;\n");
        }
        if (bl) {
            stringBuilder.append("attribute vec4 colorAttr;\n");
            stringBuilder2.append("varying LOWP vec4 perVertexColor;\n");
            stringBuilder3.append("    perVertexColor = colorAttr;\n");
        }
        if (n >= 0) {
            stringBuilder.append("attribute vec2 texCoord0Attr;\n");
            stringBuilder2.append("varying vec2 texCoord0;\n");
            stringBuilder3.append("    texCoord0 = texCoord0Attr;\n");
        }
        if (n >= 1) {
            stringBuilder.append("attribute vec2 texCoord1Attr;\n");
            stringBuilder2.append("varying vec2 texCoord1;\n");
            stringBuilder3.append("    texCoord1 = texCoord1Attr;\n");
        }
        stringBuilder3.append("}\n");
        StringBuilder stringBuilder4 = new StringBuilder();
        stringBuilder4.append("#ifdef GL_ES\n");
        stringBuilder4.append("#define LOWP lowp\n");
        stringBuilder4.append("#else\n");
        stringBuilder4.append("#define LOWP\n");
        stringBuilder4.append("#endif\n");
        stringBuilder4.append("uniform mat4 mvpMatrix;\n");
        stringBuilder4.append((CharSequence)stringBuilder);
        stringBuilder4.append((CharSequence)stringBuilder2);
        stringBuilder4.append((CharSequence)stringBuilder3);
        return stringBuilder4.toString();
    }

    private Map<String, Integer> getVertexAttributes(boolean bl, int n) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        boolean bl2 = true;
        if (bl2) {
            hashMap.put("positionAttr", 0);
        }
        if (bl) {
            hashMap.put("colorAttr", 1);
        }
        if (n >= 0) {
            hashMap.put("texCoord0Attr", 2);
        }
        if (n >= 1) {
            hashMap.put("texCoord1Attr", 3);
        }
        return hashMap;
    }

    @Override
    public Shader createStockShader(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Shader name must be non-null");
        }
        try {
            InputStream inputStream = ES2ResourceFactory.class.getResourceAsStream("glsl/" + string + ".frag");
            Class<?> clazz = Class.forName("com.sun.prism.shader." + string + "_Loader");
            Method method = clazz.getMethod("loadShader", ShaderFactory.class, InputStream.class);
            return (Shader)method.invoke(null, this, inputStream);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new InternalError("Error loading stock shader " + string);
        }
    }

    @Override
    public VertexBuffer createVertexBuffer(int n) {
        return new VertexBuffer(n);
    }

    @Override
    public RenderingContext createRenderingContext(View view) {
        return new ES2RenderingContext(this.context, view);
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

