/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.math.ecgroup;

import iaik.asn1.ASN1Object;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.security.ecc.math.ecgroup.AffineCoordinate;
import iaik.security.ecc.math.ecgroup.Coordinate;
import iaik.security.ecc.math.ecgroup.ECPoint;
import iaik.security.ecc.math.ecgroup.EllipticCurve;
import iaik.security.ecc.math.ecgroup.ProjectiveCoordinate;
import iaik.security.ecc.math.field.Field;
import iaik.security.ecc.math.field.FieldElement;
import java.math.BigInteger;

abstract class EllipticCurveImpl
implements EllipticCurve {
    protected BigInteger order_;
    protected Field field_;
    protected FieldElement b_;
    protected FieldElement a_;

    protected void setB(FieldElement fieldElement) {
        this.b_ = fieldElement;
    }

    protected void setA(FieldElement fieldElement) {
        this.a_ = fieldElement;
    }

    public abstract boolean useAffine();

    public String toString() {
        return "Elliptic curve:\na: " + this.a_.toString() + "\nb: " + this.b_.toString();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.a_.toByteArray()));
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.b_.toByteArray()));
        return sEQUENCE;
    }

    public ECPoint newPoint(Coordinate coordinate) {
        if (coordinate instanceof AffineCoordinate) {
            if (this.useAffine()) {
                return new ECPoint(coordinate, (EllipticCurve)this);
            }
            AffineCoordinate affineCoordinate = (AffineCoordinate)coordinate;
            return new ECPoint(affineCoordinate.toProjective(), (EllipticCurve)this);
        }
        if (this.useAffine()) {
            ProjectiveCoordinate projectiveCoordinate = (ProjectiveCoordinate)coordinate;
            return new ECPoint(projectiveCoordinate.toAffine(), (EllipticCurve)this);
        }
        return new ECPoint(coordinate, (EllipticCurve)this);
    }

    public ECPoint newInfinityPoint() {
        return new ECPoint(this);
    }

    public void multiply2(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        eCPoint.multiply(bigInteger);
        eCPoint2.multiply(bigInteger2);
        eCPoint.addPoint(eCPoint2);
    }

    public abstract void multiply(ECPoint var1, BigInteger var2);

    public boolean isPrecomputationEnabled() {
        return false;
    }

    public abstract void invert(ECPoint var1);

    public int hashCode() {
        return this.a_.hashCode() + this.b_.hashCode();
    }

    public BigInteger getOrder() {
        return this.order_;
    }

    public abstract Field getField();

    public FieldElement getB() {
        return this.b_;
    }

    public FieldElement getA() {
        return this.a_;
    }

    public boolean equals(Object object) {
        if (object instanceof EllipticCurve) {
            EllipticCurve ellipticCurve = (EllipticCurve)object;
            return this.a_.equals(ellipticCurve.getA()) && this.b_.equals(ellipticCurve.getB());
        }
        return false;
    }

    public abstract void doublePoint(ECPoint var1);

    public abstract void addPoint(ECPoint var1, ECPoint var2);

    EllipticCurveImpl() {
    }
}

