/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.math.field;

import iaik.asn1.ASN1Object;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.security.ecc.math.field.Constants;
import iaik.security.ecc.math.field.FieldElement;
import iaik.security.ecc.math.field.FieldFactory;
import iaik.security.ecc.math.field.FieldImpl;
import iaik.security.ecc.math.field.PrimeField;
import iaik.security.ecc.math.field.PrimeFieldValueImpl;
import java.math.BigInteger;

class PrimeFieldImpl
extends FieldImpl
implements PrimeField {
    protected BigInteger modulus_ = null;

    public String toString() {
        return this.modulus_.toString();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new ObjectID("1.2.840.10045.1.1"));
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.modulus_));
        return sEQUENCE;
    }

    public void square(FieldElement fieldElement) {
        this.multiply(fieldElement, fieldElement);
    }

    public FieldElement newElement(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = 0;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        PrimeFieldValueImpl primeFieldValueImpl = new PrimeFieldValueImpl(new BigInteger(byArray2));
        return new FieldElement(primeFieldValueImpl, this);
    }

    public FieldElement newElement(BigInteger bigInteger) {
        return new FieldElement(new PrimeFieldValueImpl(bigInteger.mod(this.modulus_)), this);
    }

    public void negate(FieldElement fieldElement) {
        PrimeFieldValueImpl primeFieldValueImpl = (PrimeFieldValueImpl)fieldElement.getValue();
        BigInteger bigInteger = primeFieldValueImpl.getBigInt().negate().mod(this.modulus_);
        primeFieldValueImpl.setBigInt(bigInteger);
    }

    public void multiply(FieldElement fieldElement, FieldElement fieldElement2) {
        PrimeFieldValueImpl primeFieldValueImpl = (PrimeFieldValueImpl)fieldElement.getValue();
        BigInteger bigInteger = ((PrimeFieldValueImpl)fieldElement2.getValue()).getBigInt();
        BigInteger bigInteger2 = primeFieldValueImpl.getBigInt().multiply(bigInteger);
        primeFieldValueImpl.setBigInt(bigInteger2.mod(this.modulus_));
    }

    public void invert(FieldElement fieldElement) {
        PrimeFieldValueImpl primeFieldValueImpl = (PrimeFieldValueImpl)fieldElement.getValue();
        BigInteger bigInteger = primeFieldValueImpl.getBigInt().modInverse(this.modulus_);
        primeFieldValueImpl.setBigInt(bigInteger);
    }

    public void half(FieldElement fieldElement) {
        PrimeFieldValueImpl primeFieldValueImpl = (PrimeFieldValueImpl)fieldElement.getValue();
        BigInteger bigInteger = primeFieldValueImpl.getBigInt().multiply(Constants.BIG_TWO.modInverse(this.modulus_)).mod(this.modulus_);
        primeFieldValueImpl.setBigInt(bigInteger);
    }

    public FieldElement getZEROelement() {
        return this.newElement(Constants.BIG_ZERO);
    }

    public BigInteger getSize() {
        return this.modulus_;
    }

    public FieldElement getONEelement() {
        return this.newElement(Constants.BIG_ONE);
    }

    public BigInteger getModulus() {
        return this.modulus_;
    }

    public int getFieldId() {
        return 1;
    }

    public void add(FieldElement fieldElement, FieldElement fieldElement2) {
        PrimeFieldValueImpl primeFieldValueImpl = (PrimeFieldValueImpl)fieldElement.getValue();
        BigInteger bigInteger = ((PrimeFieldValueImpl)fieldElement2.getValue()).getBigInt();
        BigInteger bigInteger2 = primeFieldValueImpl.getBigInt().add(bigInteger);
        primeFieldValueImpl.setBigInt(bigInteger2.mod(this.modulus_));
    }

    protected PrimeFieldImpl(BigInteger bigInteger, FieldFactory fieldFactory) {
        this.modulus_ = bigInteger;
        this.fieldFactory_ = fieldFactory;
    }
}

