/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.IA5String;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.VisibleString;
import iaik.utils.InternalErrorException;
import java.math.BigInteger;

public class PolicyQualifierInfo {
    private ASN1Object a;
    ASN1Object e;
    int[] d;
    ASN1Object c;
    String f;
    ObjectID b;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("policyQualifierId: " + this.b.getName() + "\n");
        if (this.b.equals(ObjectID.id_pkix_cps)) {
            stringBuffer.append("CPS URI: " + this.f + "\n");
        } else if (this.b.equals(ObjectID.id_pkix_unotice)) {
            if (this.c != null) {
                stringBuffer.append("organization: " + this.c.getValue() + "\n");
            }
            if (this.d != null) {
                int n2 = 0;
                while (n2 < this.d.length) {
                    stringBuffer.append("noticeNumber[" + n2 + "]: " + this.d[n2] + "\n");
                    ++n2;
                }
            }
            if (this.e != null) {
                stringBuffer.append("displayText: " + this.e.getValue() + "\n");
            }
        } else {
            stringBuffer.append("Unknown qualifier " + this.b + "\n");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        return this.a;
    }

    public ASN1Object getQualifierValue() {
        try {
            return this.a.getComponentAt(1);
        }
        catch (CodingException codingException) {
            return null;
        }
    }

    public ObjectID getPolicyQualifier() {
        return this.b;
    }

    public ASN1Object getOrganization() {
        return this.c;
    }

    public int[] getNoticeNumbers() {
        return this.d;
    }

    public ASN1Object getExplicitText() {
        return this.e;
    }

    public ASN1Object getExplicitTest() {
        return this.e;
    }

    public String getCPSuri() {
        return this.f;
    }

    private void a() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.b);
        if (this.b.equals(ObjectID.id_pkix_cps)) {
            sEQUENCE.addComponent(new IA5String(this.f));
        } else if (this.b.equals(ObjectID.id_pkix_unotice)) {
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            if (this.c != null) {
                SEQUENCE sEQUENCE3 = new SEQUENCE();
                sEQUENCE3.addComponent(this.c);
                SEQUENCE sEQUENCE4 = new SEQUENCE();
                int n2 = 0;
                while (n2 < this.d.length) {
                    sEQUENCE4.addComponent(new INTEGER(this.d[n2]));
                    ++n2;
                }
                sEQUENCE3.addComponent(sEQUENCE4);
                sEQUENCE2.addComponent(sEQUENCE3);
            }
            if (this.e != null) {
                sEQUENCE2.addComponent(this.e);
            }
            sEQUENCE.addComponent(sEQUENCE2);
        } else {
            throw new InternalErrorException("Unknown policyQualifierId");
        }
        this.a = sEQUENCE;
    }

    public PolicyQualifierInfo(String string, int[] nArray, String string2) {
        this.b = ObjectID.id_pkix_unotice;
        if (string == null || nArray == null) {
            this.c = null;
            this.d = null;
        } else {
            this.c = new IA5String(string);
            this.d = nArray;
        }
        if (string2 != null) {
            this.e = new VisibleString(string2);
        }
        this.a();
    }

    public PolicyQualifierInfo(String string) {
        this.b = ObjectID.id_pkix_cps;
        this.f = string;
        this.a();
    }

    public PolicyQualifierInfo(ASN1Object aSN1Object, int[] nArray, ASN1Object aSN1Object2) {
        this.b = ObjectID.id_pkix_unotice;
        if (aSN1Object == null || nArray == null) {
            this.c = null;
            this.d = null;
        } else {
            if (!aSN1Object.isStringType()) {
                throw new IllegalArgumentException("Invalid ASN.1 type for organization (only string types allowed): " + aSN1Object.getAsnType());
            }
            this.c = aSN1Object;
            this.d = nArray;
        }
        if (aSN1Object2 != null && !aSN1Object2.isStringType()) {
            throw new IllegalArgumentException("Invalid ASN.1 type for explicitText (only string types allowed): " + aSN1Object2.getAsnType());
        }
        this.e = aSN1Object2;
        this.a();
    }

    public PolicyQualifierInfo(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("No PolicyQualifierInfo!");
        }
        this.b = (ObjectID)aSN1Object.getComponentAt(0);
        this.a = aSN1Object;
        int n2 = aSN1Object.countComponents();
        if (n2 != 2) {
            throw new CodingException("Invalid number (" + n2 + ") of policyQualifierInfo components!");
        }
        if (this.b.equals(ObjectID.id_pkix_cps)) {
            this.f = (String)aSN1Object.getComponentAt(1).getValue();
            return;
        }
        if (this.b.equals(ObjectID.id_pkix_unotice)) {
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(1);
            int n3 = 0;
            while (n3 < aSN1Object2.countComponents()) {
                ASN1Object aSN1Object3 = aSN1Object2.getComponentAt(n3);
                if (aSN1Object3.isA(ASN.SEQUENCE)) {
                    this.c = aSN1Object3.getComponentAt(0);
                    ASN1Object aSN1Object4 = aSN1Object3.getComponentAt(1);
                    this.d = new int[aSN1Object4.countComponents()];
                    int n4 = 0;
                    while (n4 < aSN1Object4.countComponents()) {
                        this.d[n4] = ((BigInteger)aSN1Object4.getComponentAt(n4).getValue()).intValue();
                        ++n4;
                    }
                } else {
                    this.e = aSN1Object3;
                }
                ++n3;
            }
        }
    }
}

