/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.DebugCMS;
import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.UnknownAttributeValue;
import iaik.cms.CMSException;
import iaik.cms.CMSSignatureException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.InvalidContentHashException;
import iaik.cms.InvalidContentTypeException;
import iaik.cms.SecurityProvider;
import iaik.cms.SignedDataStream;
import iaik.cms.Utils;
import iaik.cms.a;
import iaik.cms.attributes.CMSContentType;
import iaik.cms.g;
import iaik.cms.p;
import iaik.smime.ess.SigningCertificate;
import iaik.smime.ess.SigningCertificateV2;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Locale;
import java.util.Vector;

public class SignerInfo
implements ASN1Type {
    private boolean n;
    private boolean m;
    private SecurityProvider g;
    private PrivateKey h;
    private Attribute[] b;
    private byte[] e;
    private AlgorithmID f;
    private Attribute[] d;
    private AlgorithmID j;
    private CertificateIdentifier c;
    private int a;
    private g i;
    private static boolean l = DebugCMS.getDebugMode() && l;

    public boolean verifySignature(byte[] byArray, PublicKey publicKey) throws CMSSignatureException {
        SecurityProvider securityProvider = this.g;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        try {
            if (this.d != null && this.d.length > 0) {
                CMSContentType cMSContentType = null;
                int n2 = 0;
                while (n2 < this.d.length) {
                    AttributeValue attributeValue;
                    if (this.d[n2].getType().equals((Object)CMSContentType.oid) && (attributeValue = this.d[n2].getAttributeValue()) != null) {
                        cMSContentType = attributeValue instanceof CMSContentType ? (CMSContentType)attributeValue : new CMSContentType(attributeValue.toASN1Object());
                        break;
                    }
                    ++n2;
                }
                if (cMSContentType != null && !cMSContentType.get().equals((Object)((SignedDataStream)this.i).getEncapsulatedContentType())) {
                    throw new InvalidContentTypeException();
                }
                byte[] byArray2 = this.getSignedDigest();
                if (!CryptoUtils.equalsBlock((byte[])byArray, (byte[])byArray2)) {
                    throw new InvalidContentHashException();
                }
                return securityProvider.verifySignatureFromSignedAttributes(this.f, this.j, publicKey, DerCoder.encode((ASN1Object)ASN.createSetOf((ASN1Type[])this.d, (boolean)this.m)), this.e);
            }
            return securityProvider.verifySignatureFromHash(this.f, this.j, publicKey, byArray, this.e);
        }
        catch (CodingException codingException) {
            throw new CMSSignatureException("Error encoding signed attributes: " + codingException.toString(), (Exception)((Object)codingException), this.c);
        }
        catch (CMSSignatureException cMSSignatureException) {
            throw cMSSignatureException;
        }
        catch (Exception exception) {
            throw new CMSSignatureException(exception, this.c);
        }
    }

    public boolean verifySignature(PublicKey publicKey) throws CMSSignatureException {
        try {
            return this.verifySignature(this.i.getMessageDigest(this.j), publicKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSSignatureException("Digest algorithm not available: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException, this.c);
        }
    }

    public String toString(boolean bl) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.a + "\n");
        stringBuffer.append("SignerID: {\n");
        Utils.printIndented(this.c.toString(), true, stringBuffer);
        stringBuffer.append("\n}\n");
        stringBuffer.append("DigestAlgorithm: " + this.j + "\n");
        stringBuffer.append("SignatureAlgorithm: " + this.f + "\n");
        stringBuffer.append("SignatureValue: ");
        if (this.e != null) {
            stringBuffer.append(String.valueOf(this.e.length) + " Bytes [" + Util.toString((byte[])this.e, (int)0, (int)5) + "...]");
        }
        stringBuffer.append("\n");
        if (this.d != null) {
            stringBuffer.append("Signed Attributes: {\n");
            n2 = 0;
            while (n2 < this.d.length) {
                Utils.printIndented(this.d[n2].toString(), false, stringBuffer);
                stringBuffer.append("\n");
                ++n2;
            }
            stringBuffer.append("\n}");
        }
        if (this.b != null) {
            stringBuffer.append("Unsigned Attributes: {\n");
            n2 = 0;
            while (n2 < this.b.length) {
                Utils.printIndented(this.b[n2].toString(), false, stringBuffer);
                stringBuffer.append("\n");
                ++n2;
            }
            stringBuffer.append("\n}");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        try {
            String string;
            String string2;
            sEQUENCE.addComponent((ASN1Object)new INTEGER(this.a));
            sEQUENCE.addComponent(new a(this.c).toASN1Object());
            sEQUENCE.addComponent(this.j.toASN1Object());
            this.a();
            if (this.d != null && this.d.length > 0) {
                string2 = ASN.createSetOf((ASN1Type[])this.d, (boolean)true);
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)string2, true));
            }
            string2 = this.f.getImplementationName();
            boolean bl = true;
            if (string2 != null && (string = string2.toUpperCase(Locale.US)).indexOf("DSA") != -1 && string.indexOf("ECDSA") == -1) {
                bl = false;
            }
            bl = false;
            if (false) {
                this.f.setParameter(null);
                sEQUENCE.addComponent(this.f.toASN1Object(false));
            } else {
                sEQUENCE.addComponent(this.f.toASN1Object());
            }
            sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.e));
            if (this.b != null) {
                string = ASN.createSetOf((ASN1Type[])this.b);
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(1, (ASN1Object)string, true));
            }
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
        return sEQUENCE;
    }

    public void setUnsignedAttributes(Attribute[] attributeArray) {
        this.b = attributeArray;
    }

    public void setSignedAttributes(Attribute[] attributeArray) {
        this.d = attributeArray;
        if (!this.n) {
            this.e = null;
        }
    }

    public void setSignatureValue(byte[] byArray) {
        this.e = byArray;
        this.n = true;
        this.m = true;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.g = securityProvider;
    }

    public void setEncryptedDigest(byte[] byArray) {
        this.setSignatureValue(byArray);
    }

    void a(g g2) {
        this.i = g2;
    }

    public void removeUnSignedAttribute(ObjectID objectID) {
        int n2 = 0;
        if (this.b != null) {
            int n3 = 0;
            while (n3 < this.b.length) {
                if (this.b[n3].getType().equals((Object)objectID)) {
                    this.b[n3] = null;
                    ++n2;
                }
                ++n3;
            }
            if (n2 > 0) {
                Attribute[] attributeArray = new Attribute[this.b.length - n2];
                int n4 = 0;
                int n5 = 0;
                while (n5 < this.b.length) {
                    if (this.b[n5] != null) {
                        attributeArray[n4++] = this.b[n5];
                    }
                    ++n5;
                }
                this.b = attributeArray;
            }
        }
    }

    public void removeSignedAttribute(ObjectID objectID) {
        int n2 = 0;
        if (this.d != null) {
            int n3 = 0;
            while (n3 < this.d.length) {
                if (this.d[n3].getType().equals((Object)objectID)) {
                    this.d[n3] = null;
                    ++n2;
                }
                ++n3;
            }
            if (n2 > 0) {
                Attribute[] attributeArray = new Attribute[this.d.length - n2];
                int n4 = 0;
                int n5 = 0;
                while (n5 < this.d.length) {
                    if (this.d[n5] != null) {
                        attributeArray[n4++] = this.d[n5];
                    }
                    ++n5;
                }
                this.d = attributeArray;
            }
            if (!this.n) {
                this.e = null;
            }
        }
    }

    public boolean isSignerCertificate(X509Certificate x509Certificate) throws CMSException {
        boolean bl = false;
        if (this.c.identifiesCert(x509Certificate)) {
            if (this.d == null) {
                bl = true;
            } else {
                SigningCertificate signingCertificate = this.getSigningCertificateAttribute();
                SigningCertificateV2 signingCertificateV2 = this.getSigningCertificateV2Attribute();
                if (signingCertificate == null && signingCertificateV2 == null) {
                    bl = true;
                } else {
                    try {
                        boolean bl2 = true;
                        if (signingCertificate != null) {
                            bl2 = signingCertificate.isSignerCertificate(x509Certificate);
                        }
                        if (bl2) {
                            boolean bl3 = true;
                            if (signingCertificateV2 != null) {
                                bl3 = signingCertificateV2.isSignerCertificate(x509Certificate);
                            }
                            bl = bl2 && bl3;
                        }
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new CMSException("Cannot check included SigningCertificate attribute: Algorithm not supported: " + noSuchAlgorithmException.toString());
                    }
                }
            }
        }
        return bl;
    }

    private void c() {
        this.a = 1;
        this.d = null;
        this.b = null;
        this.m = false;
    }

    public int getVersion() {
        return this.a;
    }

    public Attribute[] getUnsignedAttributes(ObjectID objectID) {
        if (this.b == null) {
            return null;
        }
        Vector<Attribute> vector = new Vector<Attribute>();
        int n2 = 0;
        while (n2 < this.b.length) {
            if (this.b[n2].getType().equals((Object)objectID)) {
                vector.addElement(this.b[n2]);
            }
            ++n2;
        }
        if (vector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Attribute[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Attribute[] getUnsignedAttributes() {
        if (this.b == null) {
            return new Attribute[0];
        }
        return this.b;
    }

    public AttributeValue getUnsignedAttributeValue(ObjectID objectID) throws CMSException {
        AttributeValue attributeValue = null;
        Attribute attribute = this.getUnsignedAttribute(objectID);
        if (attribute != null) {
            try {
                attributeValue = attribute.getAttributeValue();
                if (attributeValue instanceof UnknownAttributeValue) {
                    attributeValue = p.a((UnknownAttributeValue)attributeValue);
                }
            }
            catch (CodingException codingException) {
                throw new CMSException("Cannot decode attribute " + objectID.getName() + ": " + codingException.getMessage());
            }
        }
        return attributeValue;
    }

    public Attribute getUnsignedAttribute(ObjectID objectID) {
        if (this.b == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.b.length) {
            if (this.b[n2].getType().equals((Object)objectID)) {
                return this.b[n2];
            }
            ++n2;
        }
        return null;
    }

    public SigningCertificateV2 getSigningCertificateV2Attribute() throws CMSException {
        SigningCertificateV2 signingCertificateV2 = null;
        Attribute attribute = this.getSignedAttribute(SigningCertificateV2.oid);
        if (attribute != null) {
            try {
                AttributeValue attributeValue = attribute.getAttributeValue();
                if (attributeValue != null) {
                    signingCertificateV2 = attributeValue instanceof SigningCertificateV2 ? (SigningCertificateV2)attributeValue : new SigningCertificateV2(attributeValue.toASN1Object());
                    signingCertificateV2.setSecurityProvider(this.g);
                }
            }
            catch (CodingException codingException) {
                throw new CMSException("Error when parsing SigningCertificateV2 attribute: " + codingException.getMessage());
            }
        }
        return signingCertificateV2;
    }

    public SigningCertificate getSigningCertificateAttribute() throws CMSException {
        SigningCertificate signingCertificate = null;
        Attribute attribute = this.getSignedAttribute(ObjectID.signingCertificate);
        if (attribute != null) {
            try {
                AttributeValue attributeValue = attribute.getAttributeValue();
                if (attributeValue != null) {
                    signingCertificate = attributeValue instanceof SigningCertificate ? (SigningCertificate)attributeValue : new SigningCertificate(attributeValue.toASN1Object());
                    signingCertificate.setSecurityProvider(this.g);
                }
            }
            catch (CodingException codingException) {
                throw new CMSException("Error when parsing SigningCertificate attribute: " + codingException.getMessage());
            }
        }
        return signingCertificate;
    }

    public CertificateIdentifier getSignerIdentifier() {
        return this.c;
    }

    public byte[] getSignedDigest() throws CMSException {
        if (this.d == null) {
            throw new CMSException("No signed attributes included!");
        }
        int n2 = 0;
        while (n2 < this.d.length) {
            if (this.d[n2].getType().equals((Object)ObjectID.messageDigest)) {
                return (byte[])this.d[n2].getValue()[0].getValue();
            }
            ++n2;
        }
        throw new CMSException("Message digest not included in signed attributes!");
    }

    public Attribute[] getSignedAttributes(ObjectID objectID) {
        if (this.d == null) {
            return null;
        }
        Vector<Attribute> vector = new Vector<Attribute>();
        int n2 = 0;
        while (n2 < this.d.length) {
            if (this.d[n2].getType().equals((Object)objectID)) {
                vector.addElement(this.d[n2]);
            }
            ++n2;
        }
        if (vector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Attribute[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Attribute[] getSignedAttributes() {
        if (this.d == null) {
            return new Attribute[0];
        }
        return this.d;
    }

    public AttributeValue getSignedAttributeValue(ObjectID objectID) throws CMSException {
        AttributeValue attributeValue = null;
        Attribute attribute = this.getSignedAttribute(objectID);
        if (attribute != null) {
            try {
                attributeValue = attribute.getAttributeValue();
                if (attributeValue instanceof UnknownAttributeValue) {
                    attributeValue = p.a((UnknownAttributeValue)attributeValue);
                }
            }
            catch (CodingException codingException) {
                throw new CMSException("Cannot decode attribute " + objectID.getName() + ": " + codingException.getMessage());
            }
        }
        return attributeValue;
    }

    public Attribute getSignedAttribute(ObjectID objectID) {
        if (this.d == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.d.length) {
            if (this.d[n2].getType().equals((Object)objectID)) {
                return this.d[n2];
            }
            ++n2;
        }
        return null;
    }

    boolean b() {
        return this.n;
    }

    public byte[] getSignatureValue() {
        return this.e;
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.f;
    }

    public SecurityProvider getSecurityProvider() {
        return this.g;
    }

    public AlgorithmID getDigestAlgorithm() {
        return this.j;
    }

    public byte[] getDigest() throws CMSException {
        try {
            return this.i.getMessageDigest(this.j);
        }
        catch (Exception exception) {
            throw new CMSException("Cannot calculate the digest on the content: " + exception.getMessage());
        }
    }

    private static final AlgorithmID a(PrivateKey privateKey) {
        String string;
        AlgorithmID algorithmID = privateKey == null ? (AlgorithmID)AlgorithmID.rsaEncryption.clone() : ((string = privateKey.getAlgorithm()).equalsIgnoreCase("RSA") ? (AlgorithmID)AlgorithmID.rsaEncryption.clone() : (string.equalsIgnoreCase("DSA") ? (AlgorithmID)AlgorithmID.dsaWithSHA.clone() : (string.equalsIgnoreCase("ECDSA") ? (AlgorithmID)AlgorithmID.ecdsa_With_SHA1.clone() : (AlgorithmID)AlgorithmID.rsaEncryption.clone())));
        return algorithmID;
    }

    private static final AlgorithmID b(PrivateKey privateKey) {
        int n2;
        String string;
        AlgorithmID algorithmID = privateKey == null ? (AlgorithmID)AlgorithmID.sha1.clone() : ((string = privateKey.getAlgorithm()).equalsIgnoreCase("RSA") ? ((n2 = Util.getKeyLength((PrivateKey)privateKey)) <= 1248 ? (AlgorithmID)AlgorithmID.sha1.clone() : (n2 <= 3248 ? (AlgorithmID)AlgorithmID.sha256.clone() : (AlgorithmID)AlgorithmID.sha512.clone())) : (AlgorithmID)AlgorithmID.sha1.clone());
        return algorithmID;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        try {
            ASN1Object aSN1Object2 = null;
            int n2 = 0;
            this.a = ((BigInteger)aSN1Object.getComponentAt(0).getValue()).intValue();
            this.c = new a(aSN1Object.getComponentAt(1)).getCertificateIdentifier();
            this.j = new AlgorithmID(aSN1Object.getComponentAt(2));
            aSN1Object2 = aSN1Object.getComponentAt(3);
            if (aSN1Object2.isA(ASN.CON_SPEC)) {
                ((CON_SPEC)aSN1Object2).forceImplicitlyTagged(ASN.SET);
                this.d = p.c((ASN1Object)aSN1Object2.getValue());
                ++n2;
            }
            this.f = new AlgorithmID(aSN1Object.getComponentAt(3 + n2));
            this.e = (byte[])aSN1Object.getComponentAt(4 + n2).getValue();
            if (5 + n2 < aSN1Object.countComponents()) {
                CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(5 + n2);
                cON_SPEC.forceImplicitlyTagged(ASN.SET);
                this.b = p.c((ASN1Object)cON_SPEC.getValue());
                return;
            }
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    void a() throws CMSException {
        if (this.e == null) {
            try {
                SecurityProvider securityProvider = this.g;
                if (securityProvider == null) {
                    securityProvider = SecurityProvider.getSecurityProvider();
                }
                byte[] byArray = this.i.getMessageDigest(this.j);
                this.d = Utils.a(this.d, byArray);
                if (this.d == null || this.d.length == 0) {
                    this.e = securityProvider.calculateSignatureFromHash(this.f, this.j, this.h, byArray);
                    return;
                }
                byte[] byArray2 = DerCoder.encode((ASN1Object)ASN.createSetOf((ASN1Type[])this.d, (boolean)true));
                this.setSignatureValue(securityProvider.calculateSignatureFromSignedAttributes(this.f, this.j, this.h, byArray2));
                return;
            }
            catch (Exception exception) {
                throw new CMSException("Unable to calculate signature: " + exception.toString());
            }
        }
        if (this.d != null && this.d.length > 0) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.d.length) {
                if (this.d[n2].getType().equals((Object)ObjectID.messageDigest)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                throw new CMSException("Message digest not included in signed attributes!");
            }
        }
    }

    public void addUnsignedAttributes(Attribute[] attributeArray) {
        if (attributeArray == null || attributeArray.length == 0) {
            return;
        }
        if (this.b == null || this.b.length == 0) {
            this.b = attributeArray;
            return;
        }
        Attribute[] attributeArray2 = new Attribute[this.b.length + attributeArray.length];
        System.arraycopy(this.b, 0, attributeArray2, 0, this.b.length);
        System.arraycopy(attributeArray, 0, attributeArray2, this.b.length, attributeArray.length);
        this.b = attributeArray2;
    }

    public void addUnSignedAttribute(Attribute attribute) {
        if (attribute == null) {
            return;
        }
        if (this.b == null || this.b.length == 0) {
            this.b = new Attribute[]{attribute};
            return;
        }
        Attribute[] attributeArray = new Attribute[this.b.length + 1];
        System.arraycopy(this.b, 0, attributeArray, 0, this.b.length);
        attributeArray[this.b.length] = attribute;
        this.b = attributeArray;
    }

    public void addSignedAttributes(Attribute[] attributeArray) {
        if (attributeArray == null || attributeArray.length == 0) {
            return;
        }
        if (this.d == null || this.d.length == 0) {
            this.d = attributeArray;
        } else {
            Attribute[] attributeArray2 = new Attribute[this.d.length + attributeArray.length];
            System.arraycopy(this.d, 0, attributeArray2, 0, this.d.length);
            System.arraycopy(attributeArray, 0, attributeArray2, this.d.length, attributeArray.length);
            this.d = attributeArray2;
        }
        if (!this.n) {
            this.e = null;
        }
    }

    public void addSignedAttribute(Attribute attribute) {
        if (attribute == null) {
            return;
        }
        if (this.d == null || this.d.length == 0) {
            this.d = new Attribute[]{attribute};
        } else {
            Attribute[] attributeArray = new Attribute[this.d.length + 1];
            System.arraycopy(this.d, 0, attributeArray, 0, this.d.length);
            attributeArray[this.d.length] = attribute;
            this.d = attributeArray;
        }
        if (!this.n) {
            this.e = null;
        }
    }

    public SignerInfo(CertificateIdentifier certificateIdentifier, AlgorithmID algorithmID, PrivateKey privateKey) {
        this(certificateIdentifier, algorithmID, null, privateKey);
    }

    public SignerInfo(CertificateIdentifier certificateIdentifier, AlgorithmID algorithmID, AlgorithmID algorithmID2, PrivateKey privateKey) {
        if (certificateIdentifier == null) {
            throw new IllegalArgumentException("Signer ID must not be null!");
        }
        int n2 = certificateIdentifier.getKeyIdType();
        if (n2 == 1) {
            this.a = 3;
        } else if (n2 != 0) {
            throw new IllegalArgumentException("Invalid signerIdentifier! Expected SubjectKeyIdentifier or IssuerAndSerialNumber!");
        }
        this.c = certificateIdentifier;
        this.f = algorithmID2 != null ? algorithmID2 : SignerInfo.a(privateKey);
        this.j = algorithmID != null ? algorithmID : SignerInfo.b(privateKey);
        this.h = privateKey;
        this.c();
    }

    public SignerInfo(ASN1Object aSN1Object) throws CodingException {
        this.c();
        this.decode(aSN1Object);
    }

    public SignerInfo() {
        this.c();
        this.j = (AlgorithmID)AlgorithmID.sha1.clone();
        this.f = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
    }
}

