/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import javax.transaction.xa.Xid;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetResultSetRequest;
import org.apache.derby.client.net.NetXACallInfo;

public class NetXAConnectionRequest
extends NetResultSetRequest {
    NetXAConnectionRequest(NetAgent netAgent, CcsidManager ccsidManager, int n) {
        super(netAgent, ccsidManager, n);
    }

    public void writeLocalXACommit(NetConnection netConnection) throws SqlException {
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        Xid xid = netXACallInfo.xid_;
        this.buildSYNCCTLMigrate();
        this.buildSYNCCTLCommit(0x10000000, xid);
    }

    public void writeLocalXARollback(NetConnection netConnection) throws SqlException {
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        this.buildSYNCCTLRollback(0x10000000);
    }

    public void writeXaStartUnitOfWork(NetConnection netConnection) throws SqlException {
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        Xid xid = netXACallInfo.xid_;
        int n = netXACallInfo.xaFlags_;
        long l = netXACallInfo.xaTimeoutMillis_;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 9);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, n);
        if (l >= 0L && n == 0) {
            this.writeXATimeout(6407, l);
        }
        this.updateLengthBytes();
    }

    public void writeXaEndUnitOfWork(NetConnection netConnection) throws SqlException {
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        Xid xid = netXACallInfo.xid_;
        int n = netXACallInfo.xaFlags_;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 11);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, n);
        this.updateLengthBytes();
    }

    protected void writeXaPrepare(NetConnection netConnection) throws SqlException {
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        Xid xid = netXACallInfo.xid_;
        int n = 0;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 1);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, n);
        this.updateLengthBytes();
    }

    protected void writeXaCommit(NetConnection netConnection, Xid xid) throws SqlException {
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        int n = netXACallInfo.xaFlags_;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 3);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, n);
        this.updateLengthBytes();
    }

    protected void writeXaRollback(NetConnection netConnection, Xid xid) throws SqlException {
        int n = 0;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 4);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, n);
        this.updateLengthBytes();
    }

    protected void writeXaRecover(NetConnection netConnection, int n) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 12);
        this.writeXAFlags(6403, n);
        this.updateLengthBytes();
    }

    protected void writeXaForget(NetConnection netConnection, Xid xid) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 6);
        this.writeXID(6145, xid);
        this.updateLengthBytes();
    }

    public void writeSYNCType(int n, int n2) {
        this.writeScalar1Byte(n, n2);
    }

    public void writeForget(int n, int n2) {
        this.writeScalar1Byte(n, n2);
    }

    public void writeReleaseConversation(int n, int n2) {
        this.writeScalar1Byte(n, n2);
    }

    void writeNullXID(int n) {
        int n2 = -1;
        this.writeScalar4Bytes(n, n2);
    }

    void writeXID(int n, Xid xid) throws SqlException {
        int n2 = 0;
        int n3 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        this.markLengthBytes(n);
        n2 = 4;
        n2 += byArray2.length + 4;
        n2 += byArray.length + 4;
        this.write4Bytes(n3);
        this.write4Bytes(byArray.length);
        this.write4Bytes(byArray2.length);
        this.ensureLength(this.offset_ + byArray.length);
        System.arraycopy(byArray, 0, this.bytes_, this.offset_, byArray.length);
        this.offset_ += byArray.length;
        this.ensureLength(this.offset_ + byArray2.length);
        System.arraycopy(byArray2, 0, this.bytes_, this.offset_, byArray2.length);
        this.offset_ += byArray2.length;
        this.updateLengthBytes();
    }

    void writeXAFlags(int n, int n2) {
        this.writeScalar4Bytes(n, n2);
    }

    void writeXATimeout(int n, long l) {
        this.writeScalar8Bytes(n, l);
    }

    void buildSYNCCTLMigrate() throws SqlException {
    }

    void buildSYNCCTLCommit(int n, Xid xid) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 3);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, n);
        this.updateLengthBytes();
    }

    void buildSYNCCTLRollback(int n) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 4);
        this.writeNullXID(6145);
        this.writeXAFlags(6403, n);
        this.updateLengthBytes();
    }
}

