/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class SecuritySettings {
    public static final String[] SEC_LEVEL_MANAGED_PROPERTIES = new String[]{"deployment.insecure.jres", "deployment.security.run.untrusted", "deployment.security.local.applets"};
    public static final String[][] SEC_LEVEL_MAP = new String[][]{{"ALWAYS", "PROMPT", "PROMPT_MULTI", "NEVER"}, {"ALWAYS", "ALWAYS", "PROMPT", "NEVER"}, {"ALWAYS", "PROMPT", "PROMPT", "NEVER"}};
    public static final String[] SECURITY_LEVELS = new String[]{"LOW", "MEDIUM", "HIGH", "VERY_HIGH"};

    public static void setSSVMode(String string) {
        SecuritySettings.setManagedPropertyValue("deployment.insecure.jres", string);
    }

    public static boolean isSSVModeNever() {
        return "NEVER".equals(SecuritySettings.getManagedPropertyValue("deployment.insecure.jres"));
    }

    public static boolean isSSVModeAlways() {
        return "ALWAYS".equals(SecuritySettings.getManagedPropertyValue("deployment.insecure.jres"));
    }

    public static boolean isSSVModePrompt() {
        return "PROMPT".equals(SecuritySettings.getManagedPropertyValue("deployment.insecure.jres"));
    }

    public static boolean isSSVModeMultiClick() {
        return "PROMPT_MULTI".equals(SecuritySettings.getManagedPropertyValue("deployment.insecure.jres"));
    }

    public static void setAskGrantShow(boolean bl) {
        Config.setBooleanProperty("deployment.security.askgrantdialog.show", bl);
    }

    public static boolean isAskGrantShowSet() {
        return Config.getBooleanProperty("deployment.security.askgrantdialog.show");
    }

    public static void setAskGrantSelfSigned(boolean bl) {
        Config.setBooleanProperty("deployment.security.askgrantdialog.notinca", bl);
    }

    public static boolean isAskGrantSelfSignedSet() {
        return Config.getBooleanProperty("deployment.security.askgrantdialog.notinca");
    }

    public static void setRunUntrustedMode(String string) {
        SecuritySettings.setManagedPropertyValue("deployment.security.run.untrusted", string);
    }

    public static boolean isRunUntrustedNever() {
        return "NEVER".equals(SecuritySettings.getManagedPropertyValue("deployment.security.run.untrusted"));
    }

    public static boolean isRunUntrustedAlways() {
        return "ALWAYS".equals(SecuritySettings.getManagedPropertyValue("deployment.security.run.untrusted"));
    }

    public static void setRunLocalApplets(String string) {
        SecuritySettings.setManagedPropertyValue("deployment.security.local.applets", string);
    }

    public static boolean isRunLocalAppletsNever() {
        return "NEVER".equals(SecuritySettings.getManagedPropertyValue("deployment.security.local.applets"));
    }

    public static boolean isRunLocalAppletsAlways() {
        return "ALWAYS".equals(SecuritySettings.getManagedPropertyValue("deployment.security.local.applets"));
    }

    public static String getManagedPropertyValue(String string) {
        int n = SecuritySettings.getSecurityLevelInt();
        int n2 = SecuritySettings.getPropertyIndex(string);
        if (n2 < 0) {
            Trace.println("Trying to call getManagedProperty(" + string + ");", TraceLevel.BASIC);
            return Config.getStringProperty(string);
        }
        if (n >= 0) {
            return SEC_LEVEL_MAP[n2][n];
        }
        Config.get();
        return Config.getStringProperty(string);
    }

    public static boolean getManagedBooleanValue(String string) {
        return "true".equalsIgnoreCase(SecuritySettings.getManagedPropertyValue(string));
    }

    public static void setManagedPropertyValue(String string, String string2) {
        int n = SecuritySettings.getPropertyIndex(string);
        if (n < 0) {
            Trace.println("trying to call setManagedPropertyValeu(" + string + ", " + string2 + ");", TraceLevel.BASIC);
            Config.setStringProperty(string, string2);
        } else {
            String string3 = SecuritySettings.getSecurityLevel();
            if (!"CUSTOM".equals(string3)) {
                Trace.println("trying to call setManagedPropertyValue() when security level is: " + string3, TraceLevel.BASIC);
            } else {
                Config.setStringProperty(string, string2);
            }
        }
    }

    public static void setManagedBooleanValue(String string, boolean bl) {
        SecuritySettings.setManagedPropertyValue(string, bl ? "true" : "false");
    }

    private static int getPropertyIndex(String string) {
        for (int i = 0; i < SEC_LEVEL_MANAGED_PROPERTIES.length; ++i) {
            if (!SEC_LEVEL_MANAGED_PROPERTIES[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static void setSecurityLevel(String string) {
        block3: {
            block2: {
                String string2 = SecuritySettings.getSecurityLevel();
                Config.setStringProperty("deployment.security.level", string);
                if (!"CUSTOM".equals(string)) break block2;
                int n = SecuritySettings.getLevelInt(string2);
                if (n < 0 || n >= SECURITY_LEVELS.length) break block3;
                for (int i = 0; i < SEC_LEVEL_MANAGED_PROPERTIES.length; ++i) {
                    Config.get();
                    Config.setStringProperty(SEC_LEVEL_MANAGED_PROPERTIES[i], SEC_LEVEL_MAP[i][n]);
                }
                break block3;
            }
            for (int i = 0; i < SEC_LEVEL_MANAGED_PROPERTIES.length; ++i) {
                Config.get();
                Config.setStringProperty(SEC_LEVEL_MANAGED_PROPERTIES[i], null);
            }
        }
    }

    public static String getSecurityLevel() {
        Config.get();
        return Config.getStringProperty("deployment.security.level");
    }

    private static int getSecurityLevelInt() {
        return SecuritySettings.getLevelInt(SecuritySettings.getSecurityLevel());
    }

    private static int getLevelInt(String string) {
        for (int i = 0; i < SECURITY_LEVELS.length; ++i) {
            if (!SECURITY_LEVELS[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static void setInstallerRecommendedSecurityLevel(int n) {
        if (n >= 0 && n < SECURITY_LEVELS.length) {
            SecuritySettings.setSystemDeploymentProperty("deployment.security.level", SECURITY_LEVELS[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSystemDeploymentProperty(String string, String string2) {
        block8: {
            try {
                File file = new File(Config.getSystemHomePropertiesFile());
                Properties properties = new Properties();
                if (file.exists()) {
                    properties.load(new FileInputStream(file));
                }
                properties.setProperty(string, string2);
                new FileOutputStream(file);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                if (fileOutputStream == null) break block8;
                try {
                    properties.store(fileOutputStream, "System Deployment Properties");
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    fileOutputStream.flush();
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                fileOutputStream.flush();
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

