/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SET;
import iaik.asn1.structures.AVA;
import iaik.utils.RFC2253NameParserException;
import java.util.Enumeration;
import java.util.Vector;

public class RDN
implements ASN1Type {
    protected Vector avas = new Vector(3);

    /*
     * Enabled aggressive block sorting
     */
    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.avas.elements();
        if (!enumeration.hasMoreElements()) {
            return stringBuffer.toString();
        }
        stringBuffer.append(((AVA)enumeration.nextElement()).toString(bl));
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("+" + ((AVA)enumeration.nextElement()).toString(bl));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() {
        SET sET = new SET(true);
        Enumeration enumeration = this.avas.elements();
        while (enumeration.hasMoreElements()) {
            sET.addComponent(((AVA)enumeration.nextElement()).toASN1Object());
        }
        return sET;
    }

    public int hashCode() {
        int n2;
        int n3 = n2 = this.avas.size();
        Enumeration enumeration = this.avas.elements();
        while (enumeration.hasMoreElements()) {
            AVA aVA = (AVA)enumeration.nextElement();
            n3 = n3 << 7 | n3 >>> 25;
            n3 += aVA.hashCode();
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getRFC2253String(boolean bl) throws RFC2253NameParserException {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.avas.elements();
        if (!enumeration.hasMoreElements()) {
            return stringBuffer.toString();
        }
        stringBuffer.append(((AVA)enumeration.nextElement()).getRFC2253String(bl));
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("+" + ((AVA)enumeration.nextElement()).getRFC2253String(bl));
        }
        return stringBuffer.toString();
    }

    public String getRFC2253String() throws RFC2253NameParserException {
        return this.getRFC2253String(true);
    }

    public AVA[] getAVAs() {
        Object[] objectArray = new AVA[this.avas.size()];
        this.avas.copyInto(objectArray);
        return objectArray;
    }

    public AVA getAVA(ObjectID objectID) {
        Enumeration enumeration = this.avas.elements();
        while (enumeration.hasMoreElements()) {
            AVA aVA = (AVA)enumeration.nextElement();
            if (!aVA.getType().equals(objectID)) continue;
            return aVA;
        }
        return null;
    }

    public AVA getAVA() {
        return (AVA)this.avas.elementAt(0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RDN)) {
            return false;
        }
        RDN rDN = (RDN)object;
        int n2 = this.avas.size();
        if (n2 != rDN.avas.size()) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            AVA aVA;
            AVA aVA2 = (AVA)this.avas.elementAt(n3);
            if (!aVA2.equals(aVA = (AVA)rDN.avas.elementAt(n3))) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public Enumeration elements() {
        return this.avas.elements();
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        int n2 = 0;
        while (n2 < aSN1Object.countComponents()) {
            AVA aVA = new AVA(aSN1Object.getComponentAt(n2));
            this.addAVA(aVA);
            ++n2;
        }
    }

    public void addAVA(AVA aVA) {
        ObjectID objectID = aVA.getType();
        int n2 = this.avas.size();
        int n3 = 0;
        while (n3 < n2) {
            AVA aVA2 = (AVA)this.avas.elementAt(n3);
            if (aVA2.getType().equals(objectID)) {
                this.avas.setElementAt(aVA, n3);
                return;
            }
            ++n3;
        }
        this.avas.addElement(aVA);
    }

    public void addAVA(ObjectID objectID, Object object) {
        this.addAVA(new AVA(objectID, object));
    }

    public RDN(ObjectID objectID, Object object) {
        this();
        this.addAVA(objectID, object);
    }

    public RDN(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public RDN() {
    }
}

