/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.Name;
import iaik.utils.Util;
import iaik.x509.PublicKeyInfo;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.X509Extensions;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.SubjectAltName;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;

public class X509Certificate
extends java.security.cert.X509Certificate
implements Serializable,
ASN1Type {
    private byte[] m;
    private boolean j;
    private X509Extensions n;
    private byte[] e;
    private BigInteger b;
    private BigInteger k;
    private PublicKey g;
    private Name c;
    private ChoiceOfTime i;
    private ChoiceOfTime h;
    private Name l;
    private AlgorithmID d;
    private BigInteger f;
    private int a;
    private transient ASN1 o;

    public void writeTo(OutputStream outputStream) throws IOException {
        this.a();
        this.o.writeTo(outputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.toByteArray());
    }

    public void verify(PublicKey publicKey, AlgorithmParameterSpec algorithmParameterSpec) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        this.a();
        Signature signature = this.d.getSignatureInstance("IAIK");
        try {
            byte[] byArray = this.o.getFirstObject();
            if (algorithmParameterSpec instanceof DSAParameterSpec) {
                signature.setParameter("DSAParameterSpec", algorithmParameterSpec);
            } else {
                signature.setParameter("AlgorithmParameterSpec", algorithmParameterSpec);
            }
            signature.initVerify(publicKey);
            signature.update(byArray);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        if (!signature.verify(this.e)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public void verify(PublicKey publicKey, String string) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        this.a();
        Signature signature = null;
        signature = string == null ? this.d.getSignatureInstance() : this.d.getSignatureInstance(string);
        try {
            byte[] byArray = this.o.getFirstObject();
            signature.initVerify(publicKey);
            signature.update(byArray);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        if (!signature.verify(this.e)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public void verify(PublicKey publicKey) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        this.verify(publicKey, (String)null);
    }

    public void verify() throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        this.verify(this.g);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.a + "\n");
        if (this.f != null) {
            stringBuffer.append("Serial number: " + this.f + "\n");
        }
        if (this.d != null) {
            stringBuffer.append("Signature algorithm: " + this.d + "\n");
        }
        if (this.l != null) {
            stringBuffer.append("Issuer: " + this.l + "\n");
        }
        if (this.h != null) {
            stringBuffer.append("Valid not before: " + this.h + "\n");
        }
        if (this.i != null) {
            stringBuffer.append("      not after: " + this.i + "\n");
        }
        if (this.c != null) {
            stringBuffer.append("Subject: " + this.c + "\n");
        }
        if (this.g != null) {
            stringBuffer.append(this.g.toString());
        }
        if (this.k != null) {
            stringBuffer.append("Issuer Unique ID: " + this.k + "\n");
        }
        if (this.b != null) {
            stringBuffer.append("Subject Unique ID: " + this.b + "\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("Certificate Fingerprint (MD5)  : " + Util.toString(this.getFingerprint()) + "\n");
        stringBuffer.append("Certificate Fingerprint (SHA-1): " + Util.toString(this.getFingerprintSHA()) + "\n");
        stringBuffer.append("\n");
        if (this.n != null) {
            if (bl) {
                stringBuffer.append(this.n);
            } else {
                stringBuffer.append("Extensions: " + this.n.countExtensions() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public byte[] toByteArray() {
        this.a();
        return this.o.toByteArray();
    }

    private boolean[] a(String string) {
        boolean[] blArray = new boolean[string.length()];
        int n2 = 0;
        while (n2 < blArray.length) {
            blArray[n2] = string.charAt(n2) == '1';
            ++n2;
        }
        return blArray;
    }

    public ASN1Object toASN1Object() {
        this.a();
        return this.o.toASN1Object();
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, String string) throws NoSuchAlgorithmException, InvalidKeyException, CertificateException {
        Object object;
        if (algorithmID == null) {
            throw new CertificateException("Cannot sign certificate! No signature algorithm specified!");
        }
        this.d = algorithmID;
        Signature signature = this.d.getSignatureInstance(string);
        signature.initSign(privateKey);
        try {
            if (!AlgorithmID.getDoNotIncludeParameters(this.d) && !this.d.hasParameters() && (object = signature.getParameter("")) != null && object instanceof AlgorithmParameters) {
                this.d.setAlgorithmParameters((AlgorithmParameters)object);
            }
        }
        catch (Exception exception) {}
        object = this.b();
        try {
            signature.update(DerCoder.encode((ASN1Object)object));
            this.e = signature.sign();
            BIT_STRING bIT_STRING = new BIT_STRING(this.e);
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)object);
            sEQUENCE.addComponent(this.d.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.o = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        catch (SignatureException signatureException) {
            throw new CertificateException(signatureException.toString());
        }
        this.d();
        this.e();
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, CertificateException {
        this.sign(algorithmID, privateKey, null);
    }

    public void setValidNotBefore(Date date) {
        this.h = new ChoiceOfTime(date, true);
        this.d();
    }

    public void setValidNotAfter(Date date) {
        this.i = new ChoiceOfTime(date, true);
        this.d();
    }

    public void setSubjectUniqueID(boolean[] blArray) {
        this.b = new BigInteger(this.a(blArray), 2);
        this.a = 2;
        this.d();
    }

    public void setSubjectDN(Principal principal) throws IllegalArgumentException {
        try {
            this.c = (Name)principal;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Subject is not an instance of Name.");
        }
        this.d();
    }

    private void e() {
        this.j = false;
    }

    public void setSignatureAlgorithm(AlgorithmID algorithmID) {
        this.d = algorithmID;
        this.d();
    }

    public void setSignature(byte[] byArray) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Cannot sign certificate! No signature value specified!");
        }
        this.e = byArray;
        ASN1Object aSN1Object = this.b();
        try {
            BIT_STRING bIT_STRING = new BIT_STRING(byArray);
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(aSN1Object);
            sEQUENCE.addComponent(this.d.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.o = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        this.d();
        this.e();
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.f = bigInteger;
        this.d();
    }

    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        this.g = publicKey;
        this.d();
    }

    private void d() {
        this.j = true;
        this.m = null;
    }

    public void setIssuerUniqueID(boolean[] blArray) {
        this.k = new BigInteger(this.a(blArray), 2);
        this.a = 2;
        this.d();
    }

    public void setIssuerDN(Principal principal) throws IllegalArgumentException {
        try {
            this.l = (Name)principal;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Issuer is not an instance of Name.");
        }
        this.d();
    }

    public boolean removeExtension(ObjectID objectID) {
        boolean bl = false;
        boolean bl2 = bl = this.n == null ? false : this.n.removeExtension(objectID);
        if (bl) {
            this.d();
        }
        return bl;
    }

    public void removeAllExtensions() {
        if (this.n != null) {
            this.n.removeAllExtensions();
            this.d();
        }
        this.n = null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        try {
            this.o = new ASN1(objectInputStream);
            this.c();
            return;
        }
        catch (Exception exception) {
            throw new IOException("Unable to restore Certificate: " + exception.toString());
        }
    }

    public Enumeration listExtensions() {
        if (this.n == null) {
            return null;
        }
        return this.n.listExtensions();
    }

    private void c() throws X509ExtensionException, CertificateException {
        int n2 = 0;
        ASN1Object aSN1Object = null;
        try {
            Object object;
            if (this.o.countComponents() != 3) {
                throw new CertificateException("Certificate SEQUENCE must have 3 components!");
            }
            ASN1Object aSN1Object2 = this.o.getComponentAt(0);
            AlgorithmID algorithmID = new AlgorithmID(this.o.getComponentAt(1));
            ASN1Object aSN1Object3 = this.o.getComponentAt(2);
            this.e = (byte[])((BIT_STRING)aSN1Object3).getValue();
            ASN1Object aSN1Object4 = aSN1Object2.getComponentAt(0);
            if (aSN1Object4.isA(ASN.CON_SPEC)) {
                object = (BigInteger)((ASN1Object)aSN1Object4.getValue()).getValue();
                this.a = ((BigInteger)object).intValue() + 1;
                ++n2;
            } else {
                this.a = 1;
            }
            this.f = (BigInteger)aSN1Object2.getComponentAt(n2).getValue();
            this.d = new AlgorithmID(aSN1Object2.getComponentAt(1 + n2));
            if (!algorithmID.equals(this.d)) {
                throw new CertificateException("Certificate signature algorithm mismatch");
            }
            this.l = new Name(aSN1Object2.getComponentAt(2 + n2));
            object = new ASN1(aSN1Object2.getComponentAt(3 + n2));
            this.h = new ChoiceOfTime(((ASN1)object).getComponentAt(0));
            this.i = new ChoiceOfTime(((ASN1)object).getComponentAt(1));
            this.c = new Name(aSN1Object2.getComponentAt(4 + n2));
            aSN1Object = aSN1Object2.getComponentAt(5 + n2);
            int n3 = 6 + n2;
            while (n3 < aSN1Object2.countComponents()) {
                CON_SPEC cON_SPEC;
                if ((cON_SPEC = (CON_SPEC)aSN1Object2.getComponentAt(n3++)).getAsnType().getTag() == 1) {
                    cON_SPEC.forceImplicitlyTagged(ASN.BIT_STRING);
                    this.k = new BigInteger(1, (byte[])((ASN1Object)cON_SPEC.getValue()).getValue());
                    continue;
                }
                if (cON_SPEC.getAsnType().getTag() == 2) {
                    cON_SPEC.forceImplicitlyTagged(ASN.BIT_STRING);
                    this.b = new BigInteger(1, (byte[])((ASN1Object)cON_SPEC.getValue()).getValue());
                    continue;
                }
                if (cON_SPEC.getAsnType().getTag() != 3) continue;
                this.n = new X509Extensions((ASN1Object)cON_SPEC.getValue());
            }
        }
        catch (RuntimeException runtimeException) {
            throw new CertificateException("Certificate format error: " + runtimeException.toString());
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        try {
            this.g = PublicKeyInfo.getPublicKey(aSN1Object);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CertificateException(invalidKeyException.toString());
        }
        this.o.clearASN1Object();
        this.e();
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.n == null) {
            return false;
        }
        return this.n.hasUnsupportedCriticalExtension();
    }

    public boolean hasExtensions() {
        if (this.n == null) {
            return false;
        }
        return this.n.hasExtensions();
    }

    public int getVersion() {
        return this.a;
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            if (this.o != null && this.o.toByteArray() != null) {
                return this.o.getFirstObject();
            }
            return DerCoder.encode(this.b());
        }
        catch (CodingException codingException) {
            throw new CertificateEncodingException(codingException.toString());
        }
    }

    public boolean[] getSubjectUniqueID() {
        if (this.b == null) {
            return null;
        }
        String string = this.b.toString(2);
        return this.a(string);
    }

    public Principal getSubjectDN() {
        return this.c;
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.d;
    }

    public byte[] getSignature() {
        return this.e;
    }

    public byte[] getSigAlgParams() {
        if (this.d == null) {
            return null;
        }
        try {
            ASN1Object aSN1Object = this.d.getParameter();
            if (aSN1Object == null) {
                return null;
            }
            return new ASN1(aSN1Object).toByteArray();
        }
        catch (CodingException codingException) {
            throw new RuntimeException(codingException.toString());
        }
    }

    public String getSigAlgOID() {
        if (this.d == null) {
            return null;
        }
        return this.d.getAlgorithm().getID();
    }

    public String getSigAlgName() {
        String string = null;
        try {
            string = this.d == null ? null : this.d.getImplementationName();
        }
        catch (Exception exception) {
            string = this.d == null ? null : this.d.getName();
        }
        return string;
    }

    public BigInteger getSerialNumber() {
        return this.f;
    }

    public PublicKey getPublicKey() {
        return this.g;
    }

    public Date getNotBefore() {
        if (this.h == null) {
            return null;
        }
        return this.h.getDate();
    }

    public Date getNotAfter() {
        if (this.i == null) {
            return null;
        }
        return this.i.getDate();
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.n == null) {
            return null;
        }
        return this.n.getNonCriticalExtensionOIDs();
    }

    public boolean[] getKeyUsage() {
        if (this.n == null) {
            return null;
        }
        try {
            KeyUsage keyUsage = (KeyUsage)this.n.getExtension(KeyUsage.oid);
            if (keyUsage != null) {
                return keyUsage.getBooleanArray();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public boolean[] getIssuerUniqueID() {
        if (this.k == null) {
            return null;
        }
        String string = this.k.toString(2);
        return this.a(string);
    }

    public Principal getIssuerDN() {
        return this.l;
    }

    public byte[] getFingerprintSHA() {
        if (this.m == null) {
            try {
                this.m = this.getFingerprint("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("Algorithm SHA not available: " + noSuchAlgorithmException.toString());
            }
        }
        return this.m;
    }

    public byte[] getFingerprint(String string) throws NoSuchAlgorithmException {
        this.a();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(this.toByteArray());
        return messageDigest.digest();
    }

    public byte[] getFingerprint() {
        this.a();
        return this.o.fingerprint();
    }

    public byte[] getExtensionValue(String string) {
        if (this.n == null) {
            return null;
        }
        return this.n.getExtensionValue(string);
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        if (this.n == null) {
            return null;
        }
        return this.n.getExtension(objectID);
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        this.a();
        return this.toByteArray();
    }

    public String[] getEmailAddresses() {
        Object object;
        Vector<String> vector = new Vector<String>();
        if (this.c != null && (object = this.c.getRDNs(ObjectID.emailAddress)) != null) {
            int n2 = 0;
            while (n2 < ((Object)object).length) {
                vector.addElement(((String)object[n2]).toLowerCase());
                ++n2;
            }
        }
        try {
            object = (SubjectAltName)this.getExtension(SubjectAltName.oid);
            if (object != null) {
                Enumeration enumeration = ((SubjectAltName)object).getGeneralNames().getNames();
                while (enumeration.hasMoreElements()) {
                    GeneralName generalName = (GeneralName)enumeration.nextElement();
                    if (generalName.getType() != 1) continue;
                    vector.addElement(((String)generalName.getName()).toLowerCase());
                }
            }
        }
        catch (Exception exception) {}
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public Set getCriticalExtensionOIDs() {
        if (this.n == null) {
            return null;
        }
        return this.n.getCriticalExtensionOIDs();
    }

    public int getBasicConstraints() {
        int n2;
        block3: {
            n2 = -1;
            if (this.n == null) break block3;
            try {
                BasicConstraints basicConstraints = (BasicConstraints)this.n.getExtension(BasicConstraints.oid);
                if (basicConstraints != null && basicConstraints.ca() && (n2 = basicConstraints.getPathLenConstraint()) == -1) {
                    n2 = Integer.MAX_VALUE;
                }
            }
            catch (Exception exception) {}
        }
        return n2;
    }

    private String a(boolean[] blArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2]) {
                stringBuffer.append('1');
            } else {
                stringBuffer.append('0');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void decode(InputStream inputStream) throws CertificateException, IOException {
        if (inputStream == null) {
            throw new NullPointerException("Cannot parse certificate from a null input stream!");
        }
        try {
            this.o = new ASN1(inputStream);
            this.c();
            return;
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CertificateException(x509ExtensionException.toString());
        }
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new NullPointerException("Cannot parse certificate from a null object!");
        }
        this.o = new ASN1(aSN1Object);
        try {
            this.c();
            return;
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    private ASN1Object b() throws CertificateEncodingException {
        this.a = 1;
        SEQUENCE sEQUENCE = null;
        if (this.f == null) {
            throw new CertificateEncodingException("Serial number not set!");
        }
        if (this.d == null) {
            throw new CertificateEncodingException("Signature algorithm not set!");
        }
        if (this.l == null) {
            throw new CertificateEncodingException("Issuer not set!");
        }
        if (this.h == null) {
            throw new CertificateEncodingException("Valid not before not set!");
        }
        if (this.i == null) {
            throw new CertificateEncodingException("Valid not after not set!");
        }
        if (this.c == null) {
            throw new CertificateEncodingException("Subject not set!");
        }
        if (this.g == null) {
            throw new CertificateEncodingException("Public key not set!");
        }
        if (this.k != null || this.b != null) {
            this.a = 2;
        }
        if (this.n != null) {
            if (this.n.hasExtensions()) {
                this.a = 3;
            } else {
                this.n = null;
            }
        }
        try {
            BIT_STRING bIT_STRING;
            sEQUENCE = new SEQUENCE();
            if (this.a > 1) {
                sEQUENCE.addComponent(new CON_SPEC(0, new INTEGER(this.a - 1)));
            }
            sEQUENCE.addComponent(new INTEGER(this.f));
            sEQUENCE.addComponent(this.d.toASN1Object());
            sEQUENCE.addComponent(this.l.toASN1Object());
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(this.h.toASN1Object());
            sEQUENCE2.addComponent(this.i.toASN1Object());
            sEQUENCE.addComponent(sEQUENCE2);
            sEQUENCE.addComponent(this.c.toASN1Object());
            sEQUENCE.addComponent(DerCoder.decode(this.g.getEncoded()));
            if (this.k != null) {
                bIT_STRING = new BIT_STRING(this.k.toByteArray());
                sEQUENCE.addComponent(new CON_SPEC(1, bIT_STRING, true));
            }
            if (this.b != null) {
                bIT_STRING = new BIT_STRING(this.b.toByteArray());
                sEQUENCE.addComponent(new CON_SPEC(2, bIT_STRING, true));
            }
            if (this.n != null) {
                sEQUENCE.addComponent(new CON_SPEC(3, this.n.toASN1Object()));
            }
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new CertificateEncodingException(exception.toString());
        }
    }

    public int countExtensions() {
        if (this.n == null) {
            return 0;
        }
        return this.n.countExtensions();
    }

    public void checkValidity(Date date) throws CertificateNotYetValidException, CertificateExpiredException {
        if (this.h == null) {
            throw new CertificateNotYetValidException("ValidNotBefore date not set!");
        }
        if (date.before(this.h.getDate())) {
            throw new CertificateNotYetValidException();
        }
        if (this.i == null) {
            throw new CertificateExpiredException("ValidNotAfter date not set!");
        }
        if (date.after(this.i.getDate())) {
            throw new CertificateExpiredException();
        }
    }

    public void checkValidity() throws CertificateNotYetValidException, CertificateExpiredException {
        this.checkValidity(new Date());
    }

    private void a() {
        if (this.j) {
            throw new RuntimeException("Cannot perform operation, certificate has to be signed first");
        }
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.n == null) {
            this.n = new X509Extensions();
        }
        this.n.addExtension(v3Extension);
        this.a = 3;
        this.d();
    }

    public X509Certificate(byte[] byArray) throws CertificateException {
        if (byArray == null) {
            throw new NullPointerException("Cannot parse certificate from a null byte array!");
        }
        try {
            this.o = new ASN1(byArray);
            this.c();
            return;
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CertificateException(x509ExtensionException.toString());
        }
    }

    public X509Certificate(InputStream inputStream) throws CertificateException, IOException {
        if (inputStream == null) {
            throw new NullPointerException("Cannot parse certificate from a null input stream!");
        }
        this.decode(inputStream);
    }

    public X509Certificate(ASN1Object aSN1Object) throws CertificateException {
        try {
            this.decode(aSN1Object);
            return;
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
    }

    public X509Certificate() {
        this.a = 1;
        this.o = new ASN1();
        this.d();
    }
}

