/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.utils.Util;
import iaik.x509.RevokedCertificate;
import iaik.x509.V3Extension;
import iaik.x509.X509CRL;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.attr.AttCertIssuer;
import iaik.x509.attr.AttributeCertificate;
import iaik.x509.attr.RevokedAttributeCertificate;
import iaik.x509.attr.V2Form;
import iaik.x509.extensions.CertificateIssuer;
import iaik.x509.extensions.ReasonCode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;

public class ACRL
extends java.security.cert.X509CRL
implements ASN1Type {
    private X509CRL a;

    public void writeTo(OutputStream outputStream) throws IOException {
        this.a.writeTo(outputStream);
    }

    public void verify(PublicKey publicKey, String string) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CRLException {
        this.a.verify(publicKey, string);
    }

    public void verify(PublicKey publicKey) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CRLException {
        this.a.verify(publicKey, (String)null);
    }

    public String toString(boolean bl) {
        return this.a.toString(true);
    }

    public String toString() {
        return this.a.toString(false);
    }

    public byte[] toByteArray() {
        return this.a.toByteArray();
    }

    public ASN1Object toASN1Object() {
        return this.a.toASN1Object();
    }

    public void sign(PrivateKey privateKey, String string) throws NoSuchAlgorithmException, InvalidKeyException, CRLException {
        this.a.sign(privateKey, string);
    }

    public void sign(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, CRLException {
        this.a.sign(privateKey, null);
    }

    public void setThisUpdate(Date date) {
        this.a.setThisUpdate(date);
    }

    public void setSignatureAlgorithm(AlgorithmID algorithmID) {
        this.a.setSignatureAlgorithm(algorithmID);
    }

    public void setSignature(byte[] byArray) throws CRLException {
        this.a.setSignature(byArray);
    }

    public void setNextUpdate(Date date) {
        this.a.setNextUpdate(date);
    }

    public void setIssuerDN(Principal principal) throws IllegalArgumentException {
        this.a.setIssuerDN(principal);
    }

    public boolean removeExtension(ObjectID objectID) {
        return this.a.removeExtension(objectID);
    }

    public boolean removeCertificate(BigInteger bigInteger) {
        return this.a.removeCertificate(bigInteger);
    }

    public boolean removeCertificate(AttributeCertificate attributeCertificate) {
        boolean bl = false;
        Name name = ACRL.a(attributeCertificate);
        bl = name != null ? this.a.removeCertificate(name, attributeCertificate.getSerialNumber()) : this.a.removeCertificate(attributeCertificate.getSerialNumber());
        return bl;
    }

    public void removeAllExtensions() {
        this.a.removeAllExtensions();
    }

    public void removeAllCertificates() {
        this.a.removeAllCertificates();
    }

    public Enumeration listExtensions() {
        return this.a.listExtensions();
    }

    public Enumeration listCertificates() {
        return this.a.listCertificates();
    }

    public boolean isRevoked(Certificate certificate) {
        AttributeCertificate attributeCertificate = null;
        try {
            attributeCertificate = Util.convertToAttributeCertificate(certificate);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid certificate format: " + exception.toString());
        }
        return ACRL.a(this.containsCertificate(attributeCertificate));
    }

    public boolean isRevoked(BigInteger bigInteger) {
        return this.a.isRevoked(bigInteger);
    }

    private static boolean a(RevokedCertificate revokedCertificate) {
        if (revokedCertificate == null) {
            return false;
        }
        try {
            ReasonCode reasonCode = (ReasonCode)revokedCertificate.getExtension(ReasonCode.oid);
            if (reasonCode != null && reasonCode.getReasonCode() == 8) {
                return false;
            }
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {}
        return true;
    }

    public boolean isIndirectCRL() {
        return this.a.isIndirectCRL();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.a.hasUnsupportedCriticalExtension();
    }

    public boolean hasExtensions() {
        return this.a.hasExtensions();
    }

    public int getVersion() {
        return this.a.getVersion();
    }

    public Date getThisUpdate() {
        return this.a.getThisUpdate();
    }

    public byte[] getTBSCertList() throws CRLException {
        return this.a.getTBSCertList();
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.a.getSignatureAlgorithm();
    }

    public byte[] getSignature() {
        return this.a.getSignature();
    }

    public byte[] getSigAlgParams() {
        return this.a.getSigAlgParams();
    }

    public String getSigAlgOID() {
        return this.a.getSigAlgOID();
    }

    public String getSigAlgName() {
        return this.a.getSigAlgName();
    }

    public Set getRevokedCertificates() {
        return this.a.getRevokedCertificates();
    }

    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        return this.a.getRevokedCertificate(bigInteger);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.a.getNonCriticalExtensionOIDs();
    }

    public Date getNextUpdate() {
        return this.a.getNextUpdate();
    }

    public Enumeration getIssuerDNs() {
        return this.a.getIssuerDNs();
    }

    private static Name a(AttributeCertificate attributeCertificate) {
        AttCertIssuer attCertIssuer = attributeCertificate.getIssuer();
        Name name = null;
        int n2 = attCertIssuer.getVForm();
        if (n2 == 2) {
            name = ((V2Form)attCertIssuer).getIssuerDN();
        } else if (n2 == 2) {
            name = ((V2Form)attCertIssuer).getIssuerDN();
        }
        return name;
    }

    public Principal getIssuerDN() {
        return this.a.getIssuerDN();
    }

    public byte[] getFingerprintSHA() {
        return this.a.getFingerprintSHA();
    }

    public byte[] getFingerprint(String string) throws NoSuchAlgorithmException {
        return this.a.getFingerprint();
    }

    public byte[] getFingerprint() {
        return this.a.getFingerprint();
    }

    public byte[] getExtensionValue(String string) {
        return this.a.getExtensionValue(string);
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        return this.a.getExtension(objectID);
    }

    public byte[] getEncoded() throws CRLException {
        return this.a.toByteArray();
    }

    public Set getCriticalExtensionOIDs() {
        return this.a.getCriticalExtensionOIDs();
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.a.decode(aSN1Object);
    }

    public int countExtensions() {
        return this.a.countExtensions();
    }

    public RevokedCertificate containsCertificate(BigInteger bigInteger) {
        return this.a.containsCertificate(bigInteger);
    }

    public RevokedCertificate containsCertificate(AttributeCertificate attributeCertificate) {
        Name name = ACRL.a(attributeCertificate);
        BigInteger bigInteger = attributeCertificate.getSerialNumber();
        if (name == null) {
            return this.a.containsCertificate(bigInteger);
        }
        return this.a.containsCertificate(name, bigInteger);
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        this.a.addExtension(v3Extension);
    }

    public void addCertificate(RevokedAttributeCertificate revokedAttributeCertificate) {
        this.a.addCertificate(revokedAttributeCertificate);
    }

    public void addCertificate(AttributeCertificate attributeCertificate, Date date) throws CRLException {
        Name name = ACRL.a(attributeCertificate);
        RevokedAttributeCertificate revokedAttributeCertificate = new RevokedAttributeCertificate(attributeCertificate, date);
        if (name != null && !name.equals(this.getIssuerDN())) {
            try {
                revokedAttributeCertificate.addExtension(new CertificateIssuer(name));
            }
            catch (X509ExtensionException x509ExtensionException) {
                throw new CRLException("Cannot add certificate: " + x509ExtensionException.toString());
            }
        }
        try {
            this.addCertificate(revokedAttributeCertificate);
            return;
        }
        catch (Exception exception) {
            throw new CRLException("Cannot add certificate: " + exception.toString());
        }
    }

    public ACRL(byte[] byArray) throws CRLException {
        this.a = new X509CRL(byArray);
    }

    public ACRL(InputStream inputStream) throws CRLException, IOException {
        this.a = new X509CRL(inputStream);
    }

    public ACRL(ASN1Object aSN1Object) throws CRLException {
        this.a = new X509CRL(aSN1Object);
    }

    public ACRL() {
        this.a = new X509CRL();
    }
}

