/*
 * Decompiled with CFR 0.152.
 */
package iaik.tsp;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;

public class PKIFailureInfo {
    private String a = "0";
    private static final String f = "0";
    protected static final String SYSTEM_FAILURE_TEXT = "the request cannot be handled due to system failure";
    protected static final String ADD_INFO_NOT_AVAILABLE_TEXT = "the additional information requested could not be understood or is not available";
    protected static final String UNACCEPTED_EXTENSION_TEXT = "the requested extension is not supported by the TSA";
    protected static final String UNACCEPTED_POLICY_TEXT = "the requested TSA policy is not supported by the TSA";
    protected static final String TIME_NOT_AVAILABLE_TEXT = "the TSA's time source is not available";
    protected static final String BAD_DATA_FORMAT_TEXT = "the data submitted has the wrong format";
    protected static final String BAD_REQUEST_TEXT = "transaction not permitted or supported";
    protected static final String BAD_ALG_TEXT = "unrecognized or unsupported Algorithm Identifier";
    public static final String SYSTEM_FAILURE = "00000000000000000000000001";
    public static final String ADD_INFO_NOT_AVAILABLE = "000000000000000001";
    public static final String UNACCEPTED_EXTENSION = "00000000000000001";
    public static final String UNACCEPTED_POLICY = "0000000000000001";
    public static final String TIME_NOT_AVAILABLE = "000000000000001";
    public static final String BAD_DATA_FORMAT = "000001";
    public static final String BAD_REQUEST = "001";
    public static final String BAD_ALG = "1";
    private static final int e = 25;
    private static final int j = 17;
    private static final int c = 16;
    private static final int b = 15;
    private static final int d = 14;
    private static final int h = 5;
    private static final int g = 2;
    private static final int i = 0;

    private void a(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.BIT_STRING)) {
            throw new CodingException("No PKIFailureInfo!");
        }
        try {
            this.a = ((BIT_STRING)aSN1Object).getBinaryString();
        }
        catch (NumberFormatException numberFormatException) {
            throw new CodingException("No BIT_STRING!");
        }
        try {
            this.testFailureInfoBounds(this.a);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CodingException("Wrong failure info field value: " + String.valueOf(this.a));
        }
    }

    protected void testFailureInfoBounds(String string) throws IllegalArgumentException {
        int n = string.indexOf(49);
        if (n != 0 && n != 2 && n != 5 && n != 14 && n != 15 && n != 16 && n != 17 && n != 25) {
            throw new IllegalArgumentException("Illegale FailureInfo value.");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<PKIFailureInfo>\n\t" + String.valueOf(this.a) + "\n\t");
        int n = this.a.indexOf(49);
        if (n == 0) {
            stringBuffer.append(BAD_ALG_TEXT);
        } else if (n == 2) {
            stringBuffer.append(BAD_REQUEST_TEXT);
        } else if (n == 5) {
            stringBuffer.append(BAD_DATA_FORMAT_TEXT);
        } else if (n == 14) {
            stringBuffer.append(TIME_NOT_AVAILABLE_TEXT);
        } else if (n == 15) {
            stringBuffer.append(UNACCEPTED_POLICY_TEXT);
        } else if (n == 16) {
            stringBuffer.append(UNACCEPTED_EXTENSION_TEXT);
        } else if (n == 17) {
            stringBuffer.append(ADD_INFO_NOT_AVAILABLE_TEXT);
        } else if (n == 25) {
            stringBuffer.append(SYSTEM_FAILURE_TEXT);
        }
        stringBuffer.append("\n</PKIFailureInfo>");
        return stringBuffer.toString();
    }

    public String getFailureInfo() {
        return this.a;
    }

    public void setFailureInfo(String string) throws IllegalArgumentException {
        this.testFailureInfoBounds(string);
        this.a = string;
    }

    public ASN1Object toASN1Object() {
        return new BIT_STRING(this.a);
    }

    public byte[] getEncoded() {
        return DerCoder.encode((ASN1Object)this.toASN1Object());
    }

    public PKIFailureInfo(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }

    public PKIFailureInfo(String string) throws IllegalArgumentException {
        this.testFailureInfoBounds(string);
        this.a = string;
    }
}

