/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.transform;

import iaik.xml.crypto.dsig.spec.AlgorithmParameterImpl;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.filter.impl.dsig.Traverser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class TransformServiceImpl
extends TransformService {
    protected Node transformNode_;

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext, OutputStream outputStream) throws TransformException {
        Data data2 = this.transform(data, xMLCryptoContext);
        if (data2 instanceof OctetStreamData) {
            InputStream inputStream = ((OctetStreamData)data2).getOctetStream();
            try {
                int n;
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                throw new TransformException(iOException);
            }
            return null;
        }
        return data2;
    }

    protected abstract void setParameterSpec(List var1) throws InvalidAlgorithmParameterException;

    protected abstract void setParameterSpec(AlgorithmParameterSpec var1) throws InvalidAlgorithmParameterException;

    protected Iterator parse(OctetStreamData octetStreamData) throws TransformException {
        Document document;
        try {
            document = DOMUtils.parse(octetStreamData.getOctetStream(), new Boolean(true), new Boolean(true), new Boolean(false), null, null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformException(parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new TransformException(iOException);
        }
        catch (SAXException sAXException) {
            throw new TransformException(sAXException);
        }
        DOMUtils.distributeNSDeclarations(document.getDocumentElement());
        return new Traverser(document, true, true);
    }

    public void marshalParams(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws MarshalException {
        if (xMLStructure instanceof DOMStructure) {
            this.transformNode_ = ((DOMStructure)xMLStructure).getNode();
        } else if (xMLStructure instanceof iaik.xml.crypto.dom.DOMStructure) {
            this.transformNode_ = ((iaik.xml.crypto.dom.DOMStructure)xMLStructure).getNode();
        } else {
            throw new ClassCastException("The parent type is not compatible with this " + this.getClass().getName() + ".");
        }
        if (xMLCryptoContext == null) {
            xMLCryptoContext = new iaik.xml.crypto.dom.DOMCryptoContext();
        }
        Iterator iterator = this.getAlgorithmParameters().iterator();
        while (iterator.hasNext()) {
            AlgorithmParameterImpl algorithmParameterImpl = (AlgorithmParameterImpl)iterator.next();
            algorithmParameterImpl.setParentStructure((iaik.xml.crypto.dom.DOMStructure)xMLStructure);
            algorithmParameterImpl.marshal((DOMCryptoContext)xMLCryptoContext, this.transformNode_, null);
        }
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public void init(TransformParameterSpec transformParameterSpec) throws InvalidAlgorithmParameterException {
        try {
            this.setParameterSpec(transformParameterSpec);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidAlgorithmParameterException("TransformParameterSpec '" + transformParameterSpec.getClass().getName() + "' not supported by Transform " + this.getAlgorithm() + " (" + this.getClass().getName() + ").");
        }
    }

    public void init(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws InvalidAlgorithmParameterException {
        if (xMLStructure instanceof DOMStructure) {
            this.transformNode_ = ((DOMStructure)xMLStructure).getNode();
        } else if (xMLStructure instanceof iaik.xml.crypto.dom.DOMStructure) {
            this.transformNode_ = ((iaik.xml.crypto.dom.DOMStructure)xMLStructure).getNode();
        } else {
            throw new ClassCastException("The parent type is not compatible with this Transform (" + this.getClass().getName() + ").");
        }
        if (xMLCryptoContext == null) {
            xMLCryptoContext = new iaik.xml.crypto.dom.DOMCryptoContext();
        }
        ArrayList<iaik.xml.crypto.dom.DOMStructure> arrayList = new ArrayList<iaik.xml.crypto.dom.DOMStructure>();
        try {
            Node node = this.transformNode_.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    arrayList.add(iaik.xml.crypto.dom.DOMStructure.getInstance(node, (DOMCryptoContext)xMLCryptoContext));
                }
                node = node.getNextSibling();
            }
        }
        catch (MarshalException marshalException) {
            throw new InvalidAlgorithmParameterException(marshalException.getMessage());
        }
        try {
            this.setParameterSpec(arrayList);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameter '" + arrayList.getClass().getName() + "' not supported by Transform " + this.getAlgorithm() + " (" + this.getClass().getName() + ").");
        }
    }

    public abstract List getAlgorithmParameters();
}

