/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyExchange;
import sun.security.ssl.ServerHandshakeContext;

final class ClientKeyExchange {
    static final SSLConsumer handshakeConsumer = new ClientKeyExchangeConsumer();
    static final HandshakeProducer handshakeProducer = new ClientKeyExchangeProducer();

    ClientKeyExchange() {
    }

    private static final class ClientKeyExchangeConsumer
    implements SSLConsumer {
        private ClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            serverHandshakeContext.handshakeConsumers.remove(SSLHandshake.CLIENT_KEY_EXCHANGE.id);
            if (serverHandshakeContext.handshakeConsumers.containsKey(SSLHandshake.CERTIFICATE.id)) {
                serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected ClientKeyExchange handshake message.");
                return;
            }
            SSLKeyExchange sSLKeyExchange = SSLKeyExchange.valueOf(serverHandshakeContext.negotiatedCipherSuite.keyExchange, serverHandshakeContext.negotiatedProtocol);
            if (sSLKeyExchange != null) {
                for (Map.Entry<Byte, SSLConsumer> entry : sSLKeyExchange.getHandshakeConsumers(serverHandshakeContext)) {
                    if (entry.getKey() != SSLHandshake.CLIENT_KEY_EXCHANGE.id) continue;
                    entry.getValue().consume(connectionContext, byteBuffer);
                    return;
                }
            }
            serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected ClientKeyExchange handshake message.");
        }
    }

    private static final class ClientKeyExchangeProducer
    implements HandshakeProducer {
        private ClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            SSLKeyExchange sSLKeyExchange = SSLKeyExchange.valueOf(clientHandshakeContext.negotiatedCipherSuite.keyExchange, clientHandshakeContext.negotiatedProtocol);
            if (sSLKeyExchange != null) {
                for (Map.Entry<Byte, HandshakeProducer> entry : sSLKeyExchange.getHandshakeProducers(clientHandshakeContext)) {
                    if (entry.getKey() != SSLHandshake.CLIENT_KEY_EXCHANGE.id) continue;
                    return entry.getValue().produce(connectionContext, handshakeMessage);
                }
            }
            clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected ClientKeyExchange handshake message.");
            return null;
        }
    }
}

