/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.Locale;
import javax.crypto.SecretKey;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RSAKeyExchange;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLKeyExchange;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLTrafficKeyDerivation;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.Utilities;
import sun.security.ssl.X509Authentication;

final class RSAClientKeyExchange {
    static final SSLConsumer rsaHandshakeConsumer = new RSAClientKeyExchangeConsumer();
    static final HandshakeProducer rsaHandshakeProducer = new RSAClientKeyExchangeProducer();

    RSAClientKeyExchange() {
    }

    private static final class RSAClientKeyExchangeConsumer
    implements SSLConsumer {
        private RSAClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            Object object;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            RSAKeyExchange.EphemeralRSAPossession ephemeralRSAPossession = null;
            X509Authentication.X509Possession x509Possession = null;
            Object object2 = serverHandshakeContext.handshakePossessions.iterator();
            while (object2.hasNext()) {
                object = (SSLPossession)object2.next();
                if (object instanceof RSAKeyExchange.EphemeralRSAPossession) {
                    ephemeralRSAPossession = (RSAKeyExchange.EphemeralRSAPossession)object;
                    break;
                }
                if (!(object instanceof X509Authentication.X509Possession)) continue;
                x509Possession = (X509Authentication.X509Possession)object;
                if (ephemeralRSAPossession == null) continue;
                break;
            }
            if (ephemeralRSAPossession == null && x509Possession == null) {
                serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No RSA possessions negotiated for client key exchange");
            }
            Object object3 = object2 = ephemeralRSAPossession != null ? ephemeralRSAPossession.popPrivateKey : x509Possession.popPrivateKey;
            if (!object2.getAlgorithm().equals("RSA")) {
                serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Not RSA private key for client key exchange");
            }
            object = new RSAClientKeyExchangeMessage(serverHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming RSA ClientKeyExchange handshake message", object);
            }
            try {
                RSAKeyExchange.RSAPremasterSecret rSAPremasterSecret = RSAKeyExchange.RSAPremasterSecret.decode(serverHandshakeContext, (PrivateKey)object2, ((RSAClientKeyExchangeMessage)object).encrypted);
                serverHandshakeContext.handshakeCredentials.add(rSAPremasterSecret);
            }
            catch (GeneralSecurityException generalSecurityException) {
                serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Cannot decode RSA premaster secret", generalSecurityException);
            }
            SSLKeyExchange sSLKeyExchange = SSLKeyExchange.valueOf(serverHandshakeContext.negotiatedCipherSuite.keyExchange, serverHandshakeContext.negotiatedProtocol);
            if (sSLKeyExchange == null) {
                serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            } else {
                SSLKeyDerivation sSLKeyDerivation = sSLKeyExchange.createKeyDerivation(serverHandshakeContext);
                SecretKey secretKey = sSLKeyDerivation.deriveKey("MasterSecret", null);
                serverHandshakeContext.handshakeSession.setMasterSecret(secretKey);
                SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(serverHandshakeContext.negotiatedProtocol);
                if (sSLTrafficKeyDerivation == null) {
                    serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)serverHandshakeContext.negotiatedProtocol));
                } else {
                    serverHandshakeContext.handshakeKeyDerivation = sSLTrafficKeyDerivation.createKeyDerivation(serverHandshakeContext, secretKey);
                }
            }
        }
    }

    private static final class RSAClientKeyExchangeProducer
    implements HandshakeProducer {
        private RSAClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            RSAClientKeyExchangeMessage rSAClientKeyExchangeMessage;
            SSLCredentials sSLCredentials;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            RSAKeyExchange.EphemeralRSACredentials ephemeralRSACredentials = null;
            X509Authentication.X509Credentials x509Credentials = null;
            Object object = clientHandshakeContext.handshakeCredentials.iterator();
            while (object.hasNext()) {
                sSLCredentials = (SSLCredentials)object.next();
                if (sSLCredentials instanceof RSAKeyExchange.EphemeralRSACredentials) {
                    ephemeralRSACredentials = (RSAKeyExchange.EphemeralRSACredentials)sSLCredentials;
                    if (x509Credentials == null) continue;
                    break;
                }
                if (!(sSLCredentials instanceof X509Authentication.X509Credentials)) continue;
                x509Credentials = (X509Authentication.X509Credentials)sSLCredentials;
                if (ephemeralRSACredentials == null) continue;
                break;
            }
            if (ephemeralRSACredentials == null && x509Credentials == null) {
                clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No RSA credentials negotiated for client key exchange");
            }
            Object object2 = object = ephemeralRSACredentials != null ? ephemeralRSACredentials.popPublicKey : x509Credentials.popPublicKey;
            if (!object.getAlgorithm().equals("RSA")) {
                clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Not RSA public key for client key exchange");
            }
            try {
                sSLCredentials = RSAKeyExchange.RSAPremasterSecret.createPremasterSecret(clientHandshakeContext);
                clientHandshakeContext.handshakePossessions.add(sSLCredentials);
                rSAClientKeyExchangeMessage = new RSAClientKeyExchangeMessage(clientHandshakeContext, (RSAKeyExchange.RSAPremasterSecret)sSLCredentials, (PublicKey)object);
            }
            catch (GeneralSecurityException generalSecurityException) {
                clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Cannot generate RSA premaster secret", generalSecurityException);
                return null;
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced RSA ClientKeyExchange handshake message", rSAClientKeyExchangeMessage);
            }
            rSAClientKeyExchangeMessage.write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            SSLKeyExchange sSLKeyExchange = SSLKeyExchange.valueOf(clientHandshakeContext.negotiatedCipherSuite.keyExchange, clientHandshakeContext.negotiatedProtocol);
            if (sSLKeyExchange == null) {
                clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            } else {
                SSLKeyDerivation sSLKeyDerivation = sSLKeyExchange.createKeyDerivation(clientHandshakeContext);
                SecretKey secretKey = sSLKeyDerivation.deriveKey("MasterSecret", null);
                clientHandshakeContext.handshakeSession.setMasterSecret(secretKey);
                SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(clientHandshakeContext.negotiatedProtocol);
                if (sSLTrafficKeyDerivation == null) {
                    clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)clientHandshakeContext.negotiatedProtocol));
                } else {
                    clientHandshakeContext.handshakeKeyDerivation = sSLTrafficKeyDerivation.createKeyDerivation(clientHandshakeContext, secretKey);
                }
            }
            return null;
        }
    }

    private static final class RSAClientKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        final int protocolVersion;
        final boolean useTLS10PlusSpec;
        final byte[] encrypted;

        RSAClientKeyExchangeMessage(HandshakeContext handshakeContext, RSAKeyExchange.RSAPremasterSecret rSAPremasterSecret, PublicKey publicKey) throws GeneralSecurityException {
            super(handshakeContext);
            this.protocolVersion = handshakeContext.clientHelloVersion;
            this.encrypted = rSAPremasterSecret.getEncoded(publicKey, handshakeContext.sslContext.getSecureRandom());
            this.useTLS10PlusSpec = ProtocolVersion.useTLS10PlusSpec(this.protocolVersion);
        }

        RSAClientKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            if (byteBuffer.remaining() < 2) {
                handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid RSA ClientKeyExchange message: insufficient data");
            }
            this.protocolVersion = handshakeContext.clientHelloVersion;
            this.useTLS10PlusSpec = ProtocolVersion.useTLS10PlusSpec(this.protocolVersion);
            if (this.useTLS10PlusSpec) {
                this.encrypted = Record.getBytes16(byteBuffer);
            } else {
                this.encrypted = new byte[byteBuffer.remaining()];
                byteBuffer.get(this.encrypted);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CLIENT_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            if (this.useTLS10PlusSpec) {
                return this.encrypted.length + 2;
            }
            return this.encrypted.length;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            if (this.useTLS10PlusSpec) {
                handshakeOutStream.putBytes16(this.encrypted);
            } else {
                handshakeOutStream.write(this.encrypted);
            }
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"RSA ClientKeyExchange\": '{'\n  \"client_version\":  {0}\n  \"encncrypted\": '{'\n{1}\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{ProtocolVersion.nameOf(this.protocolVersion), Utilities.indent(hexDumpEncoder.encodeBuffer(this.encrypted), "    ")};
            return messageFormat.format(objectArray);
        }
    }
}

