/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.math.field;

import iaik.security.ecc.math.field.FieldException;
import iaik.security.ecc.math.field.Value;
import iaik.security.ecc.util.Utils;
import java.math.BigInteger;

class BinaryFieldValueImpl
implements Value {
    protected int order_ = -1;
    protected int[] polynomial_;
    private static final int UNKNOWN_ORDER = -1;

    protected int[] getTransformed() throws FieldException {
        int[] nArray = new int[5];
        int n = 0;
        int n2 = 0;
        while (n2 < this.polynomial_.length) {
            if (this.polynomial_[n2] != 0) {
                int n3 = 1;
                int n4 = this.polynomial_[n2];
                int n5 = 0;
                while (n5 < 32) {
                    if ((n4 & n3) != 0) {
                        if (n > 4) {
                            throw new FieldException("FieldException.1");
                        }
                        nArray[n++] = 32 * n2 + n5;
                    }
                    if ((n4 >>= 1) == 0) break;
                    ++n5;
                }
            }
            ++n2;
        }
        if (n != 5) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    void updateOrder() {
        this.order_ = -1;
    }

    int[] getPolynomial() {
        return this.polynomial_;
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < this.polynomial_.length) {
            string = BinaryFieldValueImpl.toString(this.polynomial_[n]) + " " + string;
            ++n;
        }
        return "Polynomial: " + string;
    }

    public byte[] toByteArray(int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        boolean bl = false;
        while (!bl) {
            int n3 = 0;
            while (n3 < 4) {
                if (4 * n2 + n3 < n) {
                    int n4 = n3 << 3;
                    byArray[n - 1 - 4 * n2 - n3] = (byte)((this.polynomial_[n2] & 255 << n4) >>> n4);
                } else {
                    bl = true;
                }
                ++n3;
            }
            ++n2;
        }
        return byArray;
    }

    public BigInteger toBigInt() {
        BigInteger bigInteger = BigInteger.valueOf(0L);
        int n = 0;
        while (n < this.polynomial_.length) {
            BigInteger bigInteger2 = BigInteger.valueOf((long)this.polynomial_[n] & 0xFFFFFFFFL);
            bigInteger = bigInteger.add(bigInteger2.shiftLeft(32 * n));
            ++n;
        }
        return bigInteger;
    }

    public boolean testBit(int n) {
        int n2 = n >>> 5;
        int n3 = n & 0x1F;
        if (n2 > this.polynomial_.length) {
            return false;
        }
        int n4 = 1 << n3;
        return (this.polynomial_[n2] & n4) != 0;
    }

    public void shiftRight(int n) {
        int n2;
        this.order_ = -1;
        if (n > 31) {
            n2 = n >>> 5;
            int[] nArray = new int[this.polynomial_.length];
            if (n2 < this.polynomial_.length) {
                System.arraycopy(this.polynomial_, n2, nArray, 0, this.polynomial_.length - n2);
            }
            this.polynomial_ = nArray;
            n &= 0x1F;
        }
        if (n > 0) {
            n2 = 32 - n;
            int n3 = -1 >>> n2;
            int n4 = 0;
            int n5 = 0;
            int n6 = this.polynomial_.length - 1;
            while (n6 >= 0) {
                n5 = this.polynomial_[n6] & n3;
                this.polynomial_[n6] = this.polynomial_[n6] >>> n;
                int n7 = n6--;
                this.polynomial_[n7] = this.polynomial_[n7] | n4;
                n4 = n5 << n2;
            }
        }
    }

    public void shiftLeft(int n) {
        int n2;
        this.order_ = -1;
        if (n > 31) {
            n2 = n >>> 5;
            n &= 0x1F;
            int[] nArray = new int[this.polynomial_.length];
            if (n2 < this.polynomial_.length) {
                System.arraycopy(this.polynomial_, 0, nArray, n2, this.polynomial_.length - n2);
            }
            this.polynomial_ = nArray;
        }
        if (n > 0) {
            n2 = 0;
            int n3 = 0;
            int n4 = 32 - n;
            int n5 = 0;
            while (n5 < this.polynomial_.length) {
                n2 = this.polynomial_[n5] >>> n4;
                this.polynomial_[n5] = this.polynomial_[n5] << n;
                int n6 = n5++;
                this.polynomial_[n6] = this.polynomial_[n6] | n3;
                n3 = n2;
            }
        }
    }

    public boolean isZero() {
        int n = 0;
        while (n < this.polynomial_.length) {
            if (this.polynomial_[n] != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isOne() {
        int n = this.polynomial_.length - 1;
        while (n > 0) {
            if (this.polynomial_[n] != 0) {
                return false;
            }
            --n;
        }
        return this.polynomial_[0] == 1;
    }

    public int hashCode() {
        int n = this.polynomial_.length;
        int n2 = 0;
        while (n2 < this.polynomial_.length) {
            n += this.polynomial_[n2];
            ++n2;
        }
        return n;
    }

    public int getOrder() {
        if (this.order_ == -1) {
            this.order_ = BinaryFieldValueImpl.calcOrder(this.polynomial_);
        }
        return this.order_;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BinaryFieldValueImpl)) {
            return false;
        }
        BinaryFieldValueImpl binaryFieldValueImpl = (BinaryFieldValueImpl)object;
        if (binaryFieldValueImpl.polynomial_.length != this.polynomial_.length) {
            return false;
        }
        return Utils.equalsBlock(this.polynomial_, binaryFieldValueImpl.polynomial_);
    }

    public Object clone() {
        try {
            BinaryFieldValueImpl binaryFieldValueImpl = (BinaryFieldValueImpl)super.clone();
            int[] nArray = new int[this.polynomial_.length];
            System.arraycopy(this.polynomial_, 0, nArray, 0, nArray.length);
            binaryFieldValueImpl.polynomial_ = nArray;
            return binaryFieldValueImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    BinaryFieldValueImpl(int[] nArray, int n) {
        this.polynomial_ = new int[n];
        int n2 = nArray.length;
        if (n2 > n) {
            n2 = n;
        }
        System.arraycopy(nArray, 0, this.polynomial_, 0, n2);
    }

    public BinaryFieldValueImpl(int[] nArray) {
        this(nArray, nArray.length);
    }

    static String toString(int n) {
        String string = Integer.toBinaryString(n);
        while (string.length() < 32) {
            string = "0" + string;
        }
        return Integer.toHexString(n);
    }

    protected static int calcOrder(int[] nArray) {
        int n = 0;
        boolean bl = false;
        int n2 = nArray.length;
        block0: while (n2 > 0 && !bl) {
            if (nArray[--n2] == 0) continue;
            int n3 = Integer.MIN_VALUE;
            int n4 = 0;
            while (n4 < 32) {
                if ((nArray[n2] & n3) != 0) {
                    n = 32 * n2 + (31 - n4);
                    bl = true;
                    continue block0;
                }
                n3 >>>= 1;
                ++n4;
            }
        }
        return n;
    }
}

