/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.parameter;

import iaik.security.ecc.ECCException;
import iaik.security.ecc.parameter.ECCParameters;
import iaik.security.ecc.spec.ECCParameterSpec;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;

public class ECCParameterFactory {
    private Hashtable oidToCurve_;
    private Hashtable nameToCurve_ = new Hashtable();
    private static ECCParameterFactory uniqueInstance_;

    private void init() {
        String[] stringArray;
        int n = 0;
        while (n < ECCParameters.PRIME_NAMES.length) {
            ECCParameterSpec eCCParameterSpec = new ECCParameterSpec(ECCParameters.PRIME_P[n], ECCParameters.PRIME_K[n], ECCParameters.PRIME_R[n], ECCParameters.PRIME_S[n], ECCParameters.PRIME_C[n], ECCParameters.PRIME_A[n], ECCParameters.PRIME_B[n], ECCParameters.PRIME_GX[n], ECCParameters.PRIME_GY[n], ECCParameters.PRIME_OIDS[n]);
            stringArray = ECCParameters.PRIME_NAMES[n];
            int n2 = 0;
            while (n2 < stringArray.length) {
                try {
                    if (stringArray[n2] != null) {
                        this.addToRepository(stringArray[n2].toLowerCase(), ECCParameters.PRIME_OIDS[n], eCCParameterSpec);
                    }
                }
                catch (ECCException eCCException) {
                    eCCException.printStackTrace();
                }
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < ECCParameters.BINARY_NAMES.length) {
            stringArray = new ECCParameterSpec(ECCParameters.BINARY_I[n3], ECCParameters.BINARY_K[n3], ECCParameters.BINARY_R[n3], ECCParameters.BINARY_A[n3], ECCParameters.BINARY_B[n3], ECCParameters.BINARY_GX[n3], ECCParameters.BINARY_GY[n3], ECCParameters.BINARY_OIDS[n3]);
            String[] stringArray2 = ECCParameters.BINARY_NAMES[n3];
            int n4 = 0;
            while (n4 < stringArray2.length) {
                try {
                    if (stringArray2[n4] != null) {
                        this.addToRepository(stringArray2[n4].toLowerCase(), ECCParameters.BINARY_OIDS[n3], (ECCParameterSpec)stringArray);
                    }
                }
                catch (ECCException eCCException) {
                    eCCException.printStackTrace();
                }
                ++n4;
            }
            ++n3;
        }
    }

    private void addToRepository(String string, String string2, ECCParameterSpec eCCParameterSpec) throws ECCException {
        if (string2 == null && string == null) {
            throw new ECCException("ECCParameterFactory.1");
        }
        if (string != null) {
            this.nameToCurve_.put(string, eCCParameterSpec);
        }
        if (string2 != null) {
            this.oidToCurve_.put(string2, eCCParameterSpec);
        }
    }

    public ECCParameterSpec removeECCParameterbyOID(String string) {
        return (ECCParameterSpec)this.oidToCurve_.remove(string);
    }

    public ECCParameterSpec removeECCParameterbyName(String string) {
        return (ECCParameterSpec)this.nameToCurve_.remove(string.toLowerCase());
    }

    public ECCParameterSpec getParameterByOID(String string) {
        return (ECCParameterSpec)this.oidToCurve_.get(string);
    }

    public ECCParameterSpec getParameterByName(String string) {
        if (string == null) {
            throw new NullPointerException("Parameter name must not be null");
        }
        return (ECCParameterSpec)this.nameToCurve_.get(string.toLowerCase());
    }

    public Enumeration getNames() {
        return this.nameToCurve_.keys();
    }

    public void clearAll() {
        this.oidToCurve_.clear();
        this.nameToCurve_.clear();
    }

    public void addECCParameter(String string, String string2, int[] nArray, BigInteger bigInteger, BigInteger bigInteger2, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5) throws ECCException {
        ECCParameterSpec eCCParameterSpec = new ECCParameterSpec(nArray, bigInteger, bigInteger2, nArray2, nArray3, nArray4, nArray5, string2);
        this.addToRepository(string.toLowerCase(), string2, eCCParameterSpec);
    }

    public void addECCParameter(String string, String string2, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8, BigInteger bigInteger9) throws ECCException {
        ECCParameterSpec eCCParameterSpec = new ECCParameterSpec(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8, bigInteger9, string2);
        this.addToRepository(string.toLowerCase(), string2, eCCParameterSpec);
    }

    private ECCParameterFactory() {
        this.oidToCurve_ = new Hashtable();
    }

    public static synchronized ECCParameterFactory getInstance() {
        if (uniqueInstance_ == null) {
            uniqueInstance_ = new ECCParameterFactory();
            uniqueInstance_.init();
        }
        return uniqueInstance_;
    }

    public static synchronized void deleteInstance() {
        uniqueInstance_ = null;
    }
}

