/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.LineNumber;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import jdk.xml.internal.SecuritySupport;

public final class LineNumberTable
extends Attribute {
    private static final int MAX_LINE_LENGTH = 72;
    private LineNumber[] line_number_table;

    public LineNumberTable(LineNumberTable c) {
        this(c.getNameIndex(), c.getLength(), c.getLineNumberTable(), c.getConstantPool());
    }

    public LineNumberTable(int name_index, int length, LineNumber[] line_number_table, ConstantPool constant_pool) {
        super((byte)4, name_index, length, constant_pool);
        this.line_number_table = line_number_table;
    }

    LineNumberTable(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (LineNumber[])null, constant_pool);
        int line_number_table_length = input.readUnsignedShort();
        this.line_number_table = new LineNumber[line_number_table_length];
        for (int i = 0; i < line_number_table_length; ++i) {
            this.line_number_table[i] = new LineNumber(input);
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitLineNumberTable(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.line_number_table.length);
        for (LineNumber lineNumber : this.line_number_table) {
            lineNumber.dump(file);
        }
    }

    public final LineNumber[] getLineNumberTable() {
        return this.line_number_table;
    }

    public final void setLineNumberTable(LineNumber[] line_number_table) {
        this.line_number_table = line_number_table;
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder();
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < this.line_number_table.length; ++i) {
            line.append(this.line_number_table[i].toString());
            if (i < this.line_number_table.length - 1) {
                line.append(", ");
            }
            if (line.length() <= 72 || i >= this.line_number_table.length - 1) continue;
            line.append(SecuritySupport.NEWLINE);
            buf.append((CharSequence)line);
            line.setLength(0);
        }
        buf.append((CharSequence)line);
        return buf.toString();
    }

    public int getSourceLine(int pos) {
        int l = 0;
        int r = this.line_number_table.length - 1;
        if (r < 0) {
            return -1;
        }
        int min_index = -1;
        int min = -1;
        do {
            int i;
            int j;
            if ((j = this.line_number_table[i = (l + r) / 2].getStartPC()) == pos) {
                return this.line_number_table[i].getLineNumber();
            }
            if (pos < j) {
                r = i - 1;
            } else {
                l = i + 1;
            }
            if (j >= pos || j <= min) continue;
            min = j;
            min_index = i;
        } while (l <= r);
        if (min_index < 0) {
            return -1;
        }
        return this.line_number_table[min_index].getLineNumber();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        LineNumberTable c = (LineNumberTable)this.clone();
        c.line_number_table = new LineNumber[this.line_number_table.length];
        for (int i = 0; i < this.line_number_table.length; ++i) {
            c.line_number_table[i] = this.line_number_table[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    public final int getTableLength() {
        return this.line_number_table == null ? 0 : this.line_number_table.length;
    }
}

