/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.BundleDefaultsScope;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.ui.AcceptLicensesWizardPage;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.wizard.IWizardPage;

public abstract class WizardWithLicenses
extends ProvisioningOperationWizard {
    private static final String BYPASS_LICENSE_PAGE = "bypassLicensePage";
    AcceptLicensesWizardPage licensePage;
    boolean bypassLicencePage = WizardWithLicenses.canBypassLicencePage();

    public boolean isBypassLicencePage() {
        return this.bypassLicencePage;
    }

    public void setBypassLicencePage(boolean bypassLicencePage) {
        this.bypassLicencePage = bypassLicencePage;
    }

    public void addPages() {
        super.addPages();
        if (!this.bypassLicencePage) {
            this.licensePage = this.createLicensesPage();
            this.addPage((IWizardPage)this.licensePage);
        }
    }

    public WizardWithLicenses(ProvisioningUI ui, ProfileChangeOperation operation, Object[] initialSelections, LoadMetadataRepositoryJob job) {
        super(ui, operation, initialSelections, job);
    }

    protected AcceptLicensesWizardPage createLicensesPage() {
        IInstallableUnit[] ius = new IInstallableUnit[]{};
        if (this.planSelections != null) {
            ius = ElementUtils.elementsToIUs(this.planSelections).toArray(new IInstallableUnit[0]);
        }
        return new AcceptLicensesWizardPage(this.ui.getLicenseManager(), ius, this.operation);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        Object proposedPage = super.getNextPage(page);
        if (!this.bypassLicencePage && proposedPage == this.licensePage && this.licensePage != null) {
            proposedPage = !this.licensePage.hasLicensesToAccept() ? null : this.licensePage;
        }
        return proposedPage;
    }

    protected void planChanged() {
        super.planChanged();
        if (!this.bypassLicencePage) {
            this.licensePage.update(ElementUtils.elementsToIUs(this.planSelections).toArray(new IInstallableUnit[0]), this.operation);
        }
    }

    public boolean performFinish() {
        if (!this.bypassLicencePage) {
            this.licensePage.performFinish();
        }
        return super.performFinish();
    }

    public static boolean canBypassLicencePage() {
        IScopeContext[] contexts = new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE, BundleDefaultsScope.INSTANCE, ConfigurationScope.INSTANCE};
        boolean bypass = Platform.getPreferencesService().getBoolean("org.eclipse.equinox.p2.ui", BYPASS_LICENSE_PAGE, false, contexts);
        return bypass;
    }
}

