/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2017.decod;

import finanze.IDTE.studi2017.anomalie.report.FormattatoreMessaggio;
import finanze.IDTE.studi2017.decod.InterpreteRecordDGN;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class GestoreMessaggioErrore {
    private static StringBuffer diagnostici = null;
    private static Hashtable errori = null;
    private static String[] arr_str = null;
    private static Vector v_str = null;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String recordDGN = "1DRSTZN65M53H501F048434YYZS01   7112500124796&0                                                     00002";
        new GestoreMessaggioErrore();
        String[] messaggio = GestoreMessaggioErrore.interpretaRecordsDGN(recordDGN, true);
        int i = 0;
        while (i < messaggio.length) {
            System.out.println(messaggio[i]);
            ++i;
        }
    }

    private static String decodificaGravitaErrore(String str) {
        int gravitaErrore = Integer.parseInt(str);
        switch (gravitaErrore) {
            case 4: {
                return "(*)";
            }
            case 8: {
                return "(**)";
            }
            case 14: {
                return "(***C)";
            }
            case 16: {
                return "(***)";
            }
        }
        return null;
    }

    private static Hashtable getErrori() {
        if (errori == null) {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("finanze.IDTE.studi2017.decod.GestoreMessaggioErrore");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                BufferedReader raf = new BufferedReader(new InputStreamReader(clazz.getResourceAsStream("/finanze/IDTE/studi2017/decod/proprietacontrolli.txt")));
                errori = new Hashtable();
                String record = raf.readLine();
                while (record != null) {
                    StringTokenizer st = new StringTokenizer(record, "*");
                    String errorCode = st.nextToken();
                    String errorMsg = st.nextToken();
                    errori.put(errorCode, errorMsg);
                    record = raf.readLine();
                }
                raf.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return errori;
    }

    public static String[] interpretaRecordsDGN(String recordDGN, boolean isControlli) {
        List campiErrati;
        Hashtable bean;
        String messaggioErroreTokenizzato;
        FormattatoreMessaggio formattatoreMessaggio;
        String messaggio;
        diagnostici = new StringBuffer();
        v_str = new Vector();
        InterpreteRecordDGN ir = new InterpreteRecordDGN(recordDGN);
        String tipoErrore = ir.getTipoErrore();
        String record = tipoErrore.substring(3, 4).trim();
        String codiceStudio = tipoErrore.substring(4, 9).trim();
        String codiceAttivita = tipoErrore.substring(9, 15).trim();
        String progressivo = tipoErrore.substring(15, 17).trim();
        String gravitaErrore = GestoreMessaggioErrore.decodificaGravitaErrore(ir.getGravitaErrore());
        String codiceErrore = ir.getCodiceErrore();
        if (isControlli) {
            v_str.addElement(gravitaErrore);
        }
        v_str.addElement("Record tipo " + record);
        boolean flag = false;
        String str = "";
        if (codiceStudio != null && codiceStudio.trim().length() > 0) {
            flag = true;
            str = "Studio " + codiceStudio;
        }
        if (codiceAttivita != null && codiceAttivita.trim().length() > 0) {
            if (flag) {
                str = String.valueOf(str) + " - ";
            }
            flag = true;
            str = String.valueOf(str) + "Attivita' " + codiceAttivita;
        }
        if (progressivo != null && progressivo.trim().length() > 0) {
            if (flag) {
                str = String.valueOf(str) + " - ";
            }
            flag = true;
            str = String.valueOf(str) + "Progressivo " + progressivo;
        }
        if (flag) {
            v_str.addElement(str);
        }
        if ((messaggio = (formattatoreMessaggio = new FormattatoreMessaggio()).formatMessage(messaggioErroreTokenizzato = (String)(bean = GestoreMessaggioErrore.getErrori()).get(codiceErrore), campiErrati = ir.getCampiErrati())) != null) {
            v_str.addElement(messaggio);
        }
        v_str.addElement("\n");
        arr_str = new String[v_str.size()];
        int i = 0;
        while (i < v_str.size()) {
            GestoreMessaggioErrore.arr_str[i] = (String)v_str.elementAt(i);
            ++i;
        }
        return arr_str;
    }

    public static boolean stringToBoolean(String str) {
        return str != null && str.equals("1");
    }

    public static boolean toBoolean(String str) {
        return GestoreMessaggioErrore.stringToBoolean(str);
    }
}

