/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.generale;

import finanze.IDTE.studi2002.risorse.RigaTabellaBeanModel;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.io.CharToByteConverter;

public class MetodiUtili {
    public static final int SINISTRA = 0;
    public static final int DESTRA = 1;
    private static NumberFormat numberFormat = NumberFormat.getInstance();

    public static String aggiungiPunti(String string) {
        String num = string.trim();
        int l = num.length();
        int i = l - 3;
        while (i > 0) {
            num = String.valueOf(num.substring(0, i)) + "." + num.substring(i);
            i -= 3;
        }
        return num;
    }

    public static String allineaDestra(String string, int l) {
        String s;
        while (s.length() < l) {
            s = " " + string;
        }
        return s;
    }

    public static String allineaSinistra(String string, int l) {
        String s;
        while (s.length() < l) {
            s = String.valueOf(string) + " ";
        }
        return s;
    }

    public static void cambiaCursore(int tipoCursore, Container oggetto) {
        oggetto.setCursor(new Cursor(tipoCursore));
    }

    public static Point centraFinestra(Dimension dim) {
        Dimension dimSchermo = Toolkit.getDefaultToolkit().getScreenSize();
        Point p = new Point(0, 0);
        p.y = (dimSchermo.height - dim.height) / 2;
        p.x = (dimSchermo.width - dim.width) / 2;
        return p;
    }

    public static String controllaCodice(String code, String description) {
        try {
            Integer.parseInt(code.length() > 1 ? code.substring(1) : "");
            return code;
        }
        catch (NumberFormatException numberFormatException) {
            return description;
        }
    }

    public static String creaCodice(String string, int incremento) {
        int num1 = Integer.parseInt(string.substring(1, 4));
        String codice = String.valueOf(string.substring(0, 1)) + (num1 += incremento) + string.substring(4);
        if (codice.length() < 6) {
            switch (codice.length()) {
                case 4: {
                    codice = String.valueOf(codice.substring(0, 1)) + "00" + codice.substring(1);
                    break;
                }
                case 5: {
                    codice = String.valueOf(codice.substring(0, 1)) + "0" + codice.substring(1);
                    break;
                }
            }
        }
        return codice;
    }

    public Vector creaMultipli(RigaTabellaBeanModel[] righeBeansModel, int numeroQM, String quadro) {
        NumberFormat nf = NumberFormat.getInstance();
        Vector<String[]> quadri = new Vector<String[]>();
        String[] codiciMultiplo = new String[righeBeansModel.length - 1];
        int[] incrementiMultiplo = new int[righeBeansModel.length - 1];
        int i = 1;
        int j = 0;
        while (i < righeBeansModel.length) {
            incrementiMultiplo[j] = Integer.parseInt(righeBeansModel[i].getCodice().substring(2, 4));
            codiciMultiplo[j] = righeBeansModel[i].getCodice();
            ++j;
            ++i;
        }
        int incremento = Integer.parseInt(righeBeansModel[i - 1].getCodice().substring(2, 4));
        if (righeBeansModel[0].getCodice().equals("B00101")) {
            --incremento;
        }
        int appo = incremento;
        quadri.addElement(codiciMultiplo);
        int q = 1;
        while (q < numeroQM) {
            incremento = appo * q;
            String[] bloccoQuadri = new String[codiciMultiplo.length];
            int n = 0;
            while (n < codiciMultiplo.length) {
                nf.setMinimumIntegerDigits(3);
                String s1 = String.valueOf(quadro) + nf.format(incrementiMultiplo[n] + incremento);
                String s2 = codiciMultiplo[n].substring(4);
                bloccoQuadri[n] = String.valueOf(s1) + s2;
                ++n;
            }
            quadri.addElement(bloccoQuadri);
            ++q;
        }
        return quadri;
    }

    public static Vector creaMultipli(int numeroQM) {
        NumberFormat nf = NumberFormat.getInstance();
        Vector<String[]> quadri = new Vector<String[]>();
        int q = 0;
        while (q < numeroQM) {
            String[] bloccoQuadri = new String[5];
            int n = 0;
            while (n < 5) {
                nf.setMinimumIntegerDigits(3);
                String s1 = "M" + nf.format(q + 1);
                nf.setMinimumIntegerDigits(2);
                String s2 = nf.format(n + 1);
                bloccoQuadri[n] = String.valueOf(s1) + s2;
                ++n;
            }
            quadri.addElement(bloccoQuadri);
            ++q;
        }
        return quadri;
    }

    public static String creaNomeFile() {
        Random r = new Random();
        long d = r.nextLong();
        String b = null;
        String m = String.valueOf(Math.abs(d));
        if (m.length() > 8) {
            b = m.substring(0, 8);
            return b;
        }
        return m;
    }

    public static final String dataAStringa(Date dt) {
        SimpleDateFormat df = new SimpleDateFormat("dd MMMM yyyy", Locale.ITALIAN);
        String ris = df.format(dt);
        return ris;
    }

    public static String dataOraComplete() {
        return MetodiUtili.dataOraComplete(new Date());
    }

    public static String dataOraComplete(Date dt) {
        SimpleDateFormat df = new SimpleDateFormat("dd MMMM yyyy HH:mm:ss", Locale.ITALY);
        return df.format(dt);
    }

    public static String formattaStringa(String string, int lunghezza, int orientamento, char c) {
        String str;
        if (string == null || string.length() > lunghezza) {
            throw new IllegalArgumentException();
        }
        int lunghezzaStr = string.length();
        int i = 0;
        while (i < lunghezza - lunghezzaStr) {
            switch (orientamento) {
                case 0: {
                    str = c + string;
                    break;
                }
                case 1: {
                    str = String.valueOf(str) + c;
                }
            }
            ++i;
        }
        return str;
    }

    public static String getElementAt(String riga, int indice, String token) {
        new String();
        StringTokenizer st = new StringTokenizer(riga, token);
        if (st.countTokens() >= indice + 1 && indice >= 0) {
            int i = 0;
            while (i < indice) {
                st.nextToken();
                ++i;
            }
            return st.nextToken();
        }
        return null;
    }

    public static boolean isCodiceStudio(String string) {
        String codice;
        if (string.length() > 2) {
            codice = string.substring(0, 2);
        }
        return codice.equalsIgnoreCase("SD") || codice.equalsIgnoreCase("SG") || codice.equalsIgnoreCase("SM") || codice.equalsIgnoreCase("SK");
    }

    public static boolean isNumericNotZero(String string) {
        String valore = string.trim();
        boolean esito = false;
        int i = 0;
        while (i < valore.length()) {
            block3: {
                try {
                    int numero = Integer.parseInt(valore.substring(i, i + 1));
                    if (esito || numero <= 0) break block3;
                    esito = true;
                }
                catch (NumberFormatException numberFormatException) {
                    esito = false;
                    break;
                }
            }
            ++i;
        }
        return esito;
    }

    public static void logEccezioni(Throwable exception) {
        System.out.println(" ");
        System.out.println("---- Si \u00e9 verificata una eccezione.");
        System.out.println("---- " + new Date());
        System.out.println("---- " + exception.getMessage());
        exception.printStackTrace(System.out);
        System.out.println("---- Fine ");
        System.out.println(" ");
        System.exit(0);
    }

    public static String modificaColonnaCodice(String codice, int indice) {
        if (codice.endsWith("M00000")) {
            return codice;
        }
        numberFormat.setMinimumIntegerDigits(3);
        String temp1 = codice.substring(0, codice.length() - 5);
        String temp2 = codice.substring(codice.length() - 2);
        return String.valueOf(temp1) + numberFormat.format(indice) + temp2;
    }

    public static String space(int length) {
        StringBuffer sb = new StringBuffer(length);
        int j = 0;
        while (j < length) {
            sb.append(' ');
            ++j;
        }
        return new String(sb);
    }

    public static byte[] stringToByteConverter(String[] array) {
        CharToByteConverter ctbc = CharToByteConverter.getDefault();
        byte[] buffer = new byte[array[0].length() * array.length * ctbc.getMaxBytesPerChar()];
        try {
            int i = 0;
            int count = 0;
            while (i < array.length) {
                byte[] temp = ctbc.convertAll(array[i].toCharArray());
                System.arraycopy(temp, 0, buffer, count, temp.length);
                ++i;
                count += array[0].length();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return buffer;
    }

    public static byte[] stringToByteConverter(Vector vector) {
        Object[] dati = new String[vector.size()];
        vector.copyInto(dati);
        return MetodiUtili.stringToByteConverter((String[])dati);
    }

    public static String togliVirgoleOPunti(String string) {
        String s;
        int sito = string.indexOf(",");
        if (sito > -1) {
            s = String.valueOf(string.substring(0, sito)) + string.substring(sito + 1, string.length());
        }
        if ((sito = s.indexOf(".")) > -1) {
            s = String.valueOf(s.substring(0, sito)) + s.substring(sito + 1, s.length());
        }
        return s;
    }

    public static int[] verificaIncremento(Vector beanMultipli) {
        String[] codici = new String[beanMultipli.size()];
        int i = 0;
        while (i < beanMultipli.size()) {
            codici[i] = ((String[])beanMultipli.elementAt(i))[1];
            ++i;
        }
        int incremento = 0;
        int decremento = 0;
        int codiceA = 0;
        int codiceB = 0;
        int i2 = 0;
        while (i2 < codici.length) {
            if (i2 + 1 < codici.length) {
                codiceA = Integer.parseInt(codici[i2].substring(2, 4));
                codiceB = Integer.parseInt(codici[i2 + 1].substring(2, 4));
                if (codiceB - codiceA == 2) {
                    ++incremento;
                }
                if (codiceB - codiceA == 0) {
                    ++decremento;
                }
            }
            ++i2;
        }
        int[] incrDecr = new int[]{incremento, decremento};
        return incrDecr;
    }
}

