/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.xades.impl.dom.properties;

import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.URI;
import iaik.xml.crypto.utils.URIException;
import iaik.xml.crypto.xades.Identifier;
import iaik.xml.crypto.xades.dom.XadesDOMStructure;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class IdentifierImpl
extends XadesDOMStructure
implements DOMURIReference,
Identifier {
    protected Identifier.Qualifier qualifier_;
    protected URI uri_;

    protected void unmarshalElement(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.unmarshalElement(dOMCryptoContext, element);
        String string = DOMUtils.getAllTextFromChildren((Element)element);
        try {
            this.uri_ = new URI(string);
        }
        catch (URIException uRIException) {
            throw new MarshalException("Identifier '" + string + "' is not RFC 2396 complaint. " + uRIException.getMessage());
        }
    }

    protected void unmarshalAttributes(NamedNodeMap namedNodeMap, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        String string;
        Attr attr = (Attr)namedNodeMap.getNamedItemNS(null, "Qualifier");
        String string2 = string = attr != null ? attr.getValue() : null;
        if (string.equals("OIDAsURN")) {
            this.qualifier_ = Identifier.Qualifier.OID_AS_URN;
        } else if (string.equals("OIDAsURI")) {
            this.qualifier_ = Identifier.Qualifier.OID_AS_URI;
        }
        super.unmarshalAttributes(namedNodeMap, dOMCryptoContext);
    }

    protected Element marshalElement(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Element element = super.marshalElement(dOMCryptoContext, node, node2);
        DOMUtils.addTextToElement((Element)element, (String)this.uri_.toString());
        return element;
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.marshalAttributes(dOMCryptoContext, element);
        Document document = DOMUtils.getOwnerDocument((Node)element);
        if (this.qualifier_ == Identifier.Qualifier.OID_AS_URN) {
            Attr attr = document.createAttributeNS("", "Qualifier");
            attr.setValue("OIDAsURN");
            element.setAttributeNodeNS(attr);
        } else if (this.qualifier_ == Identifier.Qualifier.OID_AS_URI) {
            Attr attr = document.createAttributeNS("", "Qualifier");
            attr.setValue("OIDAsURI");
            element.setAttributeNodeNS(attr);
        }
    }

    public String getURI() {
        return this.uri_.toString();
    }

    public String getType() {
        return null;
    }

    public Identifier.Qualifier getQualifier() {
        return this.qualifier_;
    }

    public String getLocalName() {
        return "Identifier";
    }

    public Node getHere() {
        return super.getHere();
    }

    public IdentifierImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.uri_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public IdentifierImpl(Identifier.Qualifier qualifier, String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'uri' must not be null.");
        }
        try {
            this.uri_ = new URI(string);
        }
        catch (URIException uRIException) {
            throw new IllegalArgumentException("Argument 'uri' is not RFC 2396 complaint. " + uRIException.getMessage());
        }
        this.qualifier_ = qualifier;
    }
}

