/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.util.JNLPUtils;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.ArrayList;

public final class PreverificationClassLoader
extends URLClassLoader {
    private ArrayList _jarsInURLClassLoader = new ArrayList();
    private ArrayList _jarsNotInURLClassLoader = new ArrayList();

    public PreverificationClassLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        permissionCollection.add(new AllPermission());
        return permissionCollection;
    }

    public void preverifyJARs() {
        if (!Cache.isCacheEnabled()) {
            return;
        }
        long l = System.currentTimeMillis();
        for (int i = 0; i < this._jarsInURLClassLoader.size(); ++i) {
            JARDesc jARDesc = (JARDesc)this._jarsInURLClassLoader.get(i);
            File file = new File(Config.getSystemCacheDirectory() + File.separator + Cache.getCacheVersionString());
            CacheEntry cacheEntry = Cache.getCacheEntry((URL)jARDesc.getLocation(), null, (String)jARDesc.getVersion(), (File)file);
            if (cacheEntry == null || cacheEntry.getClassesVerificationStatus() != 0) continue;
            cacheEntry.verifyJAR((URLClassLoader)this);
        }
        long l2 = System.currentTimeMillis();
        Trace.println((String)("PreverificationCL, Cached JAR preverification took (ms): " + (l2 - l)), (TraceLevel)TraceLevel.CACHE);
    }

    public void initialize(LaunchDesc launchDesc) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            JNLPUtils.sortResourcesForClasspath(resourcesDesc, this._jarsInURLClassLoader, this._jarsNotInURLClassLoader);
            for (int i = 0; i < this._jarsInURLClassLoader.size(); ++i) {
                JARDesc jARDesc = (JARDesc)this._jarsInURLClassLoader.get(i);
                this.addURL(jARDesc.getLocation());
            }
        }
    }

    private void addLoadedJarsEntry(JARDesc jARDesc) {
        if (!this._jarsInURLClassLoader.contains(jARDesc)) {
            this._jarsInURLClassLoader.add(jARDesc);
        }
    }
}

