/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.DebugCMS;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.SecurityProvider;
import iaik.smime.ess.ESSIssuerSerial;
import iaik.smime.ess.ESSRuntimeException;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class ESSCertID
implements ASN1Type {
    SecurityProvider c;
    ESSIssuerSerial a;
    byte[] b;
    AlgorithmID e;
    private static final AlgorithmID f;
    private static boolean d;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Hash algorithm: " + this.e);
        stringBuffer.append("\nCertHash: " + Util.toString((byte[])this.b) + "\n");
        if (this.a != null) {
            stringBuffer.append("IssuerSerial: " + this.a + "\n");
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        if (this.b == null) {
            throw new RuntimeException("Cannot encode this ESSCertID: Missing cert hash!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        try {
            this.a((ASN1Object)sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new ESSRuntimeException("Error encoding hash algorithm: " + codingException.toString());
        }
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.b));
        if (this.a != null) {
            sEQUENCE.addComponent(this.a.toASN1Object());
        }
        return sEQUENCE;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.c = securityProvider;
    }

    public void setIssuerSerial(ESSIssuerSerial eSSIssuerSerial) {
        this.a = eSSIssuerSerial;
    }

    public void setCertHash(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Cert hash is not allowed to be null!");
        }
        this.b = byArray;
    }

    int b(ASN1Object aSN1Object) throws CodingException {
        this.e = (AlgorithmID)f.clone();
        return 0;
    }

    public boolean identifiesCert(Certificate certificate) throws NoSuchAlgorithmException {
        try {
            return this.equals(new ESSCertID(certificate, this.a != null, this.c));
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    public int hashCode() {
        return Util.calculateHashCode((byte[])this.b);
    }

    int a() {
        return 1;
    }

    public SecurityProvider getSecurityProvider() {
        return this.c;
    }

    public ESSIssuerSerial getIssuerSerial() {
        return this.a;
    }

    public AlgorithmID getHashAlgorithm() {
        return this.e;
    }

    public byte[] getCertHash() {
        return this.b;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof ESSCertID) {
            ESSCertID eSSCertID = (ESSCertID)object;
            if (this.e.equals((Object)eSSCertID.e) && (this.b == null && eSSCertID.b == null || this.b != null && eSSCertID.b != null && CryptoUtils.equalsBlock((byte[])this.b, (byte[])eSSCertID.b))) {
                bl = this.a != null && eSSCertID.a != null ? this.a.equals(eSSCertID.a) : this.a == null && eSSCertID.a == null;
            }
        }
        return bl;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        int n2 = aSN1Object.countComponents();
        if (n2 < 1) {
            throw new CodingException("Invalid number (" + n2 + ") of components in ESSCertID!");
        }
        int n3 = this.b(aSN1Object);
        this.b = (byte[])aSN1Object.getComponentAt(n3++).getValue();
        if (this.b == null) {
            throw new CodingException("Invalid ESSCertID encoding: Missing cert hash!");
        }
        if (n2 == n3 + 1) {
            this.a = new ESSIssuerSerial(aSN1Object.getComponentAt(n3));
            return;
        }
        if (n2 != n3) {
            throw new CodingException("Invalid number (" + n2 + ") of components in ESSCertID!");
        }
    }

    public void calculateCertHash(byte[] byArray) throws NoSuchAlgorithmException {
        SecurityProvider securityProvider = this.c;
        if (securityProvider == null) {
            securityProvider = SecurityProvider.getSecurityProvider();
        }
        this.b = securityProvider.getHash(this.e, byArray);
    }

    ASN1Object a(ASN1Object aSN1Object) throws CodingException {
        return aSN1Object;
    }

    public ESSCertID(Certificate certificate, boolean bl, SecurityProvider securityProvider) throws CertificateException, NoSuchAlgorithmException {
        this((AlgorithmID)f.clone(), certificate, bl, securityProvider);
    }

    public ESSCertID(Certificate certificate, boolean bl) throws CertificateException, NoSuchAlgorithmException {
        this(certificate, bl, null);
    }

    ESSCertID(AlgorithmID algorithmID, Certificate certificate, boolean bl, SecurityProvider securityProvider) throws CertificateException, NoSuchAlgorithmException {
        this(algorithmID);
        this.c = securityProvider;
        if (certificate == null) {
            throw new NullPointerException("Certificate must mot be null!");
        }
        this.calculateCertHash(certificate.getEncoded());
        if (bl) {
            this.a = new ESSIssuerSerial(certificate);
        }
    }

    ESSCertID(AlgorithmID algorithmID) {
        if (algorithmID == null) {
            throw new NullPointerException("Hash algorithm must not be null!");
        }
        this.e = algorithmID;
    }

    public ESSCertID(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new NullPointerException("ASN.1 object must mot be null!");
        }
        this.decode(aSN1Object);
    }

    public ESSCertID() {
        this((AlgorithmID)f.clone());
    }

    static {
        d = DebugCMS.getDebugMode() && d;
        f = (AlgorithmID)AlgorithmID.sha1.clone();
    }
}

