/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.core.menus;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;

public class PerspectiveSwitcherMenu
extends ContributionItem {
    private final SelectionListener menuListener = new SwitchPerspectiveMenuListener();
    private static final String WELCOME = "introPerspective";

    public PerspectiveSwitcherMenu() {
    }

    public PerspectiveSwitcherMenu(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        String activePerspective = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId();
        IPerspectiveDescriptor[] perspectives = PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
        this.orderPerspectives(perspectives);
        int i = 0;
        while (i < perspectives.length) {
            IPerspectiveDescriptor descriptor = perspectives[i];
            MenuItem item = new MenuItem(menu, 16, i);
            item.setData(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getDescription(), (Object)descriptor);
            item.setText(descriptor.getLabel());
            final Image image = descriptor.getImageDescriptor().createImage();
            item.setImage(image);
            item.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    image.dispose();
                }
            });
            item.addSelectionListener(this.menuListener);
            if (descriptor.getId().equals(activePerspective)) {
                item.setSelection(true);
            }
            ++i;
        }
    }

    private void orderPerspectives(IPerspectiveDescriptor[] perspectives) {
        int welcomePosition = 0;
        IPerspectiveDescriptor welcomeDescriptor = null;
        int i = 0;
        while (i < perspectives.length) {
            IPerspectiveDescriptor descriptor = perspectives[i];
            if (descriptor.getId().contains(WELCOME)) {
                welcomePosition = i;
                welcomeDescriptor = perspectives[i];
                break;
            }
            ++i;
        }
        if (welcomePosition != 0) {
            i = welcomePosition - 1;
            while (i >= 0) {
                perspectives[i + 1] = perspectives[i];
                --i;
            }
            perspectives[0] = welcomeDescriptor;
        }
    }

    public final boolean isDynamic() {
        return true;
    }

    private static final class SwitchPerspectiveMenuListener
    extends SelectionAdapter {
        private SwitchPerspectiveMenuListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IWorkbenchPage page;
            MenuItem item = (MenuItem)e.widget;
            if (item.getSelection() && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
                IPerspectiveDescriptor descriptor = (IPerspectiveDescriptor)item.getData(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getDescription());
                page.setPerspective(descriptor);
                IIntroManager manager = PlatformUI.getWorkbench().getIntroManager();
                IIntroPart introPart = PlatformUI.getWorkbench().getIntroManager().getIntro();
                manager.closeIntro(introPart);
            }
        }
    }
}

