/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.peer.CheckboxPeer;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XToolkit;
import sun.util.logging.PlatformLogger;

class XCheckboxPeer
extends XComponentPeer
implements CheckboxPeer {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XCheckboxPeer");
    private static final Insets focusInsets = new Insets(0, 0, 0, 0);
    private static final Insets borderInsets = new Insets(2, 2, 2, 2);
    private static final int checkBoxInsetFromText = 2;
    private static final double MASTER_SIZE = 128.0;
    private static final Polygon MASTER_CHECKMARK = new Polygon(new int[]{1, 25, 56, 124, 124, 85, 64}, new int[]{59, 35, 67, 0, 12, 66, 123}, 7);
    private Shape myCheckMark;
    private Color focusColor = SystemColor.windowText;
    private boolean pressed = false;
    private boolean armed = false;
    private boolean selected;
    private Rectangle textRect;
    private Rectangle focusRect;
    private int checkBoxSize;
    private int cbX;
    private int cbY;
    String label;
    CheckboxGroup checkBoxGroup;

    XCheckboxPeer(Checkbox checkbox) {
        super(checkbox);
        this.selected = checkbox.getState();
        this.label = checkbox.getLabel();
        if (this.label == null) {
            this.label = "";
        }
        this.checkBoxGroup = checkbox.getCheckboxGroup();
        this.updateMotifColors(this.getPeerBackground());
    }

    @Override
    public void preInit(XCreateWindowParams xCreateWindowParams) {
        this.textRect = new Rectangle();
        this.focusRect = new Rectangle();
        super.preInit(xCreateWindowParams);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.repaint();
    }

    @Override
    void handleJavaKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getID();
        switch (n) {
            case 401: {
                this.keyPressed(keyEvent);
                break;
            }
            case 402: {
                this.keyReleased(keyEvent);
                break;
            }
            case 400: {
                this.keyTyped(keyEvent);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32) {
            this.action(!this.selected);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void setLabel(String string) {
        this.label = string == null ? "" : string;
        this.layout();
        this.repaint();
    }

    @Override
    void handleJavaMouseEvent(MouseEvent mouseEvent) {
        super.handleJavaMouseEvent(mouseEvent);
        int n = mouseEvent.getID();
        switch (n) {
            case 501: {
                this.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
                break;
            }
            case 504: {
                this.mouseEntered(mouseEvent);
                break;
            }
            case 505: {
                this.mouseExited(mouseEvent);
                break;
            }
            case 500: {
                this.mouseClicked(mouseEvent);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Checkbox checkbox;
        if (XToolkit.isLeftMouseButton(mouseEvent) && (checkbox = (Checkbox)mouseEvent.getSource()).contains(mouseEvent.getX(), mouseEvent.getY())) {
            if (log.isLoggable(400)) {
                log.finer("mousePressed() on " + this.target.getName() + " : armed = " + this.armed + ", pressed = " + this.pressed + ", selected = " + this.selected + ", enabled = " + this.isEnabled());
            }
            if (!this.isEnabled()) {
                return;
            }
            if (!this.armed) {
                this.armed = true;
            }
            this.pressed = true;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (log.isLoggable(400)) {
            log.finer("mouseReleased() on " + this.target.getName() + ": armed = " + this.armed + ", pressed = " + this.pressed + ", selected = " + this.selected + ", enabled = " + this.isEnabled());
        }
        boolean bl = false;
        if (XToolkit.isLeftMouseButton(mouseEvent)) {
            if (this.armed) {
                bl = true;
            }
            this.pressed = false;
            this.armed = false;
            if (bl) {
                this.action(!this.selected);
            } else {
                this.repaint();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (log.isLoggable(400)) {
            log.finer("mouseEntered() on " + this.target.getName() + ": armed = " + this.armed + ", pressed = " + this.pressed + ", selected = " + this.selected + ", enabled = " + this.isEnabled());
        }
        if (this.pressed) {
            this.armed = true;
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (log.isLoggable(400)) {
            log.finer("mouseExited() on " + this.target.getName() + ": armed = " + this.armed + ", pressed = " + this.pressed + ", selected = " + this.selected + ", enabled = " + this.isEnabled());
        }
        if (this.armed) {
            this.armed = false;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public Dimension getMinimumSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getPeerFont());
        int n = fontMetrics.stringWidth(this.label) + this.getCheckboxSize(fontMetrics) + 4 + 8;
        int n2 = Math.max(fontMetrics.getHeight() + 8, 15);
        return new Dimension(n, n2);
    }

    private int getCheckboxSize(FontMetrics fontMetrics) {
        return fontMetrics.getHeight() * 76 / 100 - 1;
    }

    @Override
    public void setBackground(Color color) {
        this.updateMotifColors(color);
        super.setBackground(color);
    }

    @Override
    public void layout() {
        Dimension dimension = this.getPeerSize();
        Font font = this.getPeerFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        String string = this.label;
        this.checkBoxSize = this.getCheckboxSize(fontMetrics);
        this.cbX = XCheckboxPeer.borderInsets.left + 2;
        this.cbY = dimension.height / 2 - this.checkBoxSize / 2;
        int n = XCheckboxPeer.borderInsets.left + 4 + this.checkBoxSize;
        this.textRect.width = fontMetrics.stringWidth(string == null ? "" : string);
        this.textRect.height = fontMetrics.getHeight();
        this.textRect.x = Math.max(n, dimension.width / 2 - this.textRect.width / 2);
        this.textRect.y = (dimension.height - this.textRect.height) / 2;
        this.focusRect.x = XCheckboxPeer.focusInsets.left;
        this.focusRect.y = XCheckboxPeer.focusInsets.top;
        this.focusRect.width = dimension.width - (XCheckboxPeer.focusInsets.left + XCheckboxPeer.focusInsets.right) - 1;
        this.focusRect.height = dimension.height - (XCheckboxPeer.focusInsets.top + XCheckboxPeer.focusInsets.bottom) - 1;
        double d = this.checkBoxSize;
        this.myCheckMark = AffineTransform.getScaleInstance(d / 128.0, d / 128.0).createTransformedShape(MASTER_CHECKMARK);
    }

    @Override
    public void paint(Graphics graphics) {
        if (graphics != null) {
            Dimension dimension = this.getPeerSize();
            Font font = this.getPeerFont();
            this.flush();
            graphics.setColor(this.getPeerBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            if (this.label != null) {
                graphics.setFont(font);
                this.paintText(graphics, this.textRect, this.label);
            }
            if (this.hasFocus()) {
                this.paintFocus(graphics, this.focusRect.x, this.focusRect.y, this.focusRect.width, this.focusRect.height);
            }
            if (this.checkBoxGroup == null) {
                this.paintCheckbox(graphics, this.cbX, this.cbY, this.checkBoxSize, this.checkBoxSize);
            } else {
                this.paintRadioButton(graphics, this.cbX, this.cbY, this.checkBoxSize, this.checkBoxSize);
            }
        }
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintCheckbox(Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl = false;
        BufferedImage bufferedImage = null;
        Graphics2D graphics2D = null;
        int n5 = n;
        int n6 = n2;
        if (!(graphics instanceof Graphics2D)) {
            bufferedImage = this.graphicsConfig.createCompatibleImage(n3, n4);
            graphics2D = bufferedImage.createGraphics();
            bl = true;
            n5 = 0;
            n6 = 0;
        } else {
            graphics2D = (Graphics2D)graphics;
        }
        try {
            this.drawMotif3DRect(graphics2D, n5, n6, n3 - 1, n4 - 1, this.armed | this.selected);
            graphics2D.setColor(this.armed | this.selected ? this.selectColor : this.getPeerBackground());
            graphics2D.fillRect(n5 + 1, n6 + 1, n3 - 2, n4 - 2);
            if (this.armed | this.selected) {
                graphics2D.setColor(this.getPeerForeground());
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.setTransform(AffineTransform.getTranslateInstance(n5, n6));
                graphics2D.fill(this.myCheckMark);
                graphics2D.setTransform(affineTransform);
            }
        }
        finally {
            if (bl) {
                graphics2D.dispose();
            }
        }
        if (bl) {
            graphics.drawImage(bufferedImage, n, n2, null);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.target.repaint();
    }

    public void paintRadioButton(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(this.armed | this.selected ? this.darkShadow : this.lightShadow);
        graphics.drawArc(n - 1, n2 - 1, n3 + 2, n4 + 2, 45, 180);
        graphics.setColor(this.armed | this.selected ? this.lightShadow : this.darkShadow);
        graphics.drawArc(n - 1, n2 - 1, n3 + 2, n4 + 2, 45, -180);
        if (this.armed | this.selected) {
            graphics.setColor(this.selectColor);
            graphics.fillArc(n + 1, n2 + 1, n3 - 1, n4 - 1, 0, 360);
        }
    }

    protected void paintText(Graphics graphics, Rectangle rectangle, String string) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = -1;
        if (this.isEnabled()) {
            graphics.setColor(this.getPeerForeground());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
        } else {
            graphics.setColor(this.getPeerBackground().brighter());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(this.getPeerBackground().darker());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        }
    }

    protected void paintFocus(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(this.focusColor);
        graphics.drawRect(n, n2, n3, n4);
    }

    @Override
    public void setState(boolean bl) {
        if (this.selected != bl) {
            this.selected = bl;
            this.repaint();
        }
    }

    @Override
    public void setCheckboxGroup(CheckboxGroup checkboxGroup) {
        this.checkBoxGroup = checkboxGroup;
        this.repaint();
    }

    void action(boolean bl) {
        final Checkbox checkbox = (Checkbox)this.target;
        final boolean bl2 = bl;
        XToolkit.executeOnEventHandlerThread(checkbox, new Runnable(){

            @Override
            public void run() {
                CheckboxGroup checkboxGroup = XCheckboxPeer.this.checkBoxGroup;
                if (checkboxGroup != null && checkboxGroup.getSelectedCheckbox() == checkbox && checkbox.getState()) {
                    checkbox.setState(true);
                    return;
                }
                checkbox.setState(bl2);
                XCheckboxPeer.this.notifyStateChanged(bl2);
            }
        });
    }

    void notifyStateChanged(boolean bl) {
        Checkbox checkbox = (Checkbox)this.target;
        ItemEvent itemEvent = new ItemEvent(checkbox, 701, checkbox.getLabel(), bl ? 1 : 2);
        this.postEvent(itemEvent);
    }
}

