/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.IntegerComponentRaster;

public class IntegerInterleavedRaster
extends IntegerComponentRaster {
    private int maxX;
    private int maxY;

    public IntegerInterleavedRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public IntegerInterleavedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public IntegerInterleavedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, IntegerInterleavedRaster integerInterleavedRaster) {
        super(sampleModel, dataBuffer, rectangle, point, integerInterleavedRaster);
        this.maxX = this.minX + this.width;
        this.maxY = this.minY + this.height;
        if (!(dataBuffer instanceof DataBufferInt)) {
            throw new RasterFormatException("IntegerInterleavedRasters must haveinteger DataBuffers");
        }
        DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
        this.data = IntegerInterleavedRaster.stealData(dataBufferInt, 0);
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            throw new RasterFormatException("IntegerInterleavedRasters must have SinglePixelPackedSampleModel");
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        this.scanlineStride = singlePixelPackedSampleModel.getScanlineStride();
        this.pixelStride = 1;
        this.dataOffsets = new int[1];
        this.dataOffsets[0] = dataBufferInt.getOffset();
        this.bandOffset = this.dataOffsets[0];
        int n = rectangle.x - point.x;
        int n2 = rectangle.y - point.y;
        this.dataOffsets[0] = this.dataOffsets[0] + (n + n2 * this.scanlineStride);
        this.numDataElems = singlePixelPackedSampleModel.getNumDataElements();
        this.verify(false);
    }

    @Override
    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    @Override
    public int getDataOffset(int n) {
        return this.dataOffsets[n];
    }

    @Override
    public int getScanlineStride() {
        return this.scanlineStride;
    }

    @Override
    public int getPixelStride() {
        return this.pixelStride;
    }

    @Override
    public int[] getDataStorage() {
        return this.data;
    }

    @Override
    public Object getDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray = object == null ? new int[1] : (int[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) + this.dataOffsets[0];
        nArray[0] = this.data[n3];
        return nArray;
    }

    @Override
    public Object getDataElements(int n, int n2, int n3, int n4, Object object) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray = object instanceof int[] ? (int[])object : new int[n3 * n4];
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) + this.dataOffsets[0];
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            System.arraycopy(this.data, n5, nArray, n6, n3);
            n6 += n3;
            n5 += this.scanlineStride;
        }
        return nArray;
    }

    @Override
    public void setDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray = (int[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) + this.dataOffsets[0];
        this.data[n3] = nArray[0];
        this.markDirty();
    }

    @Override
    public void setDataElements(int n, int n2, Raster raster) {
        int n3 = n + raster.getMinX();
        int n4 = n2 + raster.getMinY();
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        if (n3 < this.minX || n4 < this.minY || n3 + n5 > this.maxX || n4 + n6 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(n3, n4, n5, n6, raster);
    }

    private void setDataElements(int n, int n2, int n3, int n4, Raster raster) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        int n5 = raster.getMinX();
        int n6 = raster.getMinY();
        int[] nArray = null;
        if (raster instanceof IntegerInterleavedRaster) {
            int n7;
            IntegerInterleavedRaster integerInterleavedRaster = (IntegerInterleavedRaster)raster;
            nArray = integerInterleavedRaster.getDataStorage();
            int n8 = integerInterleavedRaster.getScanlineStride();
            int n9 = n7 = integerInterleavedRaster.getDataOffset(0);
            int n10 = this.dataOffsets[0] + (n2 - this.minY) * this.scanlineStride + (n - this.minX);
            for (int i = 0; i < n4; ++i) {
                System.arraycopy(nArray, n9, this.data, n10, n3);
                n9 += n8;
                n10 += this.scanlineStride;
            }
            this.markDirty();
            return;
        }
        Object object = null;
        for (int i = 0; i < n4; ++i) {
            object = raster.getDataElements(n5, n6 + i, n3, 1, object);
            this.setDataElements(n, n2 + i, n3, 1, object);
        }
    }

    @Override
    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray = (int[])object;
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) + this.dataOffsets[0];
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            System.arraycopy(nArray, n6, this.data, n5, n3);
            n6 += n3;
            n5 += this.scanlineStride;
        }
        this.markDirty();
    }

    @Override
    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX) {
            throw new RasterFormatException("x lies outside raster");
        }
        if (n2 < this.minY) {
            throw new RasterFormatException("y lies outside raster");
        }
        if (n + n3 < n || n + n3 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n7 = n5 - n;
        int n8 = n6 - n2;
        return new IntegerInterleavedRaster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n7, this.sampleModelTranslateY + n8), this);
    }

    @Override
    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        return this.createWritableChild(n, n2, n3, n4, n5, n6, nArray);
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RasterFormatException("negative " + (n <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n, n2);
        return new IntegerInterleavedRaster(sampleModel, new Point(0, 0));
    }

    @Override
    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    private void verify(boolean bl) {
        int n = (this.height - 1) * this.scanlineStride + (this.width - 1) + this.dataOffsets[0];
        int n2 = 0;
        if (n > n2) {
            n2 = n;
        }
        if (this.data.length < n2) {
            throw new RasterFormatException("Data array too small (should be " + n2 + " but is " + this.data.length + " )");
        }
    }

    @Override
    public String toString() {
        return new String("IntegerInterleavedRaster: width = " + this.width + " height = " + this.height + " #Bands = " + this.numBands + " xOff = " + this.sampleModelTranslateX + " yOff = " + this.sampleModelTranslateY + " dataOffset[0] " + this.dataOffsets[0]);
    }
}

