/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import sun.java2d.opengl.OGLContext;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.RenderQueue;

public class OGLRenderQueue
extends RenderQueue {
    private static OGLRenderQueue theInstance;
    private final QueueFlusher flusher = new QueueFlusher();

    private OGLRenderQueue() {
    }

    public static synchronized OGLRenderQueue getInstance() {
        if (theInstance == null) {
            theInstance = new OGLRenderQueue();
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sync() {
        if (theInstance != null) {
            theInstance.lock();
            try {
                theInstance.ensureCapacity(4);
                theInstance.getBuffer().putInt(76);
                theInstance.flushNow();
            }
            finally {
                theInstance.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeGraphicsConfig(long l) {
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            OGLContext.setScratchSurface(l);
            RenderBuffer renderBuffer = oGLRenderQueue.getBuffer();
            oGLRenderQueue.ensureCapacityAndAlignment(12, 4);
            renderBuffer.putInt(74);
            renderBuffer.putLong(l);
            oGLRenderQueue.flushNow();
        }
        finally {
            oGLRenderQueue.unlock();
        }
    }

    public static boolean isQueueFlusherThread() {
        return Thread.currentThread() == OGLRenderQueue.getInstance().flusher;
    }

    @Override
    public void flushNow() {
        try {
            this.flusher.flushNow();
        }
        catch (Exception exception) {
            System.err.println("exception in flushNow:");
            exception.printStackTrace();
        }
    }

    @Override
    public void flushAndInvokeNow(Runnable runnable) {
        try {
            this.flusher.flushAndInvokeNow(runnable);
        }
        catch (Exception exception) {
            System.err.println("exception in flushAndInvokeNow:");
            exception.printStackTrace();
        }
    }

    private native void flushBuffer(long var1, int var3);

    private void flushBuffer() {
        int n = this.buf.position();
        if (n > 0) {
            this.flushBuffer(this.buf.getAddress(), n);
        }
        this.buf.clear();
        this.refSet.clear();
    }

    private class QueueFlusher
    extends Thread {
        private boolean needsFlush;
        private Runnable task;
        private Error error;

        public QueueFlusher() {
            super("Java2D Queue Flusher");
            this.setDaemon(true);
            this.setPriority(10);
            this.start();
        }

        public synchronized void flushNow() {
            this.needsFlush = true;
            this.notify();
            while (this.needsFlush) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.error != null) {
                throw this.error;
            }
        }

        public synchronized void flushAndInvokeNow(Runnable runnable) {
            this.task = runnable;
            this.flushNow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            boolean bl = false;
            while (true) {
                if (!this.needsFlush) {
                    try {
                        bl = false;
                        this.wait(100L);
                        if (this.needsFlush || !(bl = OGLRenderQueue.this.tryLock())) continue;
                        if (OGLRenderQueue.this.buf.position() > 0) {
                            this.needsFlush = true;
                            continue;
                        }
                        OGLRenderQueue.this.unlock();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    this.error = null;
                    OGLRenderQueue.this.flushBuffer();
                    if (this.task == null) continue;
                    this.task.run();
                    continue;
                }
                catch (Error error) {
                    this.error = error;
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("exception in QueueFlusher:");
                    exception.printStackTrace();
                    continue;
                }
                finally {
                    if (bl) {
                        OGLRenderQueue.this.unlock();
                    }
                    this.task = null;
                    this.needsFlush = false;
                    this.notify();
                    continue;
                }
                break;
            }
        }
    }
}

