/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dsa;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.security.dsa.DSAParams;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class DSAParameters
extends AlgorithmParametersSpi {
    DSAParams a;

    protected String engineToString() {
        return this.a.toString();
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1Object aSN1Object = DerCoder.decode(byArray);
            this.a = new DSAParams(aSN1Object);
            return;
        }
        catch (CodingException codingException) {
            throw new IOException("DER decoding error. " + codingException.toString());
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof DSAParameterSpec) {
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
            this.a = new DSAParams(dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG());
            return;
        }
        throw new InvalidParameterSpecException("Parameter must be DSAParameterSpec.");
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        DSAParameterSpec dSAParameterSpec = new DSAParameterSpec(this.a.getP(), this.a.getQ(), this.a.getG());
        if (!dSAParameterSpec.getClass().isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return dSAParameterSpec;
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected byte[] engineGetEncoded() throws IOException {
        return DerCoder.encode(this.a.toASN1Object());
    }
}

