/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.quickdiff;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public final class CompositeRevertAction
extends Action
implements IUpdate,
ISelectionChangedListener {
    private final IAction[] fActions;

    public CompositeRevertAction(ITextEditor editor, IAction[] actions) {
        this.fActions = new IAction[actions.length];
        int i = 0;
        while (i < actions.length) {
            Assert.isNotNull((Object)actions[i]);
            ++i;
        }
        System.arraycopy(actions, 0, this.fActions, 0, actions.length);
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.update();
    }

    public void update() {
        int i = 0;
        while (i < this.fActions.length) {
            if (this.fActions[i] instanceof IUpdate) {
                ((IUpdate)this.fActions[i]).update();
            }
            ++i;
        }
        IAction action = this.getEnabledAction();
        this.setEnabled(this.getEnabledAction() != null);
        if (action == null) {
            return;
        }
        this.setText(action.getText());
        this.setToolTipText(action.getToolTipText());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.update();
    }

    public void run() {
        IAction action = this.getEnabledAction();
        if (action != null) {
            action.run();
        }
    }

    private IAction getEnabledAction() {
        int i = 0;
        while (i < this.fActions.length) {
            if (this.fActions[i].isEnabled()) {
                return this.fActions[i];
            }
            ++i;
        }
        return null;
    }
}

