/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.net.Socket;
import java.security.AlgorithmConstraints;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLAlgorithmConstraints;
import sun.security.ssl.X509TrustManagerImpl;

final class AbstractTrustManagerWrapper
extends X509ExtendedTrustManager
implements X509TrustManager {
    private final X509TrustManager tm;

    AbstractTrustManagerWrapper(X509TrustManager x509TrustManager) {
        this.tm = x509TrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.tm.checkClientTrusted(x509CertificateArray, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.tm.checkServerTrusted(x509CertificateArray, string);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.tm.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.tm.checkClientTrusted(x509CertificateArray, string);
        this.checkAdditionalTrust(x509CertificateArray, string, socket, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.tm.checkServerTrusted(x509CertificateArray, string);
        this.checkAdditionalTrust(x509CertificateArray, string, socket, false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.tm.checkClientTrusted(x509CertificateArray, string);
        this.checkAdditionalTrust(x509CertificateArray, string, sSLEngine, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.tm.checkServerTrusted(x509CertificateArray, string);
        this.checkAdditionalTrust(x509CertificateArray, string, sSLEngine, false);
    }

    private void checkAdditionalTrust(X509Certificate[] x509CertificateArray, String string, Socket socket, boolean bl) throws CertificateException {
        if (socket != null && socket.isConnected() && socket instanceof SSLSocket) {
            Object object;
            Object object2;
            SSLSocket sSLSocket = (SSLSocket)socket;
            SSLSession sSLSession = sSLSocket.getHandshakeSession();
            if (sSLSession == null) {
                throw new CertificateException("No handshake session");
            }
            String string2 = sSLSocket.getSSLParameters().getEndpointIdentificationAlgorithm();
            if (string2 != null && string2.length() != 0) {
                object2 = sSLSession.getPeerHost();
                X509TrustManagerImpl.checkIdentity((String)object2, x509CertificateArray[0], string2);
            }
            object2 = ProtocolVersion.valueOf(sSLSession.getProtocol());
            SSLAlgorithmConstraints sSLAlgorithmConstraints = null;
            if (((ProtocolVersion)object2).v >= ProtocolVersion.TLS12.v) {
                if (sSLSession instanceof ExtendedSSLSession) {
                    object = (ExtendedSSLSession)sSLSession;
                    String[] stringArray = ((ExtendedSSLSession)object).getLocalSupportedSignatureAlgorithms();
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLSocket, stringArray, true);
                } else {
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLSocket, true);
                }
            } else {
                sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLSocket, true);
            }
            object = new AlgorithmChecker((AlgorithmConstraints)sSLAlgorithmConstraints);
            try {
                ((AlgorithmChecker)object).init(false);
                for (int i = x509CertificateArray.length - 1; i >= 0; --i) {
                    X509Certificate x509Certificate = x509CertificateArray[i];
                    ((AlgorithmChecker)object).check(x509Certificate, Collections.emptySet());
                }
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertificateException("Certificates does not conform to algorithm constraints");
            }
        }
    }

    private void checkAdditionalTrust(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine, boolean bl) throws CertificateException {
        if (sSLEngine != null) {
            Object object;
            Object object2;
            SSLSession sSLSession = sSLEngine.getHandshakeSession();
            if (sSLSession == null) {
                throw new CertificateException("No handshake session");
            }
            String string2 = sSLEngine.getSSLParameters().getEndpointIdentificationAlgorithm();
            if (string2 != null && string2.length() != 0) {
                object2 = sSLSession.getPeerHost();
                X509TrustManagerImpl.checkIdentity((String)object2, x509CertificateArray[0], string2);
            }
            object2 = ProtocolVersion.valueOf(sSLSession.getProtocol());
            SSLAlgorithmConstraints sSLAlgorithmConstraints = null;
            if (((ProtocolVersion)object2).v >= ProtocolVersion.TLS12.v) {
                if (sSLSession instanceof ExtendedSSLSession) {
                    object = (ExtendedSSLSession)sSLSession;
                    String[] stringArray = ((ExtendedSSLSession)object).getLocalSupportedSignatureAlgorithms();
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, stringArray, true);
                } else {
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, true);
                }
            } else {
                sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, true);
            }
            object = new AlgorithmChecker((AlgorithmConstraints)sSLAlgorithmConstraints);
            try {
                ((AlgorithmChecker)object).init(false);
                for (int i = x509CertificateArray.length - 1; i >= 0; --i) {
                    X509Certificate x509Certificate = x509CertificateArray[i];
                    ((AlgorithmChecker)object).check(x509Certificate, Collections.emptySet());
                }
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertificateException("Certificates does not conform to algorithm constraints");
            }
        }
    }
}

