/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import sun.security.ssl.Debug;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.HandshakeOutStream;

final class DHClientKeyExchange
extends HandshakeMessage {
    private byte[] dh_Yc;

    @Override
    int messageType() {
        return 16;
    }

    BigInteger getClientPublicKey() {
        return new BigInteger(1, this.dh_Yc);
    }

    DHClientKeyExchange(BigInteger bigInteger) {
        this.dh_Yc = DHClientKeyExchange.toByteArray(bigInteger);
    }

    DHClientKeyExchange() {
        this.dh_Yc = null;
    }

    DHClientKeyExchange(HandshakeInStream handshakeInStream) throws IOException {
        this.dh_Yc = handshakeInStream.getBytes16();
    }

    @Override
    int messageLength() {
        if (this.dh_Yc == null) {
            return 0;
        }
        return this.dh_Yc.length + 2;
    }

    @Override
    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putBytes16(this.dh_Yc);
    }

    @Override
    void print(PrintStream printStream) throws IOException {
        printStream.println("*** ClientKeyExchange, DH");
        if (debug != null && Debug.isOn("verbose")) {
            Debug.println(printStream, "DH Public key", this.dh_Yc);
        }
    }
}

