/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.EncryptedContentInfoStream;
import iaik.cms.EnvelopedDataStream;
import iaik.cms.KeyTransRecipientInfo;
import iaik.cms.RecipientInfo;
import iaik.security.random.SecRandom;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class ArcFourEnvelopedData {
    SecureRandom random;
    PrivateKey user2_pk;
    X509Certificate user2;
    PrivateKey user1_pk;
    X509Certificate user1;

    public void start() {
        String string = "This is the test message.";
        System.out.println("Test message: " + string);
        System.out.println();
        byte[] byArray = string.getBytes();
        try {
            byte[] byArray2 = null;
            System.out.println("\nEnvelopedDataStream demo for algorithm ARCFOUR [create]:\n");
            byte[] byArray3 = this.createEnvelopedDataStream(byArray, AlgorithmID.arcfour, 128);
            System.out.println("\nEnvelopedDataStream demo [parse]:\n");
            byArray2 = this.getEnvelopedDataStream(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nEnvelopedDataStream demo for algorithm ARCFOUR [create]:\n");
            System.out.println("Create EncryptedContentInfo for EnvelopedData...");
            byArray3 = this.createEncryptedContentInfoStream(byArray, AlgorithmID.arcfour, 128);
            System.out.println("\nEnvelopedDataStream demo [parse]:\n");
            byArray2 = this.getEnvelopedDataStream(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nEnvelopedDataStream demo for algorithm ARCFOUR [create]:\n");
            byArray3 = this.createEnvelopedDataStream(byArray, AlgorithmID.arcfour, 128);
            System.out.println("\nEnvelopedDataStream demo [parse]:\n");
            System.out.println("Decrypt EncryptedContentInfo of EnvelopedData...");
            byArray2 = this.getEncryptedContentInfoStream(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new ArcFourEnvelopedData().start();
        System.in.read();
    }

    public byte[] getEnvelopedDataStream(byte[] byArray, PrivateKey privateKey, int n) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        EnvelopedDataStream envelopedDataStream = new EnvelopedDataStream((InputStream)byteArrayInputStream);
        RecipientInfo[] recipientInfoArray = envelopedDataStream.getRecipientInfos();
        System.out.println("\nThis message can be decrypted by the owners of the following certificates:");
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            System.out.println("Recipient " + (n2 + 1) + ": ");
            System.out.println(recipientInfoArray[n2].getRecipientIdentifiers()[0]);
            ++n2;
        }
        EncryptedContentInfoStream encryptedContentInfoStream = envelopedDataStream.getEncryptedContentInfo();
        System.out.println("\nContent type of encrypted data: " + encryptedContentInfoStream.getContentType());
        AlgorithmID algorithmID = encryptedContentInfoStream.getContentEncryptionAlgorithm();
        System.out.println("Content Encryption Algorithm: " + algorithmID);
        envelopedDataStream.setupCipher((Key)privateKey, n);
        InputStream inputStream = envelopedDataStream.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    public byte[] getEncryptedContentInfoStream(byte[] byArray, PrivateKey privateKey, int n) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        EnvelopedDataStream envelopedDataStream = new EnvelopedDataStream((InputStream)byteArrayInputStream);
        RecipientInfo[] recipientInfoArray = envelopedDataStream.getRecipientInfos();
        System.out.println("\nThis message can be decrypted by the owners of the following certificates:");
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            System.out.println("Recipient " + (n2 + 1) + ":");
            System.out.println(recipientInfoArray[n2].getRecipientIdentifiers()[0]);
            ++n2;
        }
        SecretKey secretKey = recipientInfoArray[n].decryptKey((Key)this.user1_pk);
        EncryptedContentInfoStream encryptedContentInfoStream = envelopedDataStream.getEncryptedContentInfo();
        System.out.println("\nContent type of encrypted data: " + encryptedContentInfoStream.getContentType());
        AlgorithmID algorithmID = encryptedContentInfoStream.getContentEncryptionAlgorithm();
        System.out.println("Content Encryption Algorithm: " + algorithmID);
        encryptedContentInfoStream.setupCipher((Key)secretKey);
        InputStream inputStream = encryptedContentInfoStream.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    public byte[] createEnvelopedDataStream(byte[] byArray, AlgorithmID algorithmID, int n) throws Exception {
        EnvelopedDataStream envelopedDataStream;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            envelopedDataStream = new EnvelopedDataStream((InputStream)byteArrayInputStream, algorithmID, n);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for contentEA.getAlgorithm().getName().");
        }
        RecipientInfo[] recipientInfoArray = new RecipientInfo[]{new KeyTransRecipientInfo(this.user1, AlgorithmID.rsaEncryption), new KeyTransRecipientInfo(this.user2, AlgorithmID.rsaEncryption)};
        envelopedDataStream.setRecipientInfos(recipientInfoArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        envelopedDataStream.writeTo((OutputStream)byteArrayOutputStream, 2048);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] createEncryptedContentInfoStream(byte[] byArray, AlgorithmID algorithmID, int n) throws Exception {
        AlgorithmID algorithmID2 = (AlgorithmID)algorithmID.clone();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        KeyGenerator keyGenerator = KeyGenerator.getInstance("ARCFOUR");
        keyGenerator.init(n);
        SecretKey secretKey = keyGenerator.generateKey();
        EncryptedContentInfoStream encryptedContentInfoStream = new EncryptedContentInfoStream(ObjectID.cms_data, (InputStream)byteArrayInputStream);
        encryptedContentInfoStream.setupCipher(algorithmID2, (Key)secretKey, null);
        RecipientInfo[] recipientInfoArray = new RecipientInfo[2];
        recipientInfoArray[0] = new KeyTransRecipientInfo(this.user1, AlgorithmID.rsaEncryption);
        recipientInfoArray[0].encryptKey(secretKey);
        recipientInfoArray[1] = new KeyTransRecipientInfo(this.user2, AlgorithmID.rsaEncryption);
        recipientInfoArray[1].encryptKey(secretKey);
        EnvelopedDataStream envelopedDataStream = new EnvelopedDataStream(recipientInfoArray, encryptedContentInfoStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        envelopedDataStream.writeTo((OutputStream)byteArrayOutputStream, 2048);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    public ArcFourEnvelopedData() throws IOException {
        System.out.println();
        System.out.println("********************************************************************************************");
        System.out.println("*                             ArcFourEnvelopedData demo                                    *");
        System.out.println("* (shows the usage of the CMS EnvelopedData type implementation for the ARCFOUR algorithm) *");
        System.out.println("********************************************************************************************");
        System.out.println();
        X509Certificate[] x509CertificateArray = CMSKeyStore.getCertificateChain(0, 4);
        this.user1 = x509CertificateArray[0];
        this.user1_pk = CMSKeyStore.getPrivateKey(0, 4);
        this.user2 = CMSKeyStore.getCertificateChain(0, 6)[0];
        this.user2_pk = CMSKeyStore.getPrivateKey(0, 6);
        this.random = SecRandom.getDefault();
    }
}

