/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.EncryptedContentInfo;
import iaik.cms.EncryptedContentInfoStream;
import iaik.cms.EnvelopedData;
import iaik.cms.EnvelopedDataStream;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.KEKIdentifier;
import iaik.cms.KEKRecipientInfo;
import iaik.cms.KeyAgreeRecipientInfo;
import iaik.cms.KeyIdentifier;
import iaik.cms.KeyTransRecipientInfo;
import iaik.cms.RecipientInfo;
import iaik.cms.RecipientKeyIdentifier;
import iaik.cms.SubjectKeyID;
import iaik.security.random.SecRandom;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class CMSEnvelopedData {
    SecureRandom random;
    byte[] kekID;
    SecretKey kek;
    PrivateKey esdhUser2_pk;
    X509Certificate esdhUser2;
    PrivateKey esdhUser1_pk;
    X509Certificate esdhUser1;
    PrivateKey rsaUser2_pk;
    X509Certificate rsaUser2;
    PrivateKey rsaUser1_pk;
    X509Certificate rsaUser1;

    public void start() {
        String string = "This is the test message.";
        System.out.println("Test message: \"" + string + "\"");
        System.out.println();
        byte[] byArray = string.getBytes();
        try {
            System.out.println("Stream implementation demos");
            System.out.println("===========================");
            System.out.println("\nCMS EnvelopedDataStream demo [create]:\n");
            byte[] byArray2 = this.createEnvelopedDataStream(byArray);
            System.out.println("\nCMS EnvelopedDataStream demo [parse]:\n");
            System.out.println("Decrypt for the several recipients using their index into the recipientInfos field.");
            this.parseEnvelopedDataWithRecipientInfoIndex(true, byArray2);
            System.out.println("Decrypt for the several recipients using their RecipientIdentifier.");
            this.parseEnvelopedDataWithRecipientIdentifier(true, byArray2);
            System.out.println("Decrypt for the several recipients using their certificate or symmetric kek.");
            this.parseEnvelopedDataWithRecipientCertOrKEKId(true, byArray2);
            System.out.println("\nNon-stream implementation demos");
            System.out.println("===============================");
            System.out.println("\nCMS EnvelopedData demo [create]:\n");
            byArray2 = this.createEnvelopedData(byArray);
            System.out.println("\nCMS EnvelopedData demo [parse]:\n");
            System.out.println("Decrypt for the several recipients using their index into the recipientInfos field.");
            this.parseEnvelopedDataWithRecipientInfoIndex(false, byArray2);
            System.out.println("Decrypt for the several recipients using their RecipientIdentifier.");
            this.parseEnvelopedDataWithRecipientIdentifier(false, byArray2);
            System.out.println("Decrypt for the several recipients using their certificate or symmetric kek.");
            this.parseEnvelopedDataWithRecipientCertOrKEKId(false, byArray2);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public void parseEnvelopedDataWithRecipientInfoIndex(boolean bl, byte[] byArray) throws Exception {
        if (bl) {
            System.out.println("\nDecrypt for rsaUser1:");
            byte[] byArray2 = this.getEnvelopedDataStream(byArray, (Key)this.rsaUser1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nDecrypt for rsaUser2:");
            byArray2 = this.getEnvelopedDataStream(byArray, (Key)this.rsaUser2_pk, 1);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nDecrypt for esdhUser1:");
            byArray2 = this.getEnvelopedDataStream(byArray, (Key)this.esdhUser1_pk, 2);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nDecrypt for esdhUser2:");
            byArray2 = this.getEnvelopedDataStream(byArray, (Key)this.esdhUser2_pk, 2);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nDecrypt for kekUser:");
            byArray2 = this.getEnvelopedDataStream(byArray, (Key)this.kek, 3);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            return;
        }
        System.out.println("\nDecrypt for rsaUser1:");
        byte[] byArray3 = this.getEnvelopedData(byArray, (Key)this.rsaUser1_pk, 0);
        System.out.print("\nDecrypted content: ");
        System.out.println(new String(byArray3));
        System.out.println("\nDecrypt for rsaUser2:");
        byArray3 = this.getEnvelopedData(byArray, (Key)this.rsaUser2_pk, 1);
        System.out.print("\nDecrypted content: ");
        System.out.println(new String(byArray3));
        System.out.println("\nDecrypt for esdhUser1:");
        byArray3 = this.getEnvelopedData(byArray, (Key)this.esdhUser1_pk, 2);
        System.out.print("\nDecrypted content: ");
        System.out.println(new String(byArray3));
        System.out.println("\nDecrypt for esdhUser2:");
        byArray3 = this.getEnvelopedData(byArray, (Key)this.esdhUser2_pk, 2);
        System.out.print("\nDecrypted content: ");
        System.out.println(new String(byArray3));
        System.out.println("\nDecrypt for kekUser:");
        byArray3 = this.getEnvelopedData(byArray, (Key)this.kek, 3);
        System.out.print("\nDecrypted content: ");
        System.out.println(new String(byArray3));
    }

    public void parseEnvelopedDataWithRecipientIdentifier(boolean bl, byte[] byArray) throws Exception {
        if (bl) {
            System.out.println("\nDecrypt for rsaUser1:");
            byte[] byArray2 = this.getEnvelopedDataStream(byArray, (Key)this.rsaUser1_pk, (KeyIdentifier)new IssuerAndSerialNumber(this.rsaUser1));
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nDecrypt for rsaUser2:");
            byArray2 = this.getEnvelopedDataStream(byArray, (Key)this.rsaUser2_pk, (KeyIdentifier)new SubjectKeyID(this.rsaUser2));
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nDecrypt for esdhUser1:");
            byArray2 = this.getEnvelopedDataStream(byArray, (Key)this.esdhUser1_pk, (KeyIdentifier)new IssuerAndSerialNumber(this.esdhUser1));
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nDecrypt for esdhUser2:");
            byArray2 = this.getEnvelopedDataStream(byArray, (Key)this.esdhUser2_pk, (KeyIdentifier)new RecipientKeyIdentifier(this.esdhUser2));
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nDecrypt for kekUser:");
            byArray2 = this.getEnvelopedDataStream(byArray, (Key)this.kek, (KeyIdentifier)new KEKIdentifier(this.kekID));
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            return;
        }
        System.out.println("\nDecrypt for rsaUser1:");
        byte[] byArray3 = this.getEnvelopedData(byArray, (Key)this.rsaUser1_pk, (KeyIdentifier)new IssuerAndSerialNumber(this.rsaUser1));
        System.out.print("\nDecrypted content: ");
        System.out.println(new String(byArray3));
        System.out.println("\nDecrypt for rsaUser2:");
        byArray3 = this.getEnvelopedData(byArray, (Key)this.rsaUser2_pk, (KeyIdentifier)new SubjectKeyID(this.rsaUser2));
        System.out.print("\nDecrypted content: ");
        System.out.println(new String(byArray3));
        System.out.println("\nDecrypt for esdhUser1:");
        byArray3 = this.getEnvelopedData(byArray, (Key)this.esdhUser1_pk, (KeyIdentifier)new IssuerAndSerialNumber(this.esdhUser1));
        System.out.print("\nDecrypted content: ");
        System.out.println(new String(byArray3));
        System.out.println("\nDecrypt for esdhUser2:");
        byArray3 = this.getEnvelopedData(byArray, (Key)this.esdhUser2_pk, (KeyIdentifier)new RecipientKeyIdentifier(this.esdhUser2));
        System.out.print("\nDecrypted content: ");
        System.out.println(new String(byArray3));
        System.out.println("\nDecrypt for kekUser:");
        byArray3 = this.getEnvelopedData(byArray, (Key)this.kek, (KeyIdentifier)new KEKIdentifier(this.kekID));
        System.out.print("\nDecrypted content: ");
        System.out.println(new String(byArray3));
    }

    public void parseEnvelopedDataWithRecipientCertOrKEKId(boolean bl, byte[] byArray) throws Exception {
        if (bl) {
            System.out.println("\nDecrypt for rsaUser1:");
            byte[] byArray2 = this.getEnvelopedDataStream(byArray, this.rsaUser1_pk, this.rsaUser1, null);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nDecrypt for rsaUser2:");
            byArray2 = this.getEnvelopedDataStream(byArray, this.rsaUser2_pk, this.rsaUser2, null);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nDecrypt for esdhUser1:");
            byArray2 = this.getEnvelopedDataStream(byArray, this.esdhUser1_pk, this.esdhUser1, null);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nDecrypt for esdhUser2:");
            byArray2 = this.getEnvelopedDataStream(byArray, this.esdhUser2_pk, this.esdhUser2, null);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nDecrypt for kekUser:");
            byArray2 = this.getEnvelopedDataStream(byArray, this.kek, null, this.kekID);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            return;
        }
        System.out.println("\nDecrypt for rsaUser1:");
        byte[] byArray3 = this.getEnvelopedData(byArray, this.rsaUser1_pk, this.rsaUser1, null);
        System.out.print("\nDecrypted content: ");
        System.out.println(new String(byArray3));
        System.out.println("\nDecrypt for rsaUser2:");
        byArray3 = this.getEnvelopedData(byArray, this.rsaUser2_pk, this.rsaUser2, null);
        System.out.print("\nDecrypted content: ");
        System.out.println(new String(byArray3));
        System.out.println("\nDecrypt for esdhUser1:");
        byArray3 = this.getEnvelopedData(byArray, this.esdhUser1_pk, this.esdhUser1, null);
        System.out.print("\nDecrypted content: ");
        System.out.println(new String(byArray3));
        System.out.println("\nDecrypt for esdhUser2:");
        byArray3 = this.getEnvelopedData(byArray, this.esdhUser2_pk, this.esdhUser2, null);
        System.out.print("\nDecrypted content: ");
        System.out.println(new String(byArray3));
        System.out.println("\nDecrypt for kekUser:");
        byArray3 = this.getEnvelopedData(byArray, this.kek, null, this.kekID);
        System.out.print("\nDecrypted content: ");
        System.out.println(new String(byArray3));
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new CMSEnvelopedData().start();
        System.in.read();
    }

    public byte[] getEnvelopedDataStream(byte[] byArray, Key key, X509Certificate x509Certificate, byte[] byArray2) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        EnvelopedDataStream envelopedDataStream = new EnvelopedDataStream((InputStream)byteArrayInputStream);
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfoStream encryptedContentInfoStream = envelopedDataStream.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfoStream.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfoStream.getContentEncryptionAlgorithm().getName());
        try {
            System.out.println("Decrypt the content...");
            if (x509Certificate != null) {
                envelopedDataStream.setupCipher(key, x509Certificate);
            } else {
                envelopedDataStream.setupCipher(key, (KeyIdentifier)new KEKIdentifier(byArray2));
            }
            InputStream inputStream = envelopedDataStream.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
            streamCopier.copyStream();
            return byteArrayOutputStream.toByteArray();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Private key error: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
    }

    public byte[] getEnvelopedDataStream(byte[] byArray, Key key, KeyIdentifier keyIdentifier) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        EnvelopedDataStream envelopedDataStream = new EnvelopedDataStream((InputStream)byteArrayInputStream);
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfoStream encryptedContentInfoStream = envelopedDataStream.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfoStream.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfoStream.getContentEncryptionAlgorithm().getName());
        System.out.println("\nSearch for RecipientInfo:");
        RecipientInfo recipientInfo = envelopedDataStream.getRecipientInfo(keyIdentifier);
        if (recipientInfo != null) {
            System.out.println("RecipientInfo: " + recipientInfo);
        }
        try {
            System.out.println("Decrypt encrypted content encryption key...");
            SecretKey secretKey = recipientInfo.decryptKey(key, keyIdentifier);
            System.out.println("Decrypt content with decrypted content encryption key...");
            envelopedDataStream.setupCipher((Key)secretKey);
            InputStream inputStream = envelopedDataStream.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
            streamCopier.copyStream();
            return byteArrayOutputStream.toByteArray();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Private key error: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
    }

    public byte[] getEnvelopedDataStream(byte[] byArray, Key key, int n) throws IOException, CMSException {
        StreamCopier streamCopier;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        EnvelopedDataStream envelopedDataStream = new EnvelopedDataStream((InputStream)byteArrayInputStream);
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfoStream encryptedContentInfoStream = envelopedDataStream.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfoStream.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfoStream.getContentEncryptionAlgorithm().getName());
        System.out.println("\nThis message can be decrypted by the owners of the following certificates:");
        RecipientInfo[] recipientInfoArray = envelopedDataStream.getRecipientInfos();
        if (n == 0) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < recipientInfoArray.length) {
                streamCopier = recipientInfoArray[n3].getRecipientIdentifiers();
                int n4 = 0;
                while (n4 < ((StreamCopier)streamCopier).length) {
                    System.out.println("Recipient " + ++n2 + ":");
                    System.out.println(streamCopier[n4]);
                    ++n4;
                }
                ++n3;
            }
        }
        try {
            envelopedDataStream.setupCipher(key, n);
            InputStream inputStream = envelopedDataStream.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
            streamCopier.copyStream();
            return byteArrayOutputStream.toByteArray();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Private key error: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
    }

    public byte[] getEnvelopedData(byte[] byArray, Key key, X509Certificate x509Certificate, byte[] byArray2) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        EnvelopedData envelopedData = new EnvelopedData((InputStream)byteArrayInputStream);
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfo encryptedContentInfo = (EncryptedContentInfo)envelopedData.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfo.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfo.getContentEncryptionAlgorithm().getName());
        System.out.println("\nThis message can be decrypted by the owners of the following certificates:");
        try {
            System.out.println("Decrypt the content...");
            if (x509Certificate != null) {
                envelopedData.setupCipher(key, x509Certificate);
            } else {
                envelopedData.setupCipher(key, (KeyIdentifier)new KEKIdentifier(byArray2));
            }
            return envelopedData.getContent();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Private key error: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
    }

    public byte[] getEnvelopedData(byte[] byArray, Key key, KeyIdentifier keyIdentifier) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        EnvelopedData envelopedData = new EnvelopedData((InputStream)byteArrayInputStream);
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfo encryptedContentInfo = (EncryptedContentInfo)envelopedData.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfo.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfo.getContentEncryptionAlgorithm().getName());
        System.out.println("\nThis message can be decrypted by the owners of the following certificates:");
        System.out.println("\nSearch for RecipientInfo:");
        RecipientInfo recipientInfo = envelopedData.getRecipientInfo(keyIdentifier);
        if (recipientInfo != null) {
            System.out.println("RecipientInfo: " + recipientInfo);
        }
        try {
            System.out.println("Decrypt encrypted content encryption key...");
            SecretKey secretKey = recipientInfo.decryptKey(key, keyIdentifier);
            System.out.println("Decrypt content with decrypted content encryption key...");
            envelopedData.setupCipher((Key)secretKey);
            return envelopedData.getContent();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Private key error: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
    }

    public byte[] getEnvelopedData(byte[] byArray, Key key, int n) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        EnvelopedData envelopedData = new EnvelopedData((InputStream)byteArrayInputStream);
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfo encryptedContentInfo = (EncryptedContentInfo)envelopedData.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfo.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfo.getContentEncryptionAlgorithm().getName());
        System.out.println("\nThis message can be decrypted by the owners of the following certificates:");
        RecipientInfo[] recipientInfoArray = envelopedData.getRecipientInfos();
        if (n == 0) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < recipientInfoArray.length) {
                KeyIdentifier[] keyIdentifierArray = recipientInfoArray[n3].getRecipientIdentifiers();
                int n4 = 0;
                while (n4 < keyIdentifierArray.length) {
                    System.out.println("Recipient " + ++n2 + ":");
                    System.out.println(keyIdentifierArray[n4]);
                    ++n4;
                }
                ++n3;
            }
        }
        try {
            envelopedData.setupCipher(key, n);
            return envelopedData.getContent();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Private key error: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
    }

    public RecipientInfo[] createRecipients() throws CMSException {
        RecipientInfo[] recipientInfoArray = new RecipientInfo[4];
        try {
            recipientInfoArray[0] = new KeyTransRecipientInfo(this.rsaUser1, AlgorithmID.rsaEncryption);
            recipientInfoArray[1] = new KeyTransRecipientInfo(this.rsaUser2, 1, AlgorithmID.rsaEncryption);
            AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.esdhKeyAgreement.clone();
            AlgorithmID algorithmID2 = (AlgorithmID)AlgorithmID.cms_3DES_wrap.clone();
            int n = 192;
            recipientInfoArray[2] = new KeyAgreeRecipientInfo(algorithmID, algorithmID2, n);
            ((KeyAgreeRecipientInfo)recipientInfoArray[2]).addRecipient(this.esdhUser1, 0);
            ((KeyAgreeRecipientInfo)recipientInfoArray[2]).addRecipient(this.esdhUser2, 2);
            AlgorithmID algorithmID3 = (AlgorithmID)AlgorithmID.cms_3DES_wrap.clone();
            KEKIdentifier kEKIdentifier = new KEKIdentifier(this.kekID);
            recipientInfoArray[3] = new KEKRecipientInfo(kEKIdentifier, algorithmID3, this.kek);
        }
        catch (Exception exception) {
            throw new CMSException("Error adding recipients: " + exception.getMessage());
        }
        return recipientInfoArray;
    }

    public byte[] createEnvelopedDataStream(byte[] byArray) throws IOException, CMSException {
        EnvelopedDataStream envelopedDataStream;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            envelopedDataStream = new EnvelopedDataStream((InputStream)byteArrayInputStream, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for Triple-DES-CBC.");
        }
        RecipientInfo[] recipientInfoArray = this.createRecipients();
        envelopedDataStream.setRecipientInfos(recipientInfoArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        envelopedDataStream.writeTo((OutputStream)byteArrayOutputStream, 2048);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] createEnvelopedData(byte[] byArray) throws CMSException {
        EnvelopedData envelopedData;
        try {
            envelopedData = new EnvelopedData(byArray, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for Triple-DES-CBC.");
        }
        RecipientInfo[] recipientInfoArray = this.createRecipients();
        envelopedData.setRecipientInfos(recipientInfoArray);
        return envelopedData.getEncoded();
    }

    public CMSEnvelopedData() throws IOException {
        KeyGenerator keyGenerator;
        System.out.println();
        System.out.println("**********************************************************************************");
        System.out.println("*                           CMSEnvelopedData demo                                *");
        System.out.println("*        (shows the usage of the CMS EnvelopedData type implementation)          *");
        System.out.println("**********************************************************************************");
        System.out.println();
        X509Certificate[] x509CertificateArray = CMSKeyStore.getCertificateChain(0, 4);
        this.rsaUser1 = x509CertificateArray[0];
        this.rsaUser1_pk = CMSKeyStore.getPrivateKey(0, 4);
        this.rsaUser2 = CMSKeyStore.getCertificateChain(0, 6)[0];
        this.rsaUser2_pk = CMSKeyStore.getPrivateKey(0, 6);
        this.esdhUser1 = CMSKeyStore.getCertificateChain(2, 4)[0];
        this.esdhUser1_pk = CMSKeyStore.getPrivateKey(2, 4);
        this.esdhUser2 = CMSKeyStore.getCertificateChain(2, 5)[0];
        this.esdhUser2_pk = CMSKeyStore.getPrivateKey(2, 5);
        this.random = SecRandom.getDefault();
        try {
            keyGenerator = KeyGenerator.getInstance("3DES");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("KeyGenerator for 3DES not avcailable!");
        }
        keyGenerator.init(this.random);
        this.kek = keyGenerator.generateKey();
        byte[] byArray = new byte[4];
        byArray[3] = 1;
        this.kekID = byArray;
    }
}

