/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.RecipientKeyIdentifier;
import iaik.utils.InternalErrorException;
import iaik.x509.X509Certificate;

class f
implements CertificateIdentifier {
    private CertificateIdentifier a;

    public String toString() {
        return String.valueOf(this.getKeyIdTypeName()) + ": " + this.a.toString();
    }

    public ASN1Object toASN1Object() {
        ASN1Object aSN1Object = null;
        try {
            aSN1Object = this.a.toASN1Object();
        }
        catch (CodingException codingException) {
            throw new InternalErrorException("Error encoding certificate identifier: " + codingException.getMessage(), (Exception)((Object)codingException));
        }
        if (this.a.getKeyIdType() == 0) {
            return aSN1Object;
        }
        return new CON_SPEC(0, aSN1Object, true);
    }

    public boolean identifiesCert(X509Certificate x509Certificate) {
        return this.a.identifiesCert(x509Certificate);
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public String getKeyIdTypeName() {
        return this.a.getKeyIdTypeName();
    }

    public int getKeyIdType() {
        return this.a.getKeyIdType();
    }

    public CertificateIdentifier getCertificateIdentifier() {
        return this.a;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof f)) {
            return false;
        }
        f f2 = (f)object;
        if (this.getKeyIdType() != f2.getKeyIdType()) {
            return false;
        }
        return this.a.equals(f2.getCertificateIdentifier());
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.CON_SPEC)) {
            this.a = new IssuerAndSerialNumber(aSN1Object);
            if (this.a == null) {
                throw new CodingException("Cannot create KeyAgreeRecipientIdentifier. Missing IssuerAndSerialNumber!");
            }
        } else {
            CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
            cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
            this.a = new RecipientKeyIdentifier((ASN1Object)cON_SPEC.getValue());
            if (this.a == null) {
                throw new CodingException("Cannot create KeyAgreeRecipientIdentifier. Missing RecipientKeyIdentifier!");
            }
        }
    }

    public f(CertificateIdentifier certificateIdentifier) {
        int n2 = certificateIdentifier.getKeyIdType();
        if (n2 != 0 && n2 != 2) {
            throw new IllegalArgumentException("Invalid signerIdentifier! Expected RecipientKeyIdentifier or IssuerAndSerialNumber!");
        }
        this.a = certificateIdentifier;
    }

    public f(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public f() {
    }
}

