/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonViewerMapper;

public class ResourceToItemsMapper
implements ICommonViewerMapper {
    private static final int NUMBER_LIST_REUSE = 10;
    private HashMap _resourceToItem = new HashMap();
    private Stack _reuseLists = new Stack();
    private CommonViewer _commonViewer;
    static /* synthetic */ Class class$0;

    public ResourceToItemsMapper(CommonViewer viewer) {
        this._commonViewer = viewer;
        viewer.setMapper((ICommonViewerMapper)this);
    }

    public void addToMap(Object element, Item item) {
        IResource resource = ResourceToItemsMapper.getCorrespondingResource(element);
        if (resource != null) {
            Object existingMapping = this._resourceToItem.get(resource);
            if (existingMapping == null) {
                this._resourceToItem.put(resource, item);
            } else if (existingMapping instanceof Item) {
                if (existingMapping != item) {
                    List list = this.getNewList();
                    list.add(existingMapping);
                    list.add(item);
                    this._resourceToItem.put(resource, list);
                }
            } else {
                List list = (List)existingMapping;
                if (!list.contains(item)) {
                    list.add(item);
                }
            }
        }
    }

    public void removeFromMap(Object element, Item item) {
        IResource resource = ResourceToItemsMapper.getCorrespondingResource(element);
        if (resource != null) {
            Object existingMapping = this._resourceToItem.get(resource);
            if (existingMapping == null) {
                return;
            }
            if (existingMapping instanceof Item) {
                this._resourceToItem.remove(resource);
            } else {
                List list = (List)existingMapping;
                list.remove(item);
                if (list.isEmpty()) {
                    this._resourceToItem.remove(list);
                    this.releaseList(list);
                }
            }
        }
    }

    public void clearMap() {
        this._resourceToItem.clear();
    }

    public boolean isEmpty() {
        return this._resourceToItem.isEmpty();
    }

    private List getNewList() {
        if (!this._reuseLists.isEmpty()) {
            return (List)this._reuseLists.pop();
        }
        return new ArrayList(2);
    }

    private void releaseList(List list) {
        if (this._reuseLists.size() < 10) {
            this._reuseLists.push(list);
        }
    }

    public boolean handlesObject(Object object) {
        return object instanceof IResource;
    }

    public void objectChanged(Object changedResource) {
        Object obj = this._resourceToItem.get(changedResource);
        if (obj != null) {
            if (obj instanceof Item) {
                this.updateItem((Item)obj);
            } else {
                List list = (List)obj;
                int k = 0;
                while (k < list.size()) {
                    this.updateItem((Item)list.get(k));
                    ++k;
                }
            }
        }
    }

    private void updateItem(Item item) {
        if (!item.isDisposed()) {
            this._commonViewer.doUpdateItem((Widget)item);
        }
    }

    private static IResource getCorrespondingResource(Object element) {
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }
}

