/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.cipher;

import iaik.security.cipher.DESKeyGenerator;
import iaik.security.md.SHA;
import iaik.security.random.SHA1Random;
import iaik.utils.CriticalObject;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.xml.crypto.XSecProvider;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public class DESedeKWProxyCipher
extends CipherSpi {
    protected Key key_;
    protected int opmode_;
    protected SecureRandom secureRandom_;
    protected Cipher cipher2_;
    protected Cipher cipher1_;
    protected ByteArrayOutputStream buffer_;
    public final int CKS_LENGTH = 8;
    public static final byte[] CMS_KEY_WRAP_IV = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};

    private byte[] prepareWrap(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (!key.getFormat().equals("RAW")) {
            throw new InvalidKeyException("Content encryption key format must be RAW");
        }
        byte[] byArray2 = new byte[24];
        if (byArray.length == 16) {
            System.arraycopy(byArray, 0, byArray2, 0, 16);
            System.arraycopy(byArray, 0, byArray2, 16, 8);
        } else if (byArray.length == 24) {
            System.arraycopy(byArray, 0, byArray2, 0, 24);
        } else {
            throw new InvalidKeyException("Triple-DES content encryption key must be 16 or 24 bytes long!");
        }
        DESKeyGenerator.adjustParity((byte[])byArray2, (int)0);
        DESKeyGenerator.adjustParity((byte[])byArray2, (int)8);
        DESKeyGenerator.adjustParity((byte[])byArray2, (int)16);
        return byArray2;
    }

    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] byArray = key.getEncoded();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Failed to encode key.");
        }
        if (byArray.length % 8 != 0) {
            throw new InvalidKeyException("The key length must be a multiple of 8.");
        }
        byte[] byArray2 = "DESede".equals(key.getAlgorithm()) || "http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(key.getAlgorithm()) ? this.prepareWrap(key) : byArray;
        try {
            return this.engineDoFinal(byArray2, 0, byArray2.length);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        this.buffer_.write(byArray, n, n2);
        return 0;
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.buffer_.write(byArray, n, n2);
        return null;
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] byArray2;
        if (byArray == null || byArray.length % 8 != 0) {
            throw new InvalidKeyException("The wrapped key length must be a multiple of 8.");
        }
        try {
            byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
        if ("DESede".equals(string) || "http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(string)) {
            if (byArray2.length != 24) {
                throw new InvalidKeyException("Invalid TripleDESKey; wrong length.");
            }
            int n2 = 0;
            while (n2 < 3) {
                if (!DESKeyGenerator.checkParity((byte[])byArray2, (int)(n2 * 8), (boolean)true)) {
                    throw new InvalidKeyException("TripleDESKey not (odd) parity adjusted.");
                }
                ++n2;
            }
        }
        return Util.decodeKey((int)n, (String)string, (byte[])byArray2);
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("Padding " + string + " not supported.");
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Mode " + string + " not supported.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.opmode_ = n;
        this.key_ = key;
        switch (n) {
            case 4: {
                n = 2;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
        }
        if (n == 1) {
            if (algorithmParameterSpec != null) {
                if (!(algorithmParameterSpec instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("AlgorithmParameters '" + algorithmParameterSpec.getClass() + "' not supported.");
                this.cipher1_.init(n, key, algorithmParameterSpec);
            } else {
                SecureRandom secureRandom2 = secureRandom != null ? secureRandom : this.secureRandom_;
                byte[] byArray = new byte[8];
                secureRandom2.nextBytes(byArray);
                this.cipher1_.init(n, key, new IvParameterSpec(byArray));
            }
            this.cipher2_.init(n, key, new IvParameterSpec(CMS_KEY_WRAP_IV));
            return;
        } else {
            if (algorithmParameterSpec != null) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameters '" + algorithmParameterSpec.getClass() + "' not supported.");
            }
            this.cipher1_.init(n, key, new IvParameterSpec(CMS_KEY_WRAP_IV));
        }
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.opmode_ = n;
        this.key_ = key;
        switch (n) {
            case 4: {
                n = 2;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
        }
        try {
            if (n == 1) {
                SecureRandom secureRandom2 = secureRandom != null ? secureRandom : this.secureRandom_;
                byte[] byArray = new byte[8];
                secureRandom2.nextBytes(byArray);
                this.cipher1_.init(n, key, new IvParameterSpec(byArray));
                this.cipher2_.init(n, key, new IvParameterSpec(CMS_KEY_WRAP_IV));
            } else {
                this.cipher1_.init(n, key, new IvParameterSpec(CMS_KEY_WRAP_IV));
            }
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException.getMessage());
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.opmode_ = n;
        this.key_ = key;
        if (algorithmParameters != null) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameters '" + algorithmParameters.getClass() + "' not supported.");
        }
        switch (n) {
            case 4: {
                n = 2;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
        }
        if (n == 1) {
            SecureRandom secureRandom2 = secureRandom != null ? secureRandom : this.secureRandom_;
            byte[] byArray = new byte[8];
            secureRandom2.nextBytes(byArray);
            this.cipher1_.init(n, key, new IvParameterSpec(byArray));
            this.cipher2_.init(n, key, new IvParameterSpec(CMS_KEY_WRAP_IV));
        } else {
            this.cipher1_.init(n, key, new IvParameterSpec(CMS_KEY_WRAP_IV));
        }
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected int engineGetOutputSize(int n) {
        return 0;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return 168;
    }

    protected byte[] engineGetIV() {
        return this.cipher1_.getIV();
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        byte[] byArray3 = this.engineDoFinal(byArray, n, n2);
        if (byArray3 == null) {
            return 0;
        }
        if (byArray3.length > byArray2.length - n3) {
            throw new ShortBufferException();
        }
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
        if (byArray == null || byArray.length % 8 != 0) {
            throw new IllegalBlockSizeException();
        }
        if (this.opmode_ == 1 || this.opmode_ == 3) {
            byte[] byArray2;
            if (this.buffer_.size() == 0) {
                if (n == 0 && n2 == byArray.length) {
                    byArray2 = byArray;
                } else {
                    byArray2 = new byte[n2];
                    System.arraycopy(byArray, n, byArray2, 0, n2);
                }
            } else {
                this.buffer_.write(byArray, n, n2);
                byArray2 = this.buffer_.toByteArray();
                this.buffer_.reset();
            }
            byte[] byArray3 = new byte[byArray2.length + 8];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            this.cmsKeyCheckSum(byArray2, byArray3, byArray2.length, 8);
            byte[] byArray4 = this.cipher1_.doFinal(byArray3);
            byte[] byArray5 = this.cipher1_.getIV();
            byte[] byArray6 = new byte[byArray4.length + byArray5.length];
            System.arraycopy(byArray5, 0, byArray6, 0, byArray5.length);
            System.arraycopy(byArray4, 0, byArray6, byArray5.length, byArray4.length);
            CryptoUtils.reverseArray((byte[])byArray6, (int)0, (int)byArray6.length);
            byte[] byArray7 = this.cipher2_.doFinal(byArray6);
            CriticalObject.destroy((byte[])byArray2);
            CriticalObject.destroy((byte[])byArray3);
            CriticalObject.destroy((byte[])byArray4);
            return byArray7;
        }
        byte[] byArray8 = byArray;
        byte[] byArray9 = this.cipher1_.doFinal(byArray8);
        CryptoUtils.reverseArray((byte[])byArray9, (int)0, (int)byArray9.length);
        byte[] byArray10 = new byte[8];
        byte[] byArray11 = new byte[byArray9.length - byArray10.length];
        System.arraycopy(byArray9, 0, byArray10, 0, byArray10.length);
        System.arraycopy(byArray9, byArray10.length, byArray11, 0, byArray11.length);
        try {
            this.cipher2_.init(2, this.key_, new IvParameterSpec(byArray10));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException.getMessage());
        }
        byte[] byArray12 = this.cipher2_.doFinal(byArray11);
        byte[] byArray13 = new byte[byArray12.length - 8];
        System.arraycopy(byArray12, 0, byArray13, 0, byArray13.length);
        this.cmsKeyCheckSum(byArray13, byArray11, 0, 8);
        if (!CryptoUtils.equalsBlock((byte[])byArray11, (int)0, (byte[])byArray12, (int)byArray13.length, (int)8)) {
            throw new BadPaddingException("Could not unwrap key: CMS checksum error!");
        }
        CriticalObject.destroy((byte[])byArray10);
        CriticalObject.destroy((byte[])byArray11);
        CriticalObject.destroy((byte[])byArray12);
        return byArray13;
    }

    private void cmsKeyCheckSum(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (n2 < 0) {
            n2 = 8;
        }
        if (n2 > 20) {
            throw new IndexOutOfBoundsException("Only 20 bytes available from SHA-1!");
        }
        SHA sHA = new SHA();
        System.arraycopy(sHA.digest(byArray), 0, byArray2, n, n2);
    }

    public DESedeKWProxyCipher() throws NoSuchPaddingException, NoSuchProviderException, NoSuchAlgorithmException {
        String string = XSecProvider.getDelegationProvider("DESede/CBC/NoPadding");
        if (string != null) {
            this.cipher1_ = Cipher.getInstance("DESede/CBC/NoPadding", string);
            this.cipher2_ = Cipher.getInstance("DESede/CBC/NoPadding", string);
        } else {
            this.cipher1_ = Cipher.getInstance("DESede/CBC/NoPadding");
            this.cipher2_ = Cipher.getInstance("DESede/CBC/NoPadding");
        }
        this.secureRandom_ = new SHA1Random();
        this.buffer_ = new ByteArrayOutputStream();
    }
}

