/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2012;

import finanze.IDTE.generale2012.BaseTelem;
import finanze.IDTE.resources.RecordParser;
import finanze.IDTE.utility.UtilizzaRisorsa;
import java.io.IOException;
import java.text.CollationKey;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class Util {
    public static int restituisciTipo(String codiceCampo, String modello) {
        int out = BaseTelem.getInstance().getControlli(modello).getFormato(codiceCampo);
        return out;
    }

    public static int restituisciTipo(int pos, String modello) {
        int out = BaseTelem.getInstance().getRecordBcontrolli().getFormatoAt(pos - 1);
        return out;
    }

    public static String accapo(int dove, String riga) {
        String out = "";
        if (dove >= riga.length()) {
            out = riga;
        } else {
            int taglio = riga.lastIndexOf(32, dove);
            int lfPresente = riga.lastIndexOf(10, dove);
            if (taglio == 0 || taglio == -1) {
                taglio = dove;
            }
            if (lfPresente >= 0) {
                taglio = lfPresente;
            }
            out = riga.length() - taglio >= dove ? riga.substring(0, taglio) + "\n" + Util.accapo(dove, riga.substring(taglio, riga.length()).trim()) : riga.substring(0, taglio) + "\n" + riga.substring(taglio, riga.length()).trim();
        }
        return out;
    }

    public static String aggiungiMigliaia(String num) {
        if (Util.numerico(num)) {
            String out = new String();
            int pos = num.indexOf(",");
            int i = pos > 0 ? pos : num.length();
            while (i > 0) {
                if (i - 3 <= 0 || i - 3 == 1 && num.charAt(0) == '-') {
                    return num.substring(0, i) + out + (pos > 0 ? num.substring(pos, num.length()) : "");
                }
                out = "." + num.substring(i - 3, i) + out;
                i -= 3;
            }
        }
        System.out.println("Errore nella conversione delle migliaia del numero:" + num);
        return "0";
    }

    public static int aggRc(int rc, int rc_new) {
        if (rc_new > rc) {
            return rc_new;
        }
        return rc;
    }

    public static double arrotondaDecimali(double valore, int decimali) {
        double fattore = Math.pow(10.0, new Integer(decimali).doubleValue());
        return (double)Math.round(valore * fattore) / fattore;
    }

    public static String arrotondaDecimali(String valore, int decimali) {
        String out = "";
        double dx = Util.valoreDouble(valore);
        double fattore = Math.pow(10.0, new Integer(decimali).doubleValue());
        int ix = new Double(dx = (double)Math.round(dx * fattore) / fattore).intValue();
        out = (double)ix == dx ? "" + ix : ("" + dx).replace('.', ',');
        int i = out.indexOf("E");
        if (i > 0) {
            int f = Integer.parseInt(out.substring(i + 1));
            out = String.valueOf(out.charAt(0)) + out.substring(2, f + 2) + ',' + out.substring(f + 2, i);
        }
        return out;
    }

    public static String cambiaEstensione(String nomeFile, String nuovaEstensione) {
        int p = nomeFile.lastIndexOf(46);
        if (p < 0) {
            return nomeFile + "." + nuovaEstensione;
        }
        return nomeFile.substring(0, p) + "." + nuovaEstensione;
    }

    public static int compare(String s1, String s2) {
        int l2;
        int l1 = s1.length();
        if (l1 != (l2 = s2.length())) {
            return l1 > l2 ? l2 : l1;
        }
        int i = 0;
        while (i < l1) {
            if (s1.charAt(i) != s2.charAt(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int contaCampiPresenti(RecordParser rp, int primo, int ultimo) {
        int conta = 0;
        while (primo <= ultimo) {
            if (!Util.isNonValorizzato(rp.prendiValore(primo))) {
                ++conta;
            }
            ++primo;
        }
        return conta;
    }

    public static int contaCampiPresenti(RecordParser rp, int[] codCampi) {
        int conta = 0;
        int i = 0;
        while (i < codCampi.length) {
            if (!Util.isNonValorizzato(rp.prendiValore(codCampi[i]))) {
                ++conta;
            }
            ++i;
        }
        return conta;
    }

    public static int contaCaratteri(String s, char c, int pos) {
        int contatore = 0;
        int i = pos + 1;
        while (i < s.trim().length()) {
            if (s.charAt(i) == c) {
                ++contatore;
            }
            ++i;
        }
        return contatore;
    }

    public static boolean controllaPeriodoImposta(String data1, String data2) {
        int giorno = 0;
        int mese = 0;
        int anno = 0;
        int giornomese = 0;
        giorno = Integer.parseInt(data2.substring(0, 2));
        mese = Integer.parseInt(data2.substring(2, 4));
        anno = Integer.parseInt(data2.substring(4, 6));
        switch (mese) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                giornomese = 31;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                giornomese = 30;
                break;
            }
            case 2: {
                if (anno % 4 == 0 && anno != 1900) {
                    giornomese = 29;
                    break;
                }
                giornomese = 28;
                break;
            }
        }
        if (giorno == giornomese) {
            giorno = 1;
            if (mese == 12) {
                mese = 1;
                ++anno;
            } else {
                ++mese;
            }
        } else {
            ++giorno;
        }
        data2 = String.valueOf(Util.formNum(2, giorno)) + Util.formNum(2, mese) + Util.formNum(2, --anno);
        if ((String.valueOf(data1.substring(0, 2)) + data1.substring(2, 4)).equals("2902")) {
            return data2.equals("2802" + anno) || data2.equals("0103" + anno);
        }
        return data1.equals(data2);
    }

    public static boolean controllaStruttura(String f, String s) {
        if (f.length() != s.length()) {
            return false;
        }
        int i = 0;
        while (i < f.length()) {
            if (f.charAt(i) == 'C' && Character.isDigit(s.charAt(i))) {
                return false;
            }
            if (f.charAt(i) == 'N' && !Character.isDigit(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean controlloMeseAnno(String data) {
        return Util.controlloMeseAnno(data, 1900, 2100);
    }

    public static boolean controlloMeseAnno(String data, int minAnno, int maxAnno) {
        int anno;
        if ((data = data.trim()).equals("0")) {
            return true;
        }
        if (data.length() != 6) {
            return false;
        }
        int mese = Integer.parseInt(data.substring(0, 2));
        if (mese + (anno = Integer.parseInt(data.substring(2, 6))) == 0) {
            return true;
        }
        return mese > 0 && mese < 13 && anno >= minAnno && anno <= maxAnno;
    }

    public static String convertiAccentate(String s) {
        s = Util.replaceString(s, "\ufffd", "A'");
        s = Util.replaceString(s, "\ufffd", "E'");
        s = Util.replaceString(s, "\ufffd", "I'");
        s = Util.replaceString(s, "\ufffd", "O'");
        s = Util.replaceString(s, "\ufffd", "U'");
        s = Util.replaceString(s, "\ufffd", "E'");
        return s;
    }

    public static String dateWithoutSlash(String date) {
        int firstSlash = date.indexOf("/");
        int lastSlash = date.lastIndexOf("/");
        String firstToken = date.substring(0, firstSlash);
        String secondToken = date.substring(firstSlash + 1, lastSlash);
        String thirdToken = date.substring(lastSlash + 1);
        return Util.formNum(2, firstToken) + Util.formNum(2, secondToken) + thirdToken;
    }

    public static boolean detectLowValueChars(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) < ' ') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean esisteAlmenoUnCampo(RecordParser rp, int primo, int ultimo) {
        while (primo <= ultimo) {
            if (!Util.isNonValorizzato(rp.prendiValore(primo))) {
                return true;
            }
            ++primo;
        }
        return false;
    }

    public static boolean esisteAlmenoUnCampo(RecordParser rp, int[] codCampi) {
        int i = 0;
        while (i < codCampi.length) {
            if (!Util.isNonValorizzato(rp.prendiValore(codCampi[i]))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean esisteCodAtt(String codatt) {
        if (BaseTelem.getInstance().getDescCodAtt() == null) {
            try {
                BaseTelem.getInstance().riempiDescCodAtt();
            }
            catch (IOException e) {
                System.out.println("Errore nel caricamento dei Codici Attivit\ufffd");
            }
        }
        return BaseTelem.getInstance().getDescCodAtt(codatt).length() != 0;
    }

    public static boolean esisteCodEnteT3(String cod) {
        UtilizzaRisorsa ur = new UtilizzaRisorsa("codiceEnteT3");
        return ur.esisteCodice(cod);
    }

    public static boolean esisteCodUff(String coduff) {
        if (BaseTelem.getInstance().getDescCodUff() == null) {
            try {
                BaseTelem.getInstance().riempiDescCodUff();
            }
            catch (IOException e) {
                System.out.println("Errore nel caricamento dei Codici Ufficio");
            }
        }
        return BaseTelem.getInstance().getDescCodUff(coduff).length() != 0;
    }

    public static boolean esisteCodiceConcessione(String cod) {
        UtilizzaRisorsa ur = new UtilizzaRisorsa("codiceConcessione");
        return ur.esisteCodice(cod);
    }

    public static boolean esisteCodiceEstero(String cod) {
        UtilizzaRisorsa ur = new UtilizzaRisorsa("codiceEstero");
        return ur.esisteCodice(cod);
    }

    public static boolean esisteCodiceOperazioneEstero(String cod) {
        UtilizzaRisorsa ur = new UtilizzaRisorsa("codiceOperazioneEstero");
        return ur.esisteCodice(cod);
    }

    public static boolean esisteCodicePaeseEstero(String paese) {
        UtilizzaRisorsa ur = new UtilizzaRisorsa("codicePaeseEstero");
        return ur.esisteCodice(paese);
    }

    public static boolean esistenzaTuttiCampi(RecordParser rp, int primo, int ultimo, boolean esistenza) {
        while (primo <= ultimo) {
            if (esistenza && Util.isNonValorizzato(rp.prendiValore(primo))) {
                return false;
            }
            if (!esistenza && !Util.isNonValorizzato(rp.prendiValore(primo))) {
                return false;
            }
            ++primo;
        }
        return true;
    }

    public static boolean esistenzaTuttiCampi(RecordParser rp, int[] codCampi, boolean esistenza) {
        int i = 0;
        while (i < codCampi.length) {
            if (esistenza && Util.isNonValorizzato(rp.prendiValore(codCampi[i]))) {
                return false;
            }
            if (!esistenza && !Util.isNonValorizzato(rp.prendiValore(codCampi[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean esisteOldCodAtt(String codatt) {
        UtilizzaRisorsa ur = new UtilizzaRisorsa("oldCodAtt");
        return ur.esisteCodice(codatt);
    }

    public static boolean esisteProvinciaResidenza(String prov) {
        UtilizzaRisorsa ur = new UtilizzaRisorsa("province_range_10");
        return ur.esisteCodice(prov) && ur.getDescrizione(prov).indexOf("-1") < 0;
    }

    public static boolean esisteProvinciaNascita(String prov) {
        if (prov.trim().equals("EE")) {
            return true;
        }
        UtilizzaRisorsa ur = new UtilizzaRisorsa("province_range_10");
        return ur.esisteCodice(prov);
    }

    public static boolean esisteQualificaINPDAP(String codice) {
        UtilizzaRisorsa ur = new UtilizzaRisorsa("qualificaINPDAP");
        return ur.esisteCodice(codice);
    }

    public static String format(double valore) {
        String out = "";
        String s = "";
        String meno = "";
        int fattore = 0;
        int i = 0;
        try {
            s = String.valueOf(valore);
            if (s.substring(s.length() - 2, s.length()).equals(".0")) {
                int vi = (int)valore;
                out = String.valueOf(vi);
            } else {
                if (s.charAt(0) == '-') {
                    s = s.substring(1);
                    meno = "-";
                }
                if ((i = s.indexOf("E")) > 0) {
                    fattore = Integer.parseInt(s.substring(i + 1));
                    out = String.valueOf(meno) + s.charAt(0) + s.substring(2, fattore + 2) + (fattore + 2 == i ? "" : String.valueOf(',') + s.substring(fattore + 2, i));
                } else {
                    out = String.valueOf(valore).replace('.', ',');
                }
            }
        }
        catch (Exception e) {
            out = String.valueOf(meno) + s.charAt(0) + s.substring(2, i) + Util.formNum(2 + fattore - i, 0);
        }
        return out;
    }

    public static String formattaN(String st) {
        String st1 = st.trim().replace(',', '.');
        try {
            new Float(st1);
        }
        catch (NumberFormatException e) {
            st1 = "E" + st1;
            return st1;
        }
        return st1;
    }

    public static String formNum(int l, int i) {
        return Util.formNum(l, String.valueOf(i));
    }

    public static String formNum(int l, long i) {
        return Util.formNum(l, String.valueOf(i));
    }

    public static String formNum(int l, String si) {
        int li = si.length();
        if (li == l) {
            return si;
        }
        if (li < l) {
            char[] vchar = new char[l];
            int c = 0;
            while (c < l) {
                vchar[c] = c < l - li ? 48 : (int)si.charAt(c - (l - li));
                ++c;
            }
            return new String(vchar);
        }
        return si.substring(0, l);
    }

    public static String formStr(int l, String valore, char riemp) {
        int li;
        int lstr;
        String rc = "";
        if (valore == null) {
            valore = "";
        }
        if ((lstr = l - (li = valore.length())) == 0) {
            rc = valore;
        } else if (lstr > 0) {
            char[] vchar = new char[lstr];
            int i = 0;
            while (i < lstr) {
                vchar[i] = 32;
                ++i;
            }
            String bb = new String(vchar);
            if (riemp == 'R') {
                rc = String.valueOf(valore) + bb;
            }
            if (riemp == 'L') {
                rc = String.valueOf(bb) + valore;
            }
        } else {
            if (riemp == 'R') {
                rc = valore.substring(0, l);
            }
            if (riemp == 'L') {
                rc = valore.substring(li - l, li);
            }
        }
        return rc;
    }

    public static String getDataCorrente() {
        Date dateNow = new Date();
        SimpleDateFormat dfGiorno = new SimpleDateFormat("dd");
        SimpleDateFormat dfMese = new SimpleDateFormat("MM");
        SimpleDateFormat dfAnno = new SimpleDateFormat("yyyy");
        String data = String.valueOf(dfGiorno.format(dateNow)) + dfMese.format(dateNow) + dfAnno.format(dateNow);
        return data;
    }

    public static boolean isData1compresatraData2eData3(String data1, String data2, String data3) {
        int dataInizio = 0;
        int dataFine = 0;
        int dataCorrente = 0;
        if (data1.length() == 8) {
            dataCorrente = Integer.parseInt(String.valueOf(data1.substring(4, 8)) + data1.substring(2, 4) + data1.substring(0, 2));
        }
        if (data2.length() == 8) {
            dataInizio = Integer.parseInt(String.valueOf(data2.substring(4, 8)) + data2.substring(2, 4) + data2.substring(0, 2));
        }
        if (data3.length() == 8) {
            dataFine = Integer.parseInt(String.valueOf(data3.substring(4, 8)) + data3.substring(2, 4) + data3.substring(0, 2));
        }
        return dataCorrente >= dataInizio && dataCorrente <= dataFine;
    }

    public static boolean isData1minoreUgualeData2(String data1, String data2) {
        int dataInizio = 0;
        int dataFine = 0;
        if (data1.length() == 8) {
            dataInizio = Integer.parseInt(String.valueOf(data1.substring(4, 8)) + data1.substring(2, 4) + data1.substring(0, 2));
        }
        if (data2.length() == 8) {
            dataFine = Integer.parseInt(String.valueOf(data2.substring(4, 8)) + data2.substring(2, 4) + data2.substring(0, 2));
        }
        return dataInizio <= dataFine;
    }

    public static boolean isDiffMaggioreDi1(long a, long b) {
        return Math.abs(a - b) > 1L;
    }

    public static boolean isInside(double i, String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            int p = item.indexOf("-");
            if (p > 0) {
                double da = Double.valueOf(item.substring(0, p));
                double a = Double.valueOf(item.substring(p + 1, item.length()));
                if (!(da <= i) || !(i <= a)) continue;
                return true;
            }
            if (Double.valueOf(item) != i) continue;
            return true;
        }
        return false;
    }

    public static boolean isInside(int i, String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            int p = item.indexOf("-");
            if (p > 0) {
                int da = Integer.parseInt(item.substring(0, p));
                int a = Integer.parseInt(item.substring(p + 1, item.length()));
                if (da > i || i > a) continue;
                return true;
            }
            if (Integer.parseInt(item) != i) continue;
            return true;
        }
        return false;
    }

    public static boolean isInside(long i, String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            int p = item.indexOf("-");
            if (p > 0) {
                long da = Long.parseLong(item.substring(0, p));
                long a = Long.parseLong(item.substring(p + 1, item.length()));
                if (da > i || i > a) continue;
                return true;
            }
            if (Long.parseLong(item) != i) continue;
            return true;
        }
        return false;
    }

    public static boolean isInside(String i, String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String elem = st.nextToken();
            if (!elem.equals(i)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNonValorizzato(String valore) {
        String s = valore.trim();
        if (s.equals("")) {
            return true;
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            if (s.charAt(i) != '0') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumericoAssoluto(String s) {
        if (s.length() == 0) {
            return false;
        }
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        char[] sArray = s.toCharArray();
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] < '0' || sArray[i] > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAlfabetico(String s) {
        if (s.length() == 0) {
            return false;
        }
        char[] sArray = s.toUpperCase().toCharArray();
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] < 'A' || sArray[i] > 'Z') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isUpperCase(String s) {
        return (s = s.replace('\ufffd', 'S')).toUpperCase().equals(s);
    }

    public static long lire2euro(double in) {
        return Util.lire2euro(in, true);
    }

    public static long lire2euro(double in, boolean isMigliaia) {
        return (long)Util.lire2euro(in, 0, isMigliaia);
    }

    public static double lire2euro(double in, int decimali, boolean isMigliaia) {
        if (isMigliaia) {
            in *= 1000.0;
        }
        double ris = in / 1936.27;
        double divisore = Math.pow(10.0, decimali);
        return (double)Math.round(ris * divisore) / divisore;
    }

    public static String mills2Date(long theTime) {
        long ja;
        long julianDayOffset = 2440588L;
        int millisPerDay = 86400000;
        long gregorianCutover = -12219292800000L;
        long julian = 0L;
        julian = theTime >= 0L ? julianDayOffset + theTime / (long)millisPerDay : julianDayOffset + (theTime - (long)millisPerDay + 1L) / (long)millisPerDay;
        if (theTime >= gregorianCutover) {
            long jalpha = (long)(((double)(julian - 1867216L) - 0.25) / 36524.25);
            ja = julian + 1L + jalpha - (long)(0.25 * (double)jalpha);
        } else {
            ja = julian;
        }
        long jb = ja + 1524L;
        long jc = (long)Math.floor(6680.0 + ((double)(jb - 2439870L) - 122.1) / 365.25);
        long jd = (long)Math.floor((double)(365L * jc) + 0.25 * (double)jc);
        long je = (long)((double)(jb - jd) / 30.6001);
        int date = (int)(jb - jd - (long)(30.6001 * (double)je));
        int month = (int)je - 1;
        if (month > 12) {
            month -= 12;
        }
        int year = (int)(jc - 4715L);
        if (month > 2) {
            --year;
        }
        if (year <= 0) {
            year = 1 - year;
        }
        return String.valueOf(date) + "/" + month + "/" + year;
    }

    public static boolean numerico(String valore) {
        int ldopo;
        int lprima = Util.trimL(valore).length();
        if (lprima != (ldopo = Util.trimL(valore = valore.replace('-', ' ')).length()) && lprima - 1 != ldopo) {
            return false;
        }
        String v = Util.trimL(valore);
        if (v.equals("")) {
            return false;
        }
        if (v.length() == 1 && v.charAt(0) == ',') {
            return false;
        }
        if (v.charAt(0) == ',' || v.charAt(v.length() - 1) == ',') {
            return false;
        }
        if (v.indexOf(",") != v.lastIndexOf(",")) {
            return false;
        }
        char[] vchar = new char[v.length()];
        v.getChars(0, v.length(), vchar, 0);
        int i = 0;
        boolean out = true;
        while (out && i < v.length()) {
            if ((vchar[i] < '0' || vchar[i] > '9') && vchar[i] != ',') {
                out = false;
            }
            ++i;
        }
        return out;
    }

    public static boolean numericoTrim(String valore) throws NumberFormatException {
        block3: {
            try {
                valore = valore.trim();
                if (Double.valueOf(Util.trimL(valore).replace(',', '.')) != 0.0) break block3;
                return Util.trimL(valore).indexOf(" ") == -1 && Util.trimL(valore).indexOf("=") == -1;
            }
            catch (Exception e) {
                return false;
            }
        }
        return Util.trimL(valore).indexOf(" ") == -1 && Util.trimL(valore).indexOf("=") == -1;
    }

    public static String[] ordinaArray(String[] array, boolean az) {
        boolean cicla = true;
        while (cicla) {
            cicla = false;
            int i = 0;
            while (i < array.length - 1) {
                if (az ? array[i].compareTo(array[i + 1]) > 0 : array[i].compareTo(array[i + 1]) < 0) {
                    String appo = array[i];
                    array[i] = array[i + 1];
                    array[i + 1] = appo;
                    cicla = true;
                }
                ++i;
            }
        }
        return array;
    }

    /*
     * Unable to fully structure code
     */
    private static void quickSort(CollationKey[] a, int lo0, int hi0) {
        block5: {
            lo = lo0;
            hi = hi0;
            if (hi0 <= lo0) break block5;
            mid = a[(lo0 + hi0) / 2];
            ** GOTO lbl16
            {
                ++lo;
                do {
                    if (lo < hi0 && a[lo].compareTo(mid) < 0) continue block0;
                    while (hi > lo0 && a[hi].compareTo(mid) > 0) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    Util.swap(a, lo, hi);
                    ++lo;
                    --hi;
lbl16:
                    // 3 sources

                } while (lo <= hi);
            }
            if (lo0 < hi) {
                Util.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                Util.quickSort(a, lo, hi0);
            }
        }
    }

    public static String replaceString(String in, String da, String a) {
        int position = in.indexOf(da);
        String out = "";
        out = position >= 0 ? in.substring(0, position) + a + Util.replaceString(in.substring(position + da.length(), in.length()), da, a) : in;
        return out;
    }

    public static String restituisciDescrizioneCodAtt(String codice) {
        if (BaseTelem.getInstance().getDescCodAtt() == null) {
            try {
                BaseTelem.getInstance().riempiDescCodAtt();
            }
            catch (IOException e) {
                System.out.println("Errore nel caricamento dei Codici Attivit\ufffd");
            }
        }
        return BaseTelem.getInstance().getDescCodAtt(codice);
    }

    public static String restituisciDescrizioneCodUff(String codice) {
        if (BaseTelem.getInstance().getDescCodUff() == null) {
            try {
                BaseTelem.getInstance().riempiDescCodUff();
            }
            catch (IOException e) {
                System.out.println("Errore nel caricamento dei Codici Attivit\ufffd");
            }
        }
        return BaseTelem.getInstance().getDescCodUff(codice);
    }

    public static String restituisciCodUff(String descrizione) {
        if (BaseTelem.getInstance().getDescCodUff() == null) {
            try {
                BaseTelem.getInstance().riempiDescCodUff();
            }
            catch (IOException e) {
                System.out.println("Errore nel caricamento dei Codici Ufficio");
            }
        }
        return BaseTelem.getInstance().getCodUff(descrizione);
    }

    public static float restituisciValoreIntervallo(float valore, float[] tabella, float[] risultato) {
        int i = 0;
        while (i < tabella.length) {
            if (valore <= tabella[i]) {
                return risultato[i];
            }
            ++i;
        }
        return risultato[risultato.length - 1];
    }

    public static void sort(String[] dirList) {
        if (dirList != null && dirList.length > 0) {
            Collator collator = Collator.getInstance();
            CollationKey[] keys = new CollationKey[dirList.length];
            int i = 0;
            while (i < dirList.length) {
                keys[i] = collator.getCollationKey(dirList[i]);
                ++i;
            }
            Util.quickSort(keys, 0, dirList.length - 1);
            i = 0;
            while (i < dirList.length) {
                dirList[i] = keys[i].getSourceString();
                ++i;
            }
        }
    }

    public static void substituteString(char[] in, String r, int offset) {
        char[] a = r.toCharArray();
        if (offset + r.length() > in.length) {
            throw new StringIndexOutOfBoundsException(offset + r.length());
        }
        int i = offset;
        while (i < offset + a.length) {
            in[i] = r.charAt(i - offset);
            ++i;
        }
    }

    private static void swap(CollationKey[] a, int i, int j) {
        CollationKey T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    public static String trimL(String s) {
        int len = s.length();
        int st = 0;
        char[] value = s.toCharArray();
        while (st < len && value[st] <= ' ') {
            ++st;
        }
        return st > 0 || len < s.length() ? s.substring(st, len) : s;
    }

    public static String trimR(String s) {
        int len = s.length();
        int st = 0;
        char[] value = s.toCharArray();
        while (st < len && value[len - 1] <= ' ') {
            --len;
        }
        return st > 0 || len < s.length() ? s.substring(st, len) : s;
    }

    public static double valoreDouble(String valore) {
        double numD = 0.0;
        try {
            String str = new String();
            str = Util.trimL(valore).replace(',', '.');
            numD = Double.valueOf(str);
        }
        catch (Exception e) {
            System.out.println("Errore nel metodo valoreDouble Stringa:" + valore);
        }
        return numD;
    }

    public static float valoreFloat(String valore) {
        float numf = 0.0f;
        try {
            String str = new String();
            str = Util.trimL(valore).replace(',', '.');
            numf = Float.valueOf(str).floatValue();
        }
        catch (Exception e) {
            System.out.println("Errore nel metodo valoreDouble Stringa:" + valore);
        }
        return numf;
    }

    public static int valoreInt(String valore) {
        int numI = 0;
        try {
            numI = Integer.valueOf(Util.trimL(valore));
        }
        catch (Exception e) {
            System.out.println("Errore nel metodo valoreInt Stringa:" + valore);
        }
        return numI;
    }

    public static long valoreLong(String valore) {
        long numL = 0L;
        try {
            numL = Long.valueOf(Util.trimL(valore));
        }
        catch (Exception e) {
            System.out.println("Errore nel metodo valoreLong Stringa:" + valore);
        }
        return numL;
    }

    public static String versionWithoutPoint(String version) {
        StringTokenizer st = new StringTokenizer(version, ".");
        String token = "";
        while (st.hasMoreTokens()) {
            String appTok = Util.formNum(2, st.nextToken());
            token = String.valueOf(token) + appTok;
        }
        if (token.length() < 5) {
            token = String.valueOf(token) + Util.formNum(6 - token.length(), "");
        }
        return token;
    }

    public static String dateXML2Telem(String date) {
        if (date.length() != 10) {
            return "";
        }
        return String.valueOf(date.substring(8)) + date.substring(5, 7) + date.substring(0, 4);
    }

    public static boolean isVer1MagUgualeVer2(String ver1, String ver2) {
        StringTokenizer v1 = new StringTokenizer(ver1, ".");
        StringTokenizer v2 = new StringTokenizer(ver2, ".");
        String verString1 = "";
        String verString2 = "";
        int cicli = v1.countTokens() > v2.countTokens() ? v1.countTokens() : v2.countTokens();
        int i = 0;
        while (i < cicli) {
            verString1 = String.valueOf(verString1) + Util.formNum(3, v1.hasMoreTokens() ? v1.nextToken() : "0");
            verString2 = String.valueOf(verString2) + Util.formNum(3, v2.hasMoreTokens() ? v2.nextToken() : "0");
            ++i;
        }
        System.out.println(verString1.compareTo(verString2));
        return verString1.compareTo(verString2) >= 0;
    }

    public static int restituisciTipoRecB(int dataIndex) {
        int out = BaseTelem.getInstance().getRecordBcontrolli().getFormatoAt(dataIndex - 1);
        return out;
    }

    public static boolean isUTF8(byte[] sequence) {
        int i = 0;
        while (i < sequence.length) {
            byte b = sequence[i];
            if ((b >> 6 & 3) == 2) {
                return false;
            }
            byte test = b;
            int numberBytesInChar = 0;
            while ((test & 0x80) > 0) {
                test = (byte)(test << 1);
                ++numberBytesInChar;
            }
            if (numberBytesInChar > 1) {
                int j = 1;
                while (j < numberBytesInChar) {
                    if (i + j >= sequence.length) {
                        return false;
                    }
                    if ((sequence[i + j] >> 6 & 3) != 2) {
                        return false;
                    }
                    ++j;
                }
                i += numberBytesInChar - 1;
            }
            ++i;
        }
        return true;
    }
}

