/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.campi;

import finanze.IDTE.studi2002.campi.ControlloFormaleException;
import finanze.IDTE.studi2002.campi.NumericModel;

public class ProgressivoStudioModel
extends NumericModel {
    private long valorePredefinito;
    private long maxValue;
    private long minValue;

    public ProgressivoStudioModel(String code, String errorDescription, int length, long minValue, long maxValue) {
        super(code, errorDescription, length);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valorePredefinito = minValue;
        this.setValorePredefinito();
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public String getValorePredefinito() {
        return String.valueOf(this.valorePredefinito);
    }

    public boolean isValorePredefinito() {
        return this.getNumericValue() == this.valorePredefinito;
    }

    public void setValore(String s) throws ControlloFormaleException {
        String val = s.trim();
        if (val.length() > this.length()) {
            this.errore = "020";
            this.gravitaErrore = "scarto";
            throw new ControlloFormaleException(val);
        }
        if (!this.isNumeric(val)) {
            this.errore = "011";
            this.gravitaErrore = "scarto";
            throw new ControlloFormaleException(val);
        }
        this.valore = val;
        if (this.isNumeric(val) && (this.getNumericValue() < this.minValue || this.getNumericValue() > this.maxValue)) {
            this.setValorePredefinito();
            this.errore = "012";
            this.gravitaErrore = "scarto_confermabile";
            throw new ControlloFormaleException(val);
        }
    }

    public void setValorePredefinito() {
        this.valore = String.valueOf(this.valorePredefinito);
    }
}

