/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferB;
import java.nio.ByteBufferAsCharBufferL;
import java.nio.ByteBufferAsDoubleBufferB;
import java.nio.ByteBufferAsDoubleBufferL;
import java.nio.ByteBufferAsFloatBufferB;
import java.nio.ByteBufferAsFloatBufferL;
import java.nio.ByteBufferAsIntBufferB;
import java.nio.ByteBufferAsIntBufferL;
import java.nio.ByteBufferAsLongBufferB;
import java.nio.ByteBufferAsLongBufferL;
import java.nio.ByteBufferAsShortBufferB;
import java.nio.ByteBufferAsShortBufferL;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.HeapByteBufferR;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

class HeapByteBuffer
extends ByteBuffer {
    HeapByteBuffer(int n, int n2) {
        super(-1, 0, n2, n, new byte[n], 0);
    }

    HeapByteBuffer(byte[] byArray, int n, int n2) {
        super(-1, n, n + n2, byArray.length, byArray, 0);
    }

    protected HeapByteBuffer(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, byArray, n5);
    }

    @Override
    public ByteBuffer slice() {
        int n;
        int n2 = this.position();
        int n3 = n2 <= (n = this.limit()) ? n - n2 : 0;
        return new HeapByteBuffer(this.hb, -1, 0, n3, n3, n2 + this.offset);
    }

    @Override
    public ByteBuffer duplicate() {
        return new HeapByteBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return new HeapByteBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n) {
        return n + this.offset;
    }

    @Override
    public byte get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public byte get(int n) {
        return this.hb[this.ix(this.checkIndex(n))];
    }

    @Override
    public ByteBuffer get(byte[] byArray, int n, int n2) {
        HeapByteBuffer.checkBounds(n, n2, byArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), byArray, n, n2);
        this.position(this.position() + n2);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteBuffer put(byte by) {
        this.hb[this.ix((int)this.nextPutIndex())] = by;
        return this;
    }

    @Override
    public ByteBuffer put(int n, byte by) {
        this.hb[this.ix((int)this.checkIndex((int)n))] = by;
        return this;
    }

    @Override
    public ByteBuffer put(byte[] byArray, int n, int n2) {
        HeapByteBuffer.checkBounds(n, n2, byArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(byArray, n, this.hb, this.ix(this.position()), n2);
        this.position(this.position() + n2);
        return this;
    }

    @Override
    public ByteBuffer put(ByteBuffer byteBuffer) {
        if (byteBuffer instanceof HeapByteBuffer) {
            if (byteBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapByteBuffer heapByteBuffer = (HeapByteBuffer)byteBuffer;
            int n = heapByteBuffer.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(heapByteBuffer.hb, heapByteBuffer.ix(heapByteBuffer.position()), this.hb, this.ix(this.position()), n);
            heapByteBuffer.position(heapByteBuffer.position() + n);
            this.position(this.position() + n);
        } else if (byteBuffer.isDirect()) {
            int n = byteBuffer.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            byteBuffer.get(this.hb, this.ix(this.position()), n);
            this.position(this.position() + n);
        } else {
            super.put(byteBuffer);
        }
        return this;
    }

    @Override
    public ByteBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    byte _get(int n) {
        return this.hb[n];
    }

    @Override
    void _put(int n, byte by) {
        this.hb[n] = by;
    }

    @Override
    public char getChar() {
        return Bits.getChar(this, this.ix(this.nextGetIndex(2)), this.bigEndian);
    }

    @Override
    public char getChar(int n) {
        return Bits.getChar(this, this.ix(this.checkIndex(n, 2)), this.bigEndian);
    }

    @Override
    public ByteBuffer putChar(char c) {
        Bits.putChar(this, this.ix(this.nextPutIndex(2)), c, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putChar(int n, char c) {
        Bits.putChar(this, this.ix(this.checkIndex(n, 2)), c, this.bigEndian);
        return this;
    }

    @Override
    public CharBuffer asCharBuffer() {
        int n = this.remaining() >> 1;
        int n2 = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsCharBufferB(this, -1, 0, n, n, n2) : new ByteBufferAsCharBufferL(this, -1, 0, n, n, n2);
    }

    @Override
    public short getShort() {
        return Bits.getShort(this, this.ix(this.nextGetIndex(2)), this.bigEndian);
    }

    @Override
    public short getShort(int n) {
        return Bits.getShort(this, this.ix(this.checkIndex(n, 2)), this.bigEndian);
    }

    @Override
    public ByteBuffer putShort(short s) {
        Bits.putShort(this, this.ix(this.nextPutIndex(2)), s, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putShort(int n, short s) {
        Bits.putShort(this, this.ix(this.checkIndex(n, 2)), s, this.bigEndian);
        return this;
    }

    @Override
    public ShortBuffer asShortBuffer() {
        int n = this.remaining() >> 1;
        int n2 = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsShortBufferB(this, -1, 0, n, n, n2) : new ByteBufferAsShortBufferL(this, -1, 0, n, n, n2);
    }

    @Override
    public int getInt() {
        return Bits.getInt(this, this.ix(this.nextGetIndex(4)), this.bigEndian);
    }

    @Override
    public int getInt(int n) {
        return Bits.getInt(this, this.ix(this.checkIndex(n, 4)), this.bigEndian);
    }

    @Override
    public ByteBuffer putInt(int n) {
        Bits.putInt(this, this.ix(this.nextPutIndex(4)), n, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putInt(int n, int n2) {
        Bits.putInt(this, this.ix(this.checkIndex(n, 4)), n2, this.bigEndian);
        return this;
    }

    @Override
    public IntBuffer asIntBuffer() {
        int n = this.remaining() >> 2;
        int n2 = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsIntBufferB(this, -1, 0, n, n, n2) : new ByteBufferAsIntBufferL(this, -1, 0, n, n, n2);
    }

    @Override
    public long getLong() {
        return Bits.getLong(this, this.ix(this.nextGetIndex(8)), this.bigEndian);
    }

    @Override
    public long getLong(int n) {
        return Bits.getLong(this, this.ix(this.checkIndex(n, 8)), this.bigEndian);
    }

    @Override
    public ByteBuffer putLong(long l) {
        Bits.putLong(this, this.ix(this.nextPutIndex(8)), l, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putLong(int n, long l) {
        Bits.putLong(this, this.ix(this.checkIndex(n, 8)), l, this.bigEndian);
        return this;
    }

    @Override
    public LongBuffer asLongBuffer() {
        int n = this.remaining() >> 3;
        int n2 = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsLongBufferB(this, -1, 0, n, n, n2) : new ByteBufferAsLongBufferL(this, -1, 0, n, n, n2);
    }

    @Override
    public float getFloat() {
        return Bits.getFloat(this, this.ix(this.nextGetIndex(4)), this.bigEndian);
    }

    @Override
    public float getFloat(int n) {
        return Bits.getFloat(this, this.ix(this.checkIndex(n, 4)), this.bigEndian);
    }

    @Override
    public ByteBuffer putFloat(float f) {
        Bits.putFloat(this, this.ix(this.nextPutIndex(4)), f, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putFloat(int n, float f) {
        Bits.putFloat(this, this.ix(this.checkIndex(n, 4)), f, this.bigEndian);
        return this;
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        int n = this.remaining() >> 2;
        int n2 = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsFloatBufferB(this, -1, 0, n, n, n2) : new ByteBufferAsFloatBufferL(this, -1, 0, n, n, n2);
    }

    @Override
    public double getDouble() {
        return Bits.getDouble(this, this.ix(this.nextGetIndex(8)), this.bigEndian);
    }

    @Override
    public double getDouble(int n) {
        return Bits.getDouble(this, this.ix(this.checkIndex(n, 8)), this.bigEndian);
    }

    @Override
    public ByteBuffer putDouble(double d) {
        Bits.putDouble(this, this.ix(this.nextPutIndex(8)), d, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putDouble(int n, double d) {
        Bits.putDouble(this, this.ix(this.checkIndex(n, 8)), d, this.bigEndian);
        return this;
    }

    @Override
    public DoubleBuffer asDoubleBuffer() {
        int n = this.remaining() >> 3;
        int n2 = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsDoubleBufferB(this, -1, 0, n, n, n2) : new ByteBufferAsDoubleBufferL(this, -1, 0, n, n, n2);
    }
}

