/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.security.cipher.CAST128ParameterSpec;
import iaik.utils.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class CAST128Parameters
extends AlgorithmParametersSpi {
    byte[] b;
    int a;

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("keyLength: " + this.a + "\n");
        stringBuffer.append("IV: ");
        if (this.b == null) {
            stringBuffer.append("00:00:00:00:00:00:00:00\n");
        } else {
            stringBuffer.append("IV: " + Util.toString(this.b) + "\n");
        }
        return stringBuffer.toString();
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1Object aSN1Object = DerCoder.decode(byArray);
            if (aSN1Object.isA(ASN.SEQUENCE)) {
                this.b = (byte[])aSN1Object.getComponentAt(0).getValue();
                this.a = ((BigInteger)aSN1Object.getComponentAt(1).getValue()).intValue();
                return;
            }
            if (aSN1Object.isA(ASN.OCTET_STRING)) {
                this.a = -1;
                this.b = (byte[])aSN1Object.getValue();
                return;
            }
            throw new IOException("Cannot decode CAST params. Invalid ASN.1 type!");
        }
        catch (CodingException codingException) {
            throw new IOException("DER decoding error. " + codingException.toString());
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof CAST128ParameterSpec) {
            CAST128ParameterSpec cAST128ParameterSpec = (CAST128ParameterSpec)algorithmParameterSpec;
            this.a = cAST128ParameterSpec.getKeyLength();
            this.b = cAST128ParameterSpec.getIV();
            if (this.b != null && this.b.length != 8) {
                throw new InvalidParameterSpecException("IV must be 8 octets long!");
            }
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            this.b = ivParameterSpec.getIV();
            this.a = -1;
            if (this.b != null && this.b.length != 8) {
                throw new InvalidParameterSpecException("IV must be 8 octets long!");
            }
        } else {
            throw new InvalidParameterSpecException("Parameter must be a CAST128ParameterSpec.");
        }
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        CAST128ParameterSpec cAST128ParameterSpec = new CAST128ParameterSpec(this.a, this.b);
        if (!cAST128ParameterSpec.getClass().isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return cAST128ParameterSpec;
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected byte[] engineGetEncoded() throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.b != null && !this.a(this.b)) {
            sEQUENCE.addComponent(new OCTET_STRING(this.b));
        }
        sEQUENCE.addComponent(new INTEGER(this.a));
        return DerCoder.encode(sEQUENCE);
    }

    private boolean a(byte[] byArray) {
        if (byArray != null) {
            int n2 = 0;
            while (n2 < byArray.length) {
                if (byArray[n2] != 0) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }
}

