/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.pkcs.NetscapeCertList;
import iaik.pkcs.PKCS7CertList;
import iaik.pkcs.PKCSException;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class X509CertPath
extends CertPath {
    private X509Certificate[] b;
    private static final String c = "X.509";
    private static final List a;
    public static final String DEFAULT_ENCODING_FORMAT = "PkiPath";
    public static final String NETSCAPE = "NETSCAPE";
    public static final String PKCS7 = "PKCS7";
    public static final String PEM = "PEM";
    public static final String DER = "DER";
    static final String d;
    public static final String PKI_PATH = "PkiPath";

    public Iterator getEncodings() {
        return a.iterator();
    }

    public byte[] getEncoded(String string) throws CertificateEncodingException {
        if (string == null) {
            throw new NullPointerException("encoding must not be null!");
        }
        byte[] byArray = null;
        String string2 = string.toUpperCase();
        if (string2.equals(d)) {
            byArray = this.getEncoded();
        } else if (string2.equals(DER)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            try {
                int n2 = 0;
                while (n2 < this.b.length) {
                    this.b[n2].writeTo(byteArrayOutputStream);
                    ++n2;
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new CertificateEncodingException(iOException.toString());
            }
        } else if (string2.equals(PEM)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            try {
                int n3 = 0;
                while (n3 < this.b.length) {
                    byteArrayOutputStream.write(Util.toPemArray(this.b[n3]));
                    ++n3;
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new CertificateEncodingException(iOException.toString());
            }
        } else if (string2.equals(PKCS7)) {
            PKCS7CertList pKCS7CertList = new PKCS7CertList();
            pKCS7CertList.setCertificateList(this.b);
            try {
                byArray = pKCS7CertList.toByteArray();
            }
            catch (PKCSException pKCSException) {
                throw new CertificateEncodingException(pKCSException.toString());
            }
        } else if (string2.equals(NETSCAPE)) {
            NetscapeCertList netscapeCertList = new NetscapeCertList();
            netscapeCertList.setCertificateList(this.b);
            try {
                byArray = netscapeCertList.toByteArray();
            }
            catch (PKCSException pKCSException) {
                throw new CertificateEncodingException(pKCSException.toString());
            }
        } else {
            throw new CertificateEncodingException("Requested encoding format \"" + string + "\" not supported!");
        }
        return byArray;
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            Object[] objectArray = new X509Certificate[this.b.length];
            if (objectArray.length > 0) {
                System.arraycopy(this.b, 0, objectArray, 0, this.b.length);
                Util.reverseArray(objectArray, 0, objectArray.length);
            }
            return Util.encodeAsPkiPath((X509Certificate[])objectArray, false);
        }
        catch (CertificateException certificateException) {
            throw new CertificateEncodingException(certificateException.toString());
        }
    }

    public List getCertificates() {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        int n2 = 0;
        while (n2 < this.b.length) {
            arrayList.add(this.b[n2]);
            ++n2;
        }
        return Collections.unmodifiableList(arrayList);
    }

    static Iterator a() {
        return a.iterator();
    }

    public X509CertPath(X509Certificate[] x509CertificateArray) {
        super(c);
        if (x509CertificateArray == null) {
            throw new NullPointerException("Certificates must not be null!");
        }
        X509Certificate[] x509CertificateArray2 = null;
        if (x509CertificateArray.length > 0) {
            x509CertificateArray2 = Util.arrangeCertificateChain(x509CertificateArray, false);
        }
        this.b = x509CertificateArray2 == null ? x509CertificateArray : x509CertificateArray2;
    }

    public X509CertPath(List list) throws CertificateException {
        super(c);
        Object object;
        if (list == null) {
            throw new NullPointerException("Certificates must not be null!");
        }
        this.b = new X509Certificate[list.size()];
        Iterator iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object instanceof java.security.cert.X509Certificate) {
                this.b[n2++] = Util.convertCertificate((java.security.cert.X509Certificate)object);
                continue;
            }
            throw new CertificateException("Certificate list must contain X509Certificate objects only!");
        }
        if (this.b.length > 0 && (object = Util.arrangeCertificateChain(this.b, false)) != null) {
            this.b = object;
        }
    }

    static {
        d = "PkiPath".toUpperCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("PkiPath");
        arrayList.add(DER);
        arrayList.add(PEM);
        arrayList.add(PKCS7);
        arrayList.add(NETSCAPE);
        a = Collections.unmodifiableList(arrayList);
    }
}

