/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.util;

import iaik.security.ecc.math.algorithms.AlgorithmException;
import iaik.security.ecc.math.algorithms.SquareRoot;
import iaik.security.ecc.math.ecgroup.AffineCoordinate;
import iaik.security.ecc.math.ecgroup.EllipticCurve;
import iaik.security.ecc.math.field.BinaryField;
import iaik.security.ecc.math.field.FieldElement;
import iaik.security.ecc.util.PointCompressor;

class CompressorImpl
implements PointCompressor {
    protected AffineCoordinate primeDecompress(FieldElement fieldElement, int n, EllipticCurve ellipticCurve) throws AlgorithmException {
        boolean bl;
        FieldElement fieldElement2 = FieldElement.square(fieldElement);
        fieldElement2.multiply(fieldElement);
        fieldElement2.add(FieldElement.multiply(fieldElement, ellipticCurve.getA()));
        fieldElement2.add(ellipticCurve.getB());
        FieldElement fieldElement3 = SquareRoot.calcSQRT(fieldElement2);
        if (fieldElement3 == null) {
            throw new AlgorithmException("Couldn't decompress the point");
        }
        boolean bl2 = bl = n == 1;
        if (fieldElement3.testBit(0) ^ bl) {
            fieldElement3.negate();
        }
        return new AffineCoordinate(fieldElement, fieldElement3);
    }

    protected byte[] primeCompress(FieldElement fieldElement, FieldElement fieldElement2) {
        byte[] byArray = fieldElement.toByteArray();
        byte[] byArray2 = fieldElement2.toByteArray();
        byte[] byArray3 = new byte[1 + byArray.length];
        System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
        byArray3[0] = 2;
        byArray3[0] = (byte)(byArray3[0] | byArray2[0] & 1);
        return byArray3;
    }

    protected AffineCoordinate binaryDecompress(FieldElement fieldElement, int n, EllipticCurve ellipticCurve) throws AlgorithmException {
        boolean bl;
        if (fieldElement.isZero()) {
            FieldElement fieldElement2 = (FieldElement)ellipticCurve.getB().clone();
            int n2 = ((BinaryField)fieldElement.getField()).getOrder() - 1;
            int n3 = 0;
            while (n3 < n2) {
                fieldElement2.square();
                ++n3;
            }
            return new AffineCoordinate(fieldElement, fieldElement2);
        }
        FieldElement fieldElement3 = FieldElement.square(fieldElement);
        fieldElement3.invert();
        fieldElement3.multiply(ellipticCurve.getB()).add(ellipticCurve.getA()).add(fieldElement);
        FieldElement fieldElement4 = SquareRoot.calcSQRT(fieldElement3);
        if (fieldElement4 == null) {
            throw new AlgorithmException("Could not decompress the point");
        }
        boolean bl2 = bl = n == 1;
        if (fieldElement4.testBit(0) ^ bl) {
            fieldElement4.add(fieldElement4.getField().getONEelement());
        }
        fieldElement4.multiply(fieldElement);
        return new AffineCoordinate(fieldElement, fieldElement4);
    }

    protected byte[] binaryCompress(FieldElement fieldElement, FieldElement fieldElement2) {
        byte[] byArray = fieldElement.toByteArray();
        byte[] byArray2 = new byte[1 + byArray.length];
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        byArray2[0] = 2;
        if (fieldElement.isZero()) {
            return byArray2;
        }
        byte by = ((FieldElement)fieldElement.clone()).invert().multiply(fieldElement2).toByteArray()[0];
        byArray2[0] = (byte)(byArray2[0] | by & 1);
        return byArray2;
    }

    public AffineCoordinate decompress(FieldElement fieldElement, int n, EllipticCurve ellipticCurve) throws AlgorithmException {
        if (n != 0 && n != 1) {
            throw new AlgorithmException("Invalid y bit");
        }
        switch (fieldElement.getField().getFieldId()) {
            case 1: {
                return this.primeDecompress(fieldElement, n, ellipticCurve);
            }
            case 2: {
                return this.binaryDecompress(fieldElement, n, ellipticCurve);
            }
        }
        throw new AlgorithmException("Unknown fiel id");
    }

    public byte[] compress(FieldElement fieldElement, FieldElement fieldElement2) {
        if (fieldElement.getField().getFieldId() == 1) {
            return this.primeCompress(fieldElement, fieldElement2);
        }
        if (fieldElement.getField().getFieldId() == 2) {
            return this.binaryCompress(fieldElement, fieldElement2);
        }
        throw new RuntimeException("Inknown  field id");
    }

    CompressorImpl() {
    }
}

